/* Copyright (c) 2001-2011, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.dose;

public class ScanRange {
	
	protected String startDirection;
	protected String startLocation;
	protected String endDirection;
	protected String endLocation;
	protected String absoluteRange;

	public ScanRange(String startDirection,String startLocation,String endDirection,String endLocation) {
		this.startDirection = startDirection;
		this.startLocation = startLocation;
		this.endDirection = endDirection;
		this.endLocation = endLocation;
		this.absoluteRange = null;
	}
	
	public ScanRange(String signedStartLocation,String signedEndLocation) {
		this.startDirection = signedStartLocation.startsWith("-") ? "I" : "S";
		this.startLocation = signedStartLocation.replaceFirst("[+-]","");
		this.endDirection =  signedEndLocation.startsWith("-") ? "I" : "S";
		this.endLocation = signedEndLocation.replaceFirst("[+-]","");
		this.absoluteRange = null;
	}
	
	public String getStartDirection() { return startDirection; }
	public String getStartLocation() { return startLocation; }
	public String getEndDirection() { return endDirection; }
	public String getEndLocation() { return endLocation; }
	
	public String getAbsoluteRange() {
//System.err.println("ScanRange.getAbsoluteRange(): from "+this);
//System.err.print("ScanRange.getAbsoluteRange():\n"+dump());
		if (absoluteRange == null) {
			double start = Double.parseDouble(startLocation);
//System.err.println("ScanRange.getAbsoluteRange(): start = "+start);
			if (startDirection.equals("I")) {
				start = -start;
//System.err.println("ScanRange.getAbsoluteRange(): start is I so making start -ve now = "+start);
			}
			double end = Double.parseDouble(endLocation);
//System.err.println("ScanRange.getAbsoluteRange(): end = "+end);
			if (endDirection.equals("I")) {
				end = -end;
//System.err.println("ScanRange.getAbsoluteRange(): end is I so making end -ve now = "+start);
			}
			double r = start - end;
//System.err.println("ScanRange.getAbsoluteRange(): r = "+r);
			if (r < 0) {
				r = -r;
//System.err.println("ScanRange.getAbsoluteRange(): r is -ve so changing sign now = "+r);
			}
			java.text.DecimalFormat formatter = (java.text.DecimalFormat)(java.text.NumberFormat.getInstance());
			formatter.setMaximumFractionDigits(3);
			formatter.setMinimumFractionDigits(3);
			formatter.setDecimalSeparatorAlwaysShown(true);		// i.e., a period even if fraction is zero
			formatter.setGroupingUsed(false);					// i.e., no comma at thousands
			absoluteRange = formatter.format(r);
//System.err.println("ScanRange.getAbsoluteRange(): returns formatted string "+absoluteRange+" for "+Double.toString(r));
		}
		return absoluteRange;
	}
	
//	private String dump() {
//		StringBuffer buf = new StringBuffer();
//		buf.append("startDirection = \"");
//		buf.append(startDirection);
//		buf.append("\"\n");
//		buf.append("startLocation = \"");
//		buf.append(startLocation);
//		buf.append("\"\n");
//		buf.append("endDirection = \"");
//		buf.append(endDirection);
//		buf.append("\"\n");
//		buf.append("endLocation = \"");
//		buf.append(endLocation);
//		buf.append("\"\n");
//		return buf.toString();
//	}
	
	public String toString() {
		return startDirection + startLocation + "-" + endDirection + endLocation;
	}
	
	public boolean equals(Object o) {
		//System.err.println("Location.equals(): comparing "+this+" to "+o);
		boolean isEqual = false;
		if (o instanceof ScanRange) {
			ScanRange osr = (ScanRange)o;
			isEqual = osr.getStartDirection().equals(this.getStartDirection())
				   && osr.getStartLocation().equals(this.getStartLocation())
				   && osr.getEndDirection().equals(this.getEndDirection())
				   && osr.getEndLocation().equals(this.getEndLocation());
		}
		else {
			isEqual = false;
		}
		return isEqual;
	}
	
	public int hashCode() {
		return getStartDirection().hashCode()
			 + getStartLocation().hashCode()
			 + getEndDirection().hashCode()
			 + getEndLocation().hashCode();	// sufficient to implement equals() contract
	}
}
