#ifndef __KIF_DIALOGS_H
#define __KIF_DIALOGS_H

#include <qdialog.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <knuminput.h>
#include <kprinter.h>

class KDoubleNumInput;
class QLineEdit;
class QDoubleValidator;
class QListBox;
class QListView;
class QListViewItem;
class QComboBox;
class QButtonGroup;

class KIFSizeDialog : public QDialog
{
    Q_OBJECT
public:
    KIFSizeDialog(int w, int h, QWidget *parent=0, const char *name=0);
    int resultWidth(){return(wEdit->value());}
    int resultHeight(){return(hEdit->value());}
protected slots:
    void slotWidthChanged(int);
    void slotHeightChanged(int);
protected:
    int origW, origH;
    QCheckBox *aspectCB;
    KIntNumInput *wEdit, *hEdit;
    bool ignoreSignals;
};

class KIFPrintDialog : public QDialog
{
    Q_OBJECT
public:
    KIFPrintDialog(KPrinter &printer, QWidget *parent=0,
                   const char *name=0);
    //void margins(int &l, int &r, int &t, int &b);
protected slots:
    void slotOptionClicked();
    void slotMetricsClicked(int id);
    void accept();
protected:
    QComboBox *metricBox;
    QCheckBox *scaleLarge, *zoomSmall, *manualDither;
    //KDoubleNumInput *lEdit, *rEdit, *tEdit, *bEdit;
    QLineEdit *lEdit, *rEdit, *tEdit, *bEdit;
    QDoubleValidator *validator;
    bool doSave;
};

class KIFSlideDialog : public QDialog
{
    Q_OBJECT
public:
    KIFSlideDialog(QWidget *parent=0, const char *name=0);
    bool loop(){return(loopCB->isChecked());}
    int delay(){return(delayEdit->value());}
    int animationDelay(){return(aniDelayEdit->value());}
    int effect();
    bool useFileList(){return(fileListBtn->isChecked());}
    bool useDirList(){return(dirListBtn->isChecked());}
    bool useMaxpect(){return(maxCB->isChecked());}
protected slots:
    void slotAccepted();
protected:
    QButtonGroup *btnGrp;
    QComboBox *effectBox;
    QCheckBox *loopCB, *maxCB;
    KIntNumInput *delayEdit, *aniDelayEdit;
    QRadioButton *fileListBtn, *dirListBtn;
};

class CatagoryDialog : public QDialog
{
    Q_OBJECT
public:
    CatagoryDialog(QWidget *parent=0, const char *name=0);
    void sync();
protected slots:
    void slotAdd();
    void slotRemove();
    void slotSelectionChanged();
protected:
    QListBox *listBox;
    QPushButton *removeBtn;
    bool modified;
};

class ConvertDialog : public QDialog
{
    Q_OBJECT
public:
    ConvertDialog(QWidget *parent=0, const char *name=0);
    QString extension();
    QString format();
protected slots:
    void slotFormatClicked(QListViewItem *i);
    void slotFormatDoubleClicked(QListViewItem *i);
    void slotShowAll();
    void slotAccept();
protected:
    QListView *listView;
    QLineEdit *extEdit;
    QPushButton *showAllBtn;
};

class FormatDialog : public QDialog
{
    Q_OBJECT
public:
    FormatDialog(const QString &extStr, QWidget *parent=0, const char *name=0);
    QString format();
protected slots:
    void slotFormatDoubleClicked(QListViewItem *i);
    void slotShowAll();
    void slotAccept();
protected:
    QListView *listView;
    QPushButton *showAllBtn;
};

#endif

