#ifndef __KIF_FULLSCREEN_H
#define __KIF_FULLSCREEN_H

#include "imagebuffer.h"
#include <qwidget.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qcolor.h>
#include <qvariant.h>
#include <qdir.h>
#include <X11/X.h>
#include <X11/Xlib.h>

class KIFFullScreenHandle : public QButton
{
    Q_OBJECT
public:
    KIFFullScreenHandle(QWidget *parent=0, const char *name=0);
    QSize sizeHint() const;
protected:
    void drawButton(QPainter *p);
};

class KIFFullScreen : public QWidget
{
    Q_OBJECT
public:
    KIFFullScreen(KIFImage *image, bool maxpect,
                  QWidget *parent=0, const char *name=0,
                  bool dirBtnEnabled = true);
    ~KIFFullScreen();
    void setColor(const QColor &c);

    QToolButton *nextListBtn, *prevListBtn, *nextImageBtn, *prevImageBtn;
public slots:
    void slotUpdateFromImage();
    void slotInvalidFile();
signals:
    void prevList();
    void nextList();
    void nextImage();
    void prevImage();
    void finished();
protected slots:
    void slotNextListClicked();
    void slotPrevListClicked();
    void slotNextImageClicked();
    void slotPrevImageClicked();
    void slotIncBrightnessClicked();
    void slotDecBrightnessClicked();
    void slotIncContrastClicked();
    void slotDecContrastClicked();
    void slotRotateClicked();
    void slotZoomClicked();
    void slotHandleToggled(bool on);
protected:
    void paintEvent(QPaintEvent *ev);
    void closeEvent(QCloseEvent *ev);
    void mousePressEvent(QMouseEvent *ev);
    void keyPressEvent(QKeyEvent *ev);
    void scale(QImage &tmpImage);

    QToolButton *incContrastBtn, *decContrastBtn, *rotateBtn, *zoomBtn;
    QToolButton *incBrightnessBtn, *decBrightnessBtn;
    KIFFullScreenHandle *handle;

    QPixmap pix;
    KIFImage *imageBuffer;
    bool max, maxBtnClicked;
    QColor c;
    GC gc;
};


#endif


