#ifndef __KIF_HOTLISTBOX_H
#define __KIF_HOTLISTBOX_H

#include <qlistbox.h>
#include <qstringlist.h>
class QToolButton;
class UIManager;

class KIFHotListBox : public QListBox
{
    Q_OBJECT
public:
    KIFHotListBox(UIManager *manager, QWidget *parent=0, const char *name=0);
    void reload();
signals:
    void hotListClicked(const QString &path);
protected slots:
    void slotAddClicked();
    void slotDelClicked();
    void slotSelected(int idx);
protected:
    void paintCell(QPainter *p, int r, int c);
    void dragEnterEvent(QDragEnterEvent *ev);
    void dragLeaveEvent(QDragLeaveEvent *ev);
    void dragMoveEvent(QDragMoveEvent *ev);
    void dropEvent(QDropEvent *ev);
    void resizeEvent(QResizeEvent *ev);

    QListBoxItem *lastDndHighlight;
    QToolButton *addBtn, *delBtn;
    QStringList paths;
    UIManager *mgr;
};

#endif


