#ifndef __KIF_IMAGEHEADERS_H
#define __KIF_IMAGEHEADERS_H

class QImage;
#include <qstring.h>

bool isAnimatedGIF(const char *fn);
bool checkTIFFThumbnail(const char *filename, QImage &img);

bool appendTooltipData(const char *filename, QString &imageStr,
                       QString &cameraStr, QString &commentStr,
                       bool isRTF);

bool appendPNGTooltipData(const char *filename, QString &imageStr,
                          QString &commentStr, bool isRTF);
bool appendJPEGTooltipData(const char *filename, QString &imageStr,
                           QString &cameraStr, QString &commentStr,
                           bool isRTF);
bool appendTIFFTooltipData(const char *filename, QString &imageStr,
                           QString &scannerStr, QString &commentStr,
                           bool isRTF);
bool appendGIFTooltipData(const char *filename, QString &imageStr,
                          bool isRTF);
bool appendBMPTooltipData(const char *filename, QString &imageStr,
                          bool isRTF);

#endif


