#include "imagepreview.h"
#include "imageutils.h"
#include <qpainter.h>
#include <qapplication.h>
#include <klocale.h>
#include <kstandarddirs.h>


KIFImagePreview::KIFImagePreview(QWidget *parent, const char *name)
    : QWidget(parent, name)
{
    setBackgroundMode(NoBackground);

    // FIXME - load only if no file specified
    int textW, logoW, startY;
    QPixmap *logoPix = new QPixmap(KGlobal::dirs()->findResource("appdata",
                                                                 "pixielogo.jpg"));
    logoW = logoPix->width();
    QFont fnt(font());
    fnt.setBold(true);
    fnt.setPointSize(14);
    QFontMetrics fm(fnt);
    textW = fm.width(i18n("(C)2001-2003 Daniel M. Duley, www.mosfet.org"))+4;
    if(textW > logoW)
        logoW = textW;
    textW = fm.width(i18n("Logo courtesy of THOS, www.thos.co.za"))+4;
    if(textW > logoW)
        logoW = textW;
    startY = logoPix->height();

    QPixmap *formattedPix = new QPixmap(logoW,
                                        logoPix->height()+fm.lineSpacing()*3);
    QPainter p;
    p.begin(formattedPix);
    p.setFont(fnt);
    p.fillRect(0, 0, formattedPix->width(), formattedPix->height(), Qt::white);
    p.drawPixmap(0, 0, *logoPix);
    p.setPen(Qt::black);
    QString destStr(i18n("(C)2001-2003 Daniel M. Duley, www.mosfet.org") +
        "\n" + i18n("Logo courtesy of THOS, www.thos.co.za"));
    p.drawText(0, startY, formattedPix->width(), formattedPix->height()-startY,
               Qt::AlignCenter, destStr);
    p.end();
    image = formattedPix->convertToImage();
    delete logoPix;
    delete formattedPix;
}

void KIFImagePreview::slotSetFile(const QString &file)
{
    qWarning("In KIFImagePreview::slotSetFile");
    scaleImage.reset();
    if(!loadImage(image, file)){
        fileStr = "";
    }
    else{
        //adjustAlpha(image);
        fileStr = file;
        pix.resize(0, 0);
        resizeWithAspect();
        QApplication::syncX();
        repaint();
    }
}
void KIFImagePreview::resizeWithAspect()
{
    if(image.isNull())
        return;
    if(pix.width() != width() || pix.height() != height()){
        //QRect deskRect = QApplication::desktop()->rect();
        QSize wSize = size();
        scaleImage = image;
        QSize r = QSize(scaleImage.width(), scaleImage.height());
        // may need to do this twice
        if(r.width() > wSize.width() || r.height() > wSize.height()){
            while(r.width() > wSize.width() || r.height() > wSize.height()){
                if(r.width() > wSize.width()){
                    float percent = ((float)wSize.width())/r.width();
                    r.setWidth((int)(r.width()*percent));
                    r.setHeight((int)(r.height()*percent));
                    qWarning("Scaling width");
                }
                if(r.height() > wSize.height()){
                    float percent = ((float)wSize.height())/r.height();
                    r.setWidth((int)(r.width()*percent));
                    r.setHeight((int)(r.height()*percent));
                    qWarning("Scaling height");
                }
            }
        }
        scaleImage = scaleImage.smoothScale(r.width(), r.height());
        pix.convertFromImage(scaleImage);
    }
}

void KIFImagePreview::resizeEvent(QResizeEvent* )
{
    resizeWithAspect();
}

void KIFImagePreview::paintEvent(QPaintEvent *ev)
{
    QPainter p;
    p.begin(this);
    if(pix.isNull() || pix.mask())
        p.fillRect(ev->rect(), Qt::white);
    if(pix.isNull()){
        return;
    }

    QRect r = ev->rect();
    p.drawPixmap(r.topLeft(), pix, r);
    QRect pixRect(0, 0, pix.width(), pix.height());
    pixRect = pixRect.intersect(r);
    if(pixRect.right() < r.right()){
        p.fillRect(pixRect.right()+1, r.y(), r.width()-pixRect.width(),
                   r.height(), Qt::white);
    }
    if(pixRect.bottom() < r.bottom()){
        p.fillRect(r.x(), pixRect.bottom()+1, r.width(),
                   r.height()-pixRect.height(), Qt::white);
    }
    p.end();
}

void KIFImagePreview::closeEvent(QCloseEvent *ev)
{
    clear();
    ev->accept();
}




