#ifndef __KIF_IMAGEPREVIEW_H
#define __KIF_IMAGEPREVIEW_H

#include "imagebuffer.h"
#include <qwidget.h>
#include <qpixmap.h>

class KIFImagePreview : public QWidget
{
    Q_OBJECT
public:
    KIFImagePreview(QWidget *parent=0, const char *name=0);
    QString filename(){return(fileStr);}
    QImage* currentImage(){return(&image);}
    void clear(){pix.resize(0, 0); image.reset(); scaleImage.reset(); fileStr="";}
    void resetFilename(){fileStr = QString::null;}
public slots:
    void slotSetFile(const QString &file);
protected:
    void resizeEvent(QResizeEvent *ev);
    void paintEvent(QPaintEvent *ev);
    void closeEvent(QCloseEvent *ev);
    void resizeWithAspect();

    QPixmap pix;
    QImage image, scaleImage;
    QString fileStr;
};

#endif

