#ifndef __KIF_IMAGEUTILS_H
#define __KIF_IMAGEUTILS_H

#include <qpixmap.h>
#include <qimage.h>
#include <qdatetime.h>

class PixieGlobal
{
public:
    PixieGlobal();
    ~PixieGlobal();
    bool isImageType(const QString &filename);
    bool isImageExtension(const char *ext);
protected:
    void insertExtension(const char *str);

    char *extensions[256][10];
};

bool loadImage(QImage &img, const QString &filename, const char *format=0,
               char *formatReturn=0);
bool saveImage(QImage &img, const QString &fileName, const char *format,
               int quality=-1, const QString &comment = QString::null);
void convertImageToPixmap(QImage &img, QPixmap &pix,
                          unsigned int bgColor=0xFFFFFFFF);
void convertImageToPixmapBlend(QImage &img, QImage &tile,
                               int start_x, int start_y, QPixmap &pix);
bool isImageType(const QString &filename);
bool isVideoType(const QString &filename);
void clearData();
const char* extension(const char *str);
const char* extensionForFormat(const char *format);
bool displayFormat(const char *format);
const char* formatForFilename(const QString &filename);
void outputFormats();

bool formatUsesComment(const char *format);
bool fileUsesComment(const QString &filename);
bool fileListUsesComment(const QStringList &fileList);

#if !(QT_VERSION & 0x00FF00)
unsigned int toTime_t(const QDateTime &t);
#endif

// Copies src to dest at point x,y without alpha channel
void copyQImage(QImage &src, QImage &dest, int x, int y);
// Copies src to dest, blending in the src alpha channel as needed
void copyQImageWithAlpha(QImage &src, QImage &dest, int x, int y);
// Tiles src to dest.
void tileQImage(QImage &src, QImage &dest);
// Tiles src to dest. It tiles the rectangle sx,sy,sw,sh to the rectangle
// dx,dy,dw,dh - so you can tile just parts of src
void tileQImage(QImage &dest, int dx, int dy, int dw, int dh, QImage &src,
                int sx, int sy, int sw, int sh);
// Tiles the alpha channel values only. Otherwise it's the same as above.
void copyQImageSecondaryAlpha(QImage &dest, int dx, int dy, int dw, int dh,
                              QImage &src, int sx, int sy, int sw, int sh);


#endif

