#ifndef __KIF_SCALEDTOPLEVEL_H
#define __KIF_SCALEDTOPLEVEL_H

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include "imagebuffer.h"
#include "ifapp.h"

class KWinModule;

class KIFScaledTopLevel : public QWidget
{
    Q_OBJECT
public:
    KIFScaledTopLevel(KIFImage *image, QWidget *parent=0,
                      const char *name=0);
    ~KIFScaledTopLevel();
    //KWinModule *winModule(){return(module);}
    QSize imageSize();
public slots:
    void slotUpdateFromImage();
    void slotInvalidFile();
signals:
    void prevList();
    void nextList();
    void nextImage();
    void prevImage();
    void finished();
protected slots:
    void slotHideAll();
    void slotShowAll();
protected:
    void resizeEvent(QResizeEvent *ev);
    void paintEvent(QPaintEvent *ev);
    void resizeWithAspect();
    void closeEvent(QCloseEvent *ev);
    void keyPressEvent(QKeyEvent *ev);

    QPixmap pix;
    QImage scaleImage;
    int frameW, frameH;
    KIFImage *imageBuffer;
    KWinModule *module;
    bool visible;
};

#endif

