#ifndef __KIF_SCREENGRAB_H
#define __KIF_SCREENGRAB_H

#include <qsemimodal.h>
#include <qimage.h>
#include <kpreviewwidgetbase.h>

class QCheckBox;
class KIntNumInput;
class KIFImageList;

class KIFScreenGrabPreview : public KPreviewWidgetBase
{
    Q_OBJECT
public:
    KIFScreenGrabPreview(const QImage *image, QWidget *parent=0,
                         const char *name=0);
    ~KIFScreenGrabPreview(){delete pix;}
    void paintEvent(QPaintEvent *ev);
    QSize sizeHint() const {return(QSize(200, 200));}
public slots:
    void showPreview(const KURL &url);
    void clearPreview();
protected:
    const QImage *img;
    QPixmap *pix;
};

class KIFScreenGrab : public QSemiModal
{
    Q_OBJECT
public:
    KIFScreenGrab(QWidget *parent=0, const char *name=0);
    ~KIFScreenGrab(){qWarning("Screen grab finished");}
public slots:
    void slotCheckIfDelay();
    void slotStartGrab();
    void slotCancel();
protected:
    void mousePressEvent(QMouseEvent *ev);
    bool inSelect, winSelected, inLoop;
    QCheckBox *desktopCB;
    QCheckBox *hideCB;
    KIntNumInput *delay;
};

#endif
