#Try to build a program from a file with a C compiler
#$1 is the source file
#$2 is the header file
#$3 is the objet file
#$4 are the options
#$5 is the code to execute if the build failed
#$6 is the code to execute if the build worked
AC_DEFUN([AC_TRY_BUILD_FILE], [
AC_REQUIRE([AC_PROG_CC])
COMPILE=0
$CC $4 $1 -o $3 2> /dev/null > /dev/null && COMPILE=1
if ! test -f $3 ; then
  rm $1 $2 2> /dev/null > /dev/null
  $5
else
  if [[[ $COMPILE == 0 ]]] ; then
    rm $1 $2 $3 2> /dev/null > /dev/null
    $5
  else
    rm $1 $2 $3 2> /dev/null > /dev/null
    $6
  fi
fi
])

#versions of programs

define(FLEXVERSION,2.5.31)
define(BISONVERSION,1.875d)

#check whether flex is able to build the lexical parser of PlanFacile

AC_DEFUN([AM_PROG_LEX_ABLE],[
AC_REQUIRE([AC_PROG_LEX])
AC_REQUIRE([AC_PARSER_STRICT_CHECK])
AC_MSG_CHECKING([whether $LEX is able to build lexical parser])
FLEXTESTFILEFLEX=flextestfile.lex
FLEXTESTFILEC=lex.yy.c
FLEXTESTFILE=flextest
cat > $FLEXTESTFILEFLEX << EOF
%{
#include <stdlib.h>
void test(void)
{
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(YY_CURRENT_BUFFER);
}
%}
%option nounput
%%
%%

int yywrap(void)
{
	return 1;
}

int main()
{
	yyin=stdin;
	yylex();
	yylex_destroy();
	return 0;
}
EOF
$LEX $FLEXTESTFILEFLEX 2> /dev/null
if ! test -f $FLEXTESTFILEC  ; then
  rm $FLEXTESTFILEFLEX 2> /dev/null > /dev/null
  AC_MSG_RESULT([no])
  if [[[ $PARSERSTRICTCHECK = 1 ]]] ; then
    AC_MSG_ERROR([You need to upgrade $LEX to version FLEXVERSION or later!])
  else
    AC_MSG_WARN([Compilation may fail if you change $LEX files !])
  fi
else
  rm $FLEXTESTFILEFLEX 2> /dev/null > /dev/null
  AC_TRY_BUILD_FILE($FLEXTESTFILEC , , $FLEXTESTFILE , -Wall , [
  AC_MSG_RESULT([no])
  if [[[ $PARSERSTRICTCHECK = 1 ]]] ; then
    AC_MSG_ERROR([You need to upgrade $LEX to version FLEXVERSION or later!])
  else
    AC_MSG_WARN([Compilation may fail if you change $LEX files !])
  fi
  ],[
  AC_MSG_RESULT([yes])
  ])
fi
])

#check whether bison is able to build the syntax parser of PlanFacile

AC_DEFUN([AC_PROG_YACC_ABLE],[
AC_REQUIRE([AC_PROG_YACC])
AC_REQUIRE([AC_PARSER_STRICT_CHECK])
AC_MSG_CHECKING([whether $YACC is able to build syntax parser])
BISONTESTFILEBISON=bisontestfile.y
BISONTESTFILEPREFIX=bisontestfile
BISONTESTFILEC=bisontestfile.tab.c
BISONTESTFILEH=bisontestfile.tab.h
BISONTESTFILE=bisontest
cat > $BISONTESTFILEBISON << EOF
%{
#include <stdlib.h>
#include "$BISONTESTFILEH"

void yyerror();
int yylex();

#define YYDEBUG	1
int yydebug=0;
int resultat;
%}
%union {
	int entier;
	char caractere;
}

%token NOMBRE

%type<entier> nombre

%start arf

%parse-param {char **chaine}

%%
EOF
echo -n 'arf: nombre { resultat=$'>> $BISONTESTFILEBISON
echo '1; };' >> $BISONTESTFILEBISON
echo 'nombre: NOMBRE { $$=0; };' >> $BISONTESTFILEBISON
cat >> $BISONTESTFILEBISON << EOF
%%
void yyerror()
{
	exit(1);
}

int yylex()
{
	return 0;
}

int main(void)
{
	char *chaine;
	yyparse(&chaine);
	return 0;
}
EOF
$YACC -d --file-prefix=$BISONTESTFILEPREFIX $BISONTESTFILEBISON 2> /dev/null
if ! test -f $BISONTESTFILEC ; then
  rm $BISONTESTFILEBISON 2> /dev/null > /dev/null
  AC_MSG_RESULT([no])
  if [[[ $PARSERSTRICTCHECK = 1 ]]] ; then
    AC_MSG_ERROR([You need to upgrade $YACC to version BISONVERSION or later !])
  else
    AC_MSG_WARN([Compilation may fail if you change $YACC files !])
  fi
else
  if ! test -f $BISONTESTFILEH ; then
    rm $BISONTESTFILEBISON 2> /dev/null > /dev/null
    AC_MSG_RESULT([no])
    if [[[ $PARSERSTRICTCHECK = 1 ]]] ; then
      AC_MSG_ERROR([You need to upgrade $YACC to version BISONVERSION or later !])
    else
      AC_MSG_WARN([Compilation may fail if you change $YACC files !])
    fi
  else
    rm $BISONTESTFILEBISON 2> /dev/null > /dev/null
    AC_TRY_BUILD_FILE($BISONTESTFILEC , $BISONTESTFILEH , $BISONTESTFILE , -Wall , [
    AC_MSG_RESULT([no])
    if [[[ $PARSERSTRICTCHECK = 1 ]]] ; then
      AC_MSG_ERROR([You need to upgrade $YACC to version BISONVERSION or later !])
    else
      AC_MSG_WARN([Compilation may fail if you change $YACC files !])
    fi
    ],[
    AC_MSG_RESULT([yes])
    ])
  fi
fi
])


#
#check if C compiler accepts these options
#$1 options to check
#
AC_DEFUN([AC_CFLAGS_GCC_OPTION],[
AC_REQUIRE([AC_PROG_CC])
AC_MSG_CHECKING([whether $CC accepts $1])
CTESTFILEC=testfilec.c
CTESTFILE=testfilec
cat > $CTESTFILEC << EOF
int main(int argc , char *argv[])
{
	return 0;
}
EOF
AC_TRY_BUILD_FILE($CTESTFILEC ,  , $CTESTFILE , $1 , [
AC_MSG_RESULT([no])
dnl AC_MSG_ERROR([Your compiler does not accept $1. You loose...])
],[
CFLAGS="$CFLAGS $1"
AC_SUBST(CFLAGS)
AC_MSG_RESULT([yes])
])
])

#
# Support of the parser build feature
#
AC_DEFUN([AC_PARSER_STRICT_CHECK],[
AC_MSG_CHECKING([if we want to be able to rebuild the parser])
AC_ARG_ENABLE(parser-build,
[  --disable-parser-build  disable strict check of parser tools],[
if eval "test x$enable_parser_build = xno" ; then
PARSERSTRICTCHECK=0
AC_MSG_RESULT([no])
else
PARSERSTRICTCHECK=1
AC_MSG_RESULT([yes])
fi
],[
PARSERSTRICTCHECK=1
AC_MSG_RESULT([yes])
])
])
