/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDELOCALISATION__
#define __COMMANDELOCALISATION__

#include <src/messages/messages/compilateur/global.h>

typedef struct localisationfichier LocalisationFichier;

typedef Entier PositionFichier;
//Position dans un fichier.

struct localisationfichier
{
	NomFichier nom;
	//Nom du fichier dans lequel la localisation est donne.
	NomFichier nomabsolu;
	//Nom du fichier dans lequel la localisation est donne.
	//Ce nom est absolu. Ce paramtre peut tre gal  NULL.
	DescripteurFichier descripteur;
	//Descripteur de fichier, utilis par l'analyseur lexical.
	PositionFichier position;
	//Position dans le fichier de la localisation.
	LocalisationFichier *inclusion;
	//Si inclusion vaut NULL, c'est que le fichier n'a pas t inclu.
	//Sinon, inclusion pointe sur une structure de localisation correspondant
	// la localisation depuis laquelle le fichier courant a t inclus.
};
/* Localisation dans un fichier. Cette localisation sert au compilateur pour dterminer
 *  quel endroit dans le source une erreur s'est produite, mme longtemps aprs la
 * fin de la phase d'analyse.
 */

Resultat localisationfichier_initialisation(LocalisationFichier **localisationfichier);
/* Cre une localisation de fichier vide.
 */

Resultat localisationfichier_ajout(LocalisationFichier **localisationfichier , NomFichier nom , NomFichier nomabsolu , DescripteurFichier descripteur , PositionFichier position);
/* Ajoute une localisation de fichier. La position est celle dans le fichier inclus.
 * Utilis lors de l'inclusion d'un fichier.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si l'allocation choue.
 */

Resultat localisationfichier_modification(LocalisationFichier *localisationfichier , PositionFichier position);
/* Modifie la position dans le fichier courant.
 */

Resultat localisationfichier_retrait(LocalisationFichier **localisationfichier);
/* Retire une localisation de fichier.
 * Ne referme pas le fichier dsign par le descripteur.
 * Utilis lors d'un retour de fichier inclus.
 */

Resultat localisationfichier_lecture_nom(LocalisationFichier *localisationfichier , NomFichier *nom);
/* Lit le nom du fichier.
 * Renvoie RESULTAT_ERREUR si localisationfichier est NULL.
 */

Resultat localisationfichier_lecture_nomabsolu(LocalisationFichier *localisationfichier , NomFichier *nomabsolu);
/* Lit le nom absolu du fichier.
 * Renvoie RESULTAT_ERREUR si localisationfichier est NULL.
 */

Resultat localisationfichier_lecture_descripteur(LocalisationFichier *localisationfichier , DescripteurFichier *descripteur);
/* Lit le descripteur du dernier fichier inclus.
 * Renvoie RESULTAT_ERREUR si localisationfichier est NULL.
 */

Resultat localisationfichier_lecture_position(LocalisationFichier *localisationfichier , PositionFichier *position);
/* Lit la position dans le dernier fichier inclus.
 * Renvoie RESULTAT_ERREUR si localisationfichier est NULL.
 */

Resultat localisationfichier_lecture_inclusion(LocalisationFichier *localisationfichier , LocalisationFichier **inclusion);
/* Renvoie la position du fichier parent dans l'ordre d'inclusion.
 * Renvoie RESULTAT_ERREUR si localisationfichier est NULL.
 */

Resultat localisationfichier_vide(LocalisationFichier *localisationfichier , Booleen *vide);
/* Indique si la localisationfichier est vide ou non.
 */

Resultat localisationfichier_test_fichier(LocalisationFichier *localisationfichier , NomFichier nomabsolu , Booleen *present);
/* Indique si un nom de fichier est prsent dans la localisation
 * de fichier, afin de savoir si on ne ralise pas une inclusion
 * rcursive. Le rsultat est renvoy dans le boolen pass en
 * paramtre.
 */

Resultat localisationfichier_copie(LocalisationFichier *localisationfichier , LocalisationFichier **copie);
/* Effectue une copie d'une localisation de fichier.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat localisationfichier_copie_commande(LocalisationFichier *localisationfichier , LocalisationFichier **copie);
/* Effectue une copie d'une localisation de fichier,
 * en ne recopiant ni le descripteur de fichier, ni le nom
 * absolu ventuel.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat localisationfichier_destruction(LocalisationFichier **localisationfichier);
/* Dtruit une localisation de fichier.
 */

#endif
