/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2017, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * This file is part of PlantUML.
 *
 * Licensed under The MIT License (Massachusetts Institute of Technology License)
 * 
 * See http://opensource.org/licenses/MIT
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.graphic.FontConfiguration;

public class StripeStyle {

	private final StripeStyleType type;
	private final int order;
	private final char style;

	public StripeStyle(StripeStyleType type, int order, char style) {
		this.type = type;
		this.order = order;
		this.style = style;
	}

	public final StripeStyleType getType() {
		return type;
	}

	public Atom getHeader(FontConfiguration fontConfiguration, CreoleContext context) {
		if (type == StripeStyleType.LIST_WITHOUT_NUMBER) {
			return new Bullet(fontConfiguration, order);
		}
		if (type == StripeStyleType.LIST_WITH_NUMBER) {
			final int localNumber = context.getLocalNumber(order);
			return AtomText.createListNumber(fontConfiguration, order, localNumber);
		}
		return null;
	}

	public final int getOrder() {
		return order;
	}

	public char getStyle() {
		return style;
	}
}
