/*
 *   Copyright (C) 2007 Matt Broadstone <mbroadst@kde.org>
 *   Copyright (C) 2007 Matias Costa <m.costacano@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QGraphicsItem>
#include <QGraphicsScene>
#include <QListIterator>

#include "launcher.h"
#include "desktop.h"
#include "desktoporganizer.h"

DesktopOrganizer::DesktopOrganizer(StandardDesktop *parent, Organizer type)
    : m_desktop(parent),m_type(type),m_bSortDirectoriesFirst(true)
{
}

DesktopOrganizer::~DesktopOrganizer()
{
}

bool DesktopOrganizer::sortDirectoriesFirst() const
{
   return m_bSortDirectoriesFirst;
}

void DesktopOrganizer::setSortDirectoriesFirst(bool b)
{
   m_bSortDirectoriesFirst = b;
}

void DesktopOrganizer::changeAlignment( Organizer type)
{
    m_type = type;
}

void DesktopOrganizer::organize(const QList<Launcher*> &items)
{
    if (items.isEmpty())
    {
        kDebug() << "Warning: DesktopOrganizer::organize call with empty list"<<endl;
        return;
    }

    switch(m_type) {
        case Vertical:
        {
             alignVertical(items);
             break;
        }           
        case Horizontal:
        { 
            alignHorizontal(items);
            break;
        }
    }
}

void DesktopOrganizer::alignHorizontal(const QList<Launcher*> &items)
{
    Launcher *icon;
    QListIterator<Launcher*> it(items);
    icon = it.next();

    QSize gridDim = m_desktop->gridDimensions();

    for(int y=0; y < gridDim.height(); ++y)
    {
        for(int x=0; x < gridDim.width(); ++x)
        {
            QPointF newGridPos = m_desktop->mapFromGrid(QPoint(x,y));
            QGraphicsItem *existing = m_desktop->scene()->itemAt(newGridPos);
            if (!existing || existing == m_desktop)
            {
                m_desktop->alignToGrid(icon, QPointF(x, y));
                if (it.hasNext()) {
                    icon = it.next();
                } else {
                    /* all items located */
                    return;
                }
            }
        }
    }

}

void DesktopOrganizer::alignVertical(const QList<Launcher*> &items)
{
    Launcher *icon;
    QListIterator<Launcher*> it(items);
    icon = it.next();

    QSize gridDim = m_desktop->gridDimensions();

    for(int x=0; x < gridDim.width(); ++x)
    {
        for(int y=0; y < gridDim.height(); ++y)
        {
            QPointF newGridPos = m_desktop->mapFromGrid(QPoint(x,y));
            QGraphicsItem *existing = m_desktop->scene()->itemAt(newGridPos);
            if (!existing || existing == m_desktop)
            {
                m_desktop->alignToGrid(icon, QPointF(x, y));
                if (it.hasNext()) {
                    icon = it.next();
                } else {
                    /* all items located */
                    return;
                }
            }
        }
    }
}



