/*
 *   Copyright (C) 2007 Matt Broadstone <mbroadst@kde.org>
 *   Copyright (C) 2007 Matias Costa <m.costacano@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef LAUNCHERBUTTON_H
#define LAUNCHERBUTTON_H

#include <KFileItem>

#include <plasma/widgets/icon.h>
#include <solid/device.h>

class Launcher : public Plasma::Icon
{
    Q_OBJECT
public:
    Launcher(QGraphicsItem * parent = 0);
    virtual ~Launcher();

    void lockIcon(bool lock);
// protected:
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

    virtual void launch() = 0;
private:
    bool m_iconMoved:1;
};



// Launchers
class FileLauncher : public Launcher
{
public:
    FileLauncher(KFileItem *file, QGraphicsItem * parent = 0);
    ~FileLauncher();

    KFileItem *fileItem() const { return m_fileItem; }
protected:
    void launch();

private:
    KFileItem *m_fileItem;

};

namespace Solid
{
    class Device;
}
class DeviceLauncher : public Launcher
{
public:
    DeviceLauncher(const QString &udi, QGraphicsItem * parent = 0);
    ~DeviceLauncher();

protected:
    void launch();

private:
    Solid::Device m_device;

};


#endif

