/*
 *   Copyright (C) 2007 Percy Leonhardt <percy@eris23.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef NETWORK_H
#define NETWORK_H

#include <plasma/applet.h>
#include <plasma/dataengine.h>

#include "ui_config.h"

class KDialog;

namespace Plasma
{
    class Svg;
}

class Network : public Plasma::Applet
{
    Q_OBJECT
public:
    Network(QObject *parent, const QVariantList &args);
    ~Network();

    QSizeF contentSizeHint() const;
    void constraintsUpdated();
    void paintInterface( QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &rect);

public slots:
    void updated(const QString &name, const Plasma::DataEngine::Data &data);
    void showConfigurationInterface();

protected slots:
    void configAccepted();

private:
    int m_rxPackets;
    int m_txPackets;
    int m_pixelSize;
    bool m_isWireless;
    QSizeF m_size;
    QString m_rxState;
    QString m_txState;
    QString m_quality;
    QString m_interface;
    KDialog *m_dialog;
    Ui::config ui;
    Plasma::Svg *m_traffic;
//    Plasma::Svg *m_plotter;
};

K_EXPORT_PLASMA_APPLET(network, Network)

#endif
