/*
 *   Copyright (C) 2007 Zack Rusin <zack@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SAMPLEITEM_H
#define SAMPLEITEM_H

#include <plasma/glapplet.h>
#include <plasma/dataengine.h>

#include <QtGui/QWidget>
#include <QtCore/QObject>

class QHttp;

class SampleItem : public Plasma::GLApplet
{
    Q_OBJECT
public:
    SampleItem(QObject *parent, const QVariantList &args);
    ~SampleItem();

    virtual QRectF boundingRect() const;
    qreal width() const {
        return boundingRect().width();
    }
    qreal height() const {
        return boundingRect().height();
    }
    virtual void paintGLInterface(QPainter *painter,
                                  const QStyleOptionGraphicsItem *option);
public slots:
    void prepareTextures(const QString &);

signals:
    void statusChanged(const QString &status);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *);
    void wheelEvent(QGraphicsSceneWheelEvent *);
    void hoverMoveEvent(QGraphicsSceneHoverEvent *e);

protected:
    void drawBlades(bool select_mode = false);
    int bladeAtPos(const QPoint &);
    void timerEvent(QTimerEvent *);

private slots:
    void processResults(int id, bool error);

private:
    GLfloat carousel_rot;
    GLfloat y_rot;
    GLfloat scale;

    GLuint qt_logo;
    QList<GLuint> textures;

    QPoint anchor;
    QHttp *http;

    int search_id;
    int image_id;
    int current_blade;
    int current_image;
    int current_at_press;
    QStringList images;

    bool select_anim;
    GLfloat anim_scale;
    GLfloat anim_alpha;

    bool mouse_down;

    bool zoom_out;
    bool zoom_in;
    bool zoomed_in;

};

K_EXPORT_PLASMA_APPLET(samplegl, SampleItem)

#endif
