
print('Script.js: Launched');

function dump(obj)
{
  print( 'Dumping ' + obj );
  for( i in obj ) {
       print(i);
  }
}

dump( this );
dump( applet );

applet.debug('Script debug test\n');

// We have a configuration interface
applet.hasConfigurationInterface = true;
applet.drawStandardBackground = true;

applet.debug('Script creating svg\n');

//applet.svg = new PlasmaSvg( 'widgets/tiger', applet );
applet.svg = new PlasmaSvg( 'widgets/clock', applet );
//applet.svg.contentType = applet.svg.SingleImage;
applet.svg.contentType = applet.svg.ImageSet;
applet.svg.resize( 200, 200 );

applet.debug('Script data engine\n');
time = applet.getDataEngine('time');
applet.debug('query engine\n');
applet.debug( time.query('Local') );
applet.debug( time.sources() );

applet.debug( 'Doing query' );
data = time.query('Local')
dump(data);
applet.debug( data.Date );

applet.debug('Script data engine done\n');


applet.paintInterface = function(painter)
{
  applet.svg.paint( painter, applet.svg.elementRect('ClockFace'), 'ClockFace' );

  var now = new Date();
  var seconds = 6.0 * now.getSeconds() - 180;
  var minutes = 6.0 * now.getMinutes() - 180;
  var hours = 30.0 * now.getHours() - 180 + ((now.getMinutes() / 59.0) * 30.0);

  // Second hand
  painter.save();
  painter.translate(100,100);
  painter.rotate(seconds);
  applet.svg.paint( painter, 0, 0, 'SecondHand' );
  painter.restore();

  // Minute hand
  painter.save();
  painter.translate(100,100);
  painter.rotate(minutes);
  applet.svg.paint( painter, 0, 0, 'MinuteHand' );
  painter.restore();

  // Hour hand
  painter.save();
  painter.translate(100,100);
  painter.rotate(hours);
  applet.svg.paint( painter, 0, 0, 'HourHand' );
  painter.restore();

  // Digital
  painter.drawText( 100, 100, now.getHours() + ':' + now.getMinutes() );

  // Glass
  applet.svg.paint( painter, applet.svg.elementRect('HandCenterScrew'), 'HandCenterScrew' );
  applet.svg.paint( painter, applet.svg.elementRect('Glass'), 'Glass' );
}

applet.showConfigurationInterface = function()
{
   print('applettest.js: Show configuration interface');

   ui = loadui( applet.findDataResource('script_config.ui') );
   ui.show();
}

applet.updated = function( name, data )
{
    print( 'Updated: ' + name + ' Data=' + data );
}

applet.onTimer = function()
{
   applet.update();
}

print( 'Setting up timer' );
try {
  applet.timer = new QTimer();
  applet.timer.start(500);
  applet.timer.timeout.connect( applet.onTimer );
  print( 'Timer ok' );
}
catch(err) {
 print('Broken: ' + err );
}
