/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   Copyright (C) 2007 by Javier Goday <jgoday@gmail.com>
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KGETENGINE_H
#define KGETENGINE_H

#include <plasma/dataengine.h>

#include <QtDBus/QDBusConnectionInterface>
#include <QMap>
#include <QStringList>

class QTimer;

static const QString DEFAULT_SERVICE = "org.kde.kget";
static const QString DEFAULT_PATH = "/KGet";
static const QString DEFAULT_INTERFACE = "org.kde.kget";

class KGetEngine : public Plasma::DataEngine
{
    Q_OBJECT
    Q_PROPERTY(uint refreshTime READ refreshTime WRITE setRefreshTime)

public:
    KGetEngine(QObject* parent, const QVariantList& args);
    ~KGetEngine();

    void setRefreshTime(const uint refreshTime);
    uint refreshTime();

protected:
    void init();
    bool sourceRequested(const QString &name);

private slots:
    void setKGetSourceData(const QString &name);
    void serviceRegistered(const QString &name, const QString &old_owner, const QString &new_owner);
    void slotTransfersChanged(const QVariantMap &transfers);
    void updatePercents();

private:
    bool isDBusServiceRegistered();
	
    QDBusConnectionInterface *interface;
    QTimer *m_timer;

    uint m_refreshTime;
};

K_EXPORT_PLASMA_DATAENGINE(kget, KGetEngine)

#endif
