/*
 *   Copyright (C) 2007 Michael Olbrich <michael-olbrich@web.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SENSORSENGINE_H
#define SENSORSENGINE_H

#include <plasma/dataengine.h>
#include <QtCore/QMap>

class Plasma::DataContainer;
class QTimer;

class SensorsEngine : public Plasma::DataEngine
{
    Q_OBJECT

public:
    SensorsEngine(QObject* parent, const QVariantList& args);
    ~SensorsEngine();

    virtual QStringList sources() const;
protected:
    bool sourceRequested(const QString &name);

protected Q_SLOTS:
    void update(Plasma::DataContainer* source);
    void timeout();

private:
    struct SensorData
    {
        SensorData() {}
        SensorData(const QString &p, const QString &n)
            : path(p), name(n) {}
        QString path;
        QString name;
    };
    typedef QMap<QString, SensorData> SensorMap;

    bool m_state;
    SensorMap m_sensors;
    QTimer *m_timer;
};

K_EXPORT_PLASMA_DATAENGINE(sensors, SensorsEngine)

#endif
