/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <effect.h>
#include <qwidget.h>
#include <q3canvas.h>
#include <qapplication.h>
#include <qcolor.h>
#include <math.h>
#include <qimage.h>
//#include "kbfxwatersprite.h"
#include <kimageeffect.h>
#include <kbfxconfig.h>




QColor getPixelColor ( uchar * src )
{
	QImage tmp ( src,1,1,32,0,65535,QImage::IgnoreEndian );
	return QColor ( tmp.color ( 0 ) );
}

QImage blur ( QImage src )
{




	int height = src.height();
	int width = src.width();

	static QImage out = QImage (ConfigInit().m_SpinxThemeBasePath + ConfigInit().m_SpinxThemeName + "/glass.png");
	out = out.convertDepth ( 32 );
	out.setAlphaBuffer ( true );

	for ( int i = 1; i < width-1 ; i++ )
	{

		//uint *riga=(uint *)src.scanLine(x);
		for ( int j= 1;j< height-1; j++ )
		{

			QColor color =  out.pixel ( i+1,j );
			QColor color2 = out.pixel ( i-1,j );
			QColor color3 = out.pixel ( i,j+1 );
			QColor color4 = out.pixel ( i,j-1 );
			QColor color5 = src.pixel ( i,j );


			int R = ( ( ( color.red() +color2.red() +color3.red() +color4.red() ) /2 ) - color5.red() );
			int G = ( ( ( color.green() +color2.green() +color3.green() +color4.green() ) /2 )-color5.green() );
			int B = ( ( ( color.blue() +color2.blue() +color3.blue() +color4.blue() ) /2 )-color5.blue() );
			//int A = color.alpha();
			R = ( R < 0 ) ? 0: ( R > 255 ) ? 255: R;
			G = ( G < 0 ) ? 128 : ( G > 255 ) ? 255 : G;
			B = ( B < 0 ) ? 128: ( B > 255 ) ? 128: B;

			QColor nc ( R,G,B );

			out.setPixel ( i,j,nc.rgb() );

		}
	}

	return  KImageEffect::blend ( out,src,1.0 );

}

