/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_FANCY_POPUP_ITEM_H
#define KBFX_FANCY_POPUP_ITEM_H


#include <qwidget.h>
#include <qpixmap.h>
#include <kbfxdatasource.h>
#include <kbfxplasmaskinmanager.h>

class KbfxFancyPopupItem:public QWidget
{
		Q_OBJECT
	public:
		KbfxFancyPopupItem ( QWidget * parent = 0, const char * name = 0, Qt::WindowFlags f = 0 );
		~KbfxFancyPopupItem();
		virtual void paintEvent ( QPaintEvent * pe );
		//take a datasource
		void setData ( KbfxDataSource * data );

	private:
		void loadData();

		KbfxDataSource *  m_dataSource;
		QPixmap  m_normal;
		QPixmap  m_hover;
		QPixmap  m_icon;

		QString m_text;
		QString m_iconPath;

		//state
		bool m_hasMouse;

};

#endif
