/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_INDEX_VIEW_H
#define KBFX_PLASMA_INDEX_VIEW_H

#include <kdebug.h>
#include <q3canvas.h>
#include "kbfxdatastack.h"
#include "kbfxplasmacanvasstack.h"
#include "kbfxplasmaindexitem.h"
#include "kbfxsignal.h"
#include "kbfxplasmapluginloader.h"
#include "kbfxplasmacanvasview.h"
#include "kbfxplasmapixmapprovider.h"

class QMenu;

class KbfxPlasmaIndexView : public Q3CanvasView
{

		Q_OBJECT

	public:

		KbfxPlasmaIndexView ( QWidget * parent = 0, const char * name = 0, Qt::WindowFlags l = 0 );
		virtual ~KbfxPlasmaIndexView();
		void loadList ( KbfxDataStack * stkPtr );
		int count() { return m_itemGroup->count() ; }
		void clearAll();
		void setView ( KbfxPlasmaCanvasView * view );
		virtual void contentsMouseMoveEvent ( QMouseEvent * e );
		virtual void contentsMousePressEvent ( QMouseEvent * me );
		virtual void contentsContextMenuEvent ( QContextMenuEvent * e ) ;
		virtual void mouseMoveEvent ( QMouseEvent * e );
		virtual void leaveEvent ( QEvent * e );
		void setKbfxCanvas ( Q3Canvas * cnv );

	public slots:
		void slotClicked ( KbfxPlasmaIndexItem * );
		void contextMenuSlot ( int id );
		void loadPlugin ( QString name,KbfxPlasmaCanvasView * );
		void checkMousePos();


	signals:
		void loadRequest ( KbfxSignal signal );
		void pluginRequest ( QString pluginName,KbfxPlasmaCanvasView * );
		void clicked ( KbfxPlasmaIndexItem * item );
		void expand();

	protected:
		void clearAllButOne ( KbfxPlasmaIndexItem * i );

	private:

		KbfxPlasmaCanvasGroup * m_itemGroup;
		KbfxPlasmaCanvasGroupView * m_itemGroupList;
		KbfxPlasmaCanvasStack * m_itemStack;
		KbfxPlasmaIndexItem * m_currentItem;
		KbfxPlasmaIndexItem * m_selectedItem;
		QStringList m_pluginList;
		QStringList m_pluginLoaded;
		QMenu * m_pluginMenu;
		KbfxPlasmaCanvasView * m_currentView;
		QPoint m_currentPos;
		QTimer  * m_mousePollTimer;
};

#endif
