/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_SKIN_MANAGER_H
#define KBFX_PLASMA_SKIN_MANAGER_H

#include <kbfxconfig.h>

class KbfxPlasmaSkinManager: public QObject
{

		Q_OBJECT

	public:
		typedef enum { APPFIND = 0,
		               BG, BOTBG,
		               FIND,
		               LISTBOXBG,
		               LOCK,
		               LOCKHOVER,
		               LOGOUT,
		               LOGOUTHOVER,
		               MASK,
		               MENU_MAIN_WHITE_BG,
		               MENU_TOP,
		               MENU_TOP_IMAGE_PERSON,
		               RHSHOVERTILE,
		               RHSTILE,
		               SEPARATOR,
		               INDEXSEPARATOR,
		               TABBG,
		               TILEHOVER,
		               TILENORMAL,
		               TOPBG,
		               TOPBG2,
		               SCROLLBAR_NORMAL,
		               DUDEBOX,
		               MENUITEM_NORMAL,
		               SIDEBAR_TOP,
		               SIDEBAR_BG
	             } _themePixmaps;


		KbfxPlasmaSkinManager();
		~KbfxPlasmaSkinManager();

		void readConfig();

		static QString getThemePixmapPath ( _themePixmaps _names );

		struct _themePixmapsNamesStruct { QString name; QString extension; };

	private:


};

#endif
