/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxwatersprite.h"
#include <qpixmap.h>
#include "effect.h"

KbfxPlasmaWaterBack::KbfxPlasmaWaterBack ( QCanvasPixmapArray * a , QCanvas * canvas ) :
		QCanvasSprite ( a, canvas )
{
	setAnimated ( true );
	QPixmap *  _img = this->image ( 0 );
	m_bg = _img->convertToImage();
	m_timer = new QTimer ( this );
	connect ( m_timer,SIGNAL ( timeout() ),this,SLOT ( update() ) );
	m_timer->start ( 120,false );
}



KbfxPlasmaWaterBack::~KbfxPlasmaWaterBack()
{}


void
KbfxPlasmaWaterBack::draw ( QPainter & pe )
{
	pe.drawImage ( QRect ( 0,0,m_bg.width(),m_bg.height() ),blur ( m_bg ) );
}

void
KbfxPlasmaWaterBack::update()
{
	advance ( 0 );
	setFrame ( 0 );
	move ( 0,0 );
	canvas()->update();
}

#include "kbfxwatersprite.moc"
