/******************************************************************************
*   Copyright (C) 2006-2007 by Riccardo Iaconelli  <ruphy@fsfe.org>           *
*                                                                             *
*   This library is free software; you can redistribute it and/or             *
*   modify it under the terms of the GNU Library General Public               *
*   License as published by the Free Software Foundation; either              *
*   version 2 of the License, or (at your option) any later version.          *
*                                                                             *
*   This library is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU          *
*   Library General Public License for more details.                          *
*                                                                             *
*   You should have received a copy of the GNU Library General Public License *
*   along with this library; see the file COPYING.LIB.  If not, write to      *
*   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
*   Boston, MA 02110-1301, USA.                                               *
*******************************************************************************/


#ifndef PLASMAGIK_H
#define PLASMAGIK_H

#include <qdialog.h>

#include <kdemacros.h>
#include <KAssistantDialog>

class UploaderPrivate;

// class QIcon;
// class QLabel;
// class QGridLayout;
// class KLineEdit;
// class KTextEdit;
// class KUrlRequester;
// class QComboBox;
// class QGroupBox;
// class KUser;
// class QStringList;
// class QStackedLayout;
// class QHBoxLayout;
// class QPushButton;
// class QVBoxLayout;
// class KSeparator;
// class KIcon;
// class QLayoutItem;
// class QStringListModel;
// class KMessageBoxMessageHandler;
// class KTemporaryFile;

class Packager;

// TODO: Document the class
namespace KNS
{

class KDE_EXPORT Uploader : public KAssistantDialog
{
    Q_OBJECT
public:
    Uploader(const QString &appName, QWidget *parent = 0);
    ~Uploader();
    void fillFields();
    
    enum LabelFlag {
        WelcomeText     = 0x00000001,
        ReleaseNotes    = 0x00000002
        //TODO: add text of other strings and popups here
    };
    Q_DECLARE_FLAGS(Label, LabelFlag)

    enum ClearFlag {
        ClearFirst      = 0x00000001,
        DoNotClearFirst = 0x00000002
    };
    Q_DECLARE_FLAGS(Clear, ClearFlag)

    /**
        Set the text of the string "string" to the text "text" 
    */
    void setText(Uploader::Label label, const QString &text);

    /**
        Set the extension for the generated package.
        @note the extension won't be checked.
    */
    void setExtension(const QString &extension);

    /**
        Sets the mimetype of the generated package.
        It will be used in the filedialog.
        Default is application/x-kns
    */

    void setMimeType(const QString &mimeType);

    /**
        Sets the program icon.
    */
    void setIcon(const QIcon &icon);

    /**
        The type of package we will be creating. This is stored in the metadata and is
        internal to the application. For example, the the type might be "Theme" or
        "Script" or some other application specific package type.

        @arg type the type of package
    */
    void setPackageType(const QString& type);

    /**
        Sets supported contents.
        @note this function will automatically clear any type previously set.
        @note the correct types relative specific packages types are automatically
              set by setPackageType(), and you don't need to do that again.
        @arg items types must be separated by '|'.
        @example setContentTypes("C++|Javascript|Python");
    */
    void setContentTypes(const QString &items);
    /**
        Provided for convenience.
        @see setContentTypes(const QString)
    */
    void setContentTypes(const QStringList &items);

    /**
        Add supported contents at the end of the combobox.
        @arg items types must be separated by '|'.
        @example setContentTypes("C++|Javascript|Python");
        @see clearContentTypes();
    */
    void addContentTypes(const QString &items);
    /**
        Provided for convenience.
        @see addContentTypes(const QString)
    */
    void addContentTypes(const QStringList &items);

    /**
        It deletes all the previously set language
    */
    void clearContentTypes();

    /**
        Whether to ask or not the user to mark a file as "main".
        @arg visible if true, ask the user
    */
    void setAskForMainFile(bool visible);
    bool askForMainFile();

    /**
        Sets the url of the KNewStuff2 configuration file.
        @arg file url to the file
    */
    void setRcFile(const QString &file);
    QString rcFile();

public slots:
    void next();

private:
    class Private;
    Private * const d;

    void initializeSpecialWidgets();
    void connectSignalsAndSlots();
    void switchPage();

    bool isOkToOverwrite();
    void warningOverwrite(const QString &url);

    bool licenseIsAcceptable();
    bool fieldsNotEmpty();
    bool fileToLoadExists();
    bool creationExists();
    bool packagingHomeDir();

    bool createPackage();

    void uploadPackage();

private Q_SLOTS:
    void checkNotToBeOverwriting(const KUrl & url);
    void checkInformation();
    void doUpload();
    void creationNameChanged(const QString &newtext);
    void creationVersionChanged(const QString &newtext);
};

} // Namespace
#endif
