/***************************************************************************
*   Copyright (C) 2009 by Georg Hennig <georg.hennig@web.de>              *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 3 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
***************************************************************************/

#ifndef Plasma_CWP_Update_Thread_HEADER
#define Plasma_CWP_Update_Thread_HEADER

#include <QThread>
#include <QMutex>

#include <KIO/Job>

#include "config.h"

class Update_Thread : public QThread
{
	Q_OBJECT

	public:
		Update_Thread( QObject *parent, const QString &path, const uint identifier );
		virtual ~Update_Thread();
		virtual void run();
		void stop();

		void get_weather_values( QString &data_location_location_tmp, QString &data_location_country_tmp, QString &data_sun_sunrise_tmp, 
			QString &data_sun_sunset_tmp, QString &data_current_temperature_tmp, QString &data_current_temperature_felt_tmp,
			QString &data_current_wind_code_tmp, QString &data_current_wind_speed_tmp, QString &data_current_wind_tmp,
			QString &data_current_humidity_tmp, QString &data_current_dew_point_tmp,
			QString &data_current_visibility_tmp, QString &data_current_pressure_tmp, QString &data_current_uv_index_tmp,
			int &data_current_icon_code_tmp, QImage &data_current_icon_tmp,
			QString &data_current_icon_text_tmp, QString &data_current_rain_tmp, QString *data_day_name_tmp,
			QString *data_day_temperature_high_tmp, QString *data_day_temperature_low_tmp,
			int *data_day_icon_code_tmp, QImage *data_day_icon_tmp, QString *data_day_icon_text_tmp, QString &data_update_time_tmp,
			QString &data_provider_update_time_tmp, QString &tempType_tmp, QList<QByteArray> &data_custom_image_list_tmp );

		void set_config_values( const QString &updateFrequency_tmp, const QString &xmlFile_tmp, const QString &zip_tmp, const QString &feelsLike_tmp,
			const QString &humidity_tmp, const QString &wind_tmp, const QString &tempType_tmp, const QList<KUrl> &customImageList_tmp );

		bool isCollectingDataHanging();

	signals:
		void data_fetched();

	public slots:
		void force_update();

	private:
		QTime collecting_data_start_time;
		bool collecting_data;
		QString local_data_path;
		uint local_data_identifier;
		void loadLocalData();
		void saveLocalData();

		void collectAndParseData();
		bool downloadFile( const QString url, QByteArray *data );
		QString runCommand( const QString command, const QByteArray *data );

		QByteArray *rawDataFromUrl( const QString &url );
		bool successFromUrl( const QString &url, const bool *url_success );

		QMutex mutex;
		bool stop_thread;
		bool force_update_triggered;

		QString updateFrequency;
		QString xmlFile;
		QString zip;
		QString feelsLike;
		QString humidity;
		QString wind;
		QString tempType;

		QList<KUrl> customImageList;

		QString locale;
		QString encoding;

		QString data_update_time;

		QByteArray *raw_data_urlc;
		QByteArray *raw_data_url1;
		QByteArray *raw_data_url2;
		QByteArray *raw_data_url3;
		QByteArray *raw_data_url4;
		QByteArray *raw_data_url5;
		QByteArray *raw_data_url6;
		QByteArray *raw_data_url7;

		QString data_provider_update_time;

		QList<QByteArray> data_custom_image_list;

		QString data_location_location;
		QString data_location_country;

		QString data_sun_sunrise;
		QString data_sun_sunset;

		QString data_current_temperature;
		QString data_current_temperature_felt;
		QString data_current_wind_code;
		QString data_current_wind_speed;
		QString data_current_wind;
		QString data_current_humidity;
		int data_current_icon_code;
		QImage data_current_icon;
		QString data_current_icon_text;

		QString data_current_rain;
		QString data_current_dew_point;
		QString data_current_visibility;
		QString data_current_pressure;
		QString data_current_uv_index;

		QString data_day_name[7];
		QString data_day_temperature_high[7];
		QString data_day_temperature_low[7];
		int data_day_icon_code[7];
		QImage data_day_icon[7];
		QString data_day_icon_text[7];
};

#endif 
