/*
 *      plasmoid.cpp
 *
 *      Copyright 2009 Sebastian Wankerl <far_away@online.de>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */


#include "plasmoid.hpp"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>

#include <KConfigDialog>
#include <plasma/svg.h>
#include <plasma/theme.h>
#include "thread.hpp"

MailWidget1::MailWidget1(QObject *parent, const QVariantList &args):    Plasma::Applet(parent, args),
																		general_group(&conf, "general"),
                                                                        m_svg(this),
                                                                        icon("mail0"),
																		icon_new("mail1"),
																		error_icon("mail_error"),
                                                                        mails(0)
{
	m_svg.setImagePath("widgets/background");
    setBackgroundHints(DefaultBackground);
	resize(150, 150);
    setHasConfigurationInterface(true);
}


MailWidget1::~MailWidget1() {
    if (hasFailedToLaunch()) {
        // Do some cleanup here
    } else {
        // Save settings
    }
}

void MailWidget1::init() {
    thrd = new threadu (&conf);
    thrd->start();
    QObject::connect(thrd, SIGNAL( signal_mails(int) ), this, SLOT( update_plasmoid(int) ) );

    if (icon.isNull()) {
        setFailedToLaunch(true, "No world to say hello");
    }
}

void MailWidget1::createConfigurationInterface(KConfigDialog *parent) {
    QWidget *conf_widget = new QWidget;
    my_ui.setupUi(conf_widget);

    my_ui.lineEdit->insert(general_group.readEntry("user", QString()));
    my_ui.lineEdit_2->insert(general_group.readEntry("pw", QString()));
    my_ui.lineEdit_3->insert(general_group.readEntry("server", QString()));
    QString temp = general_group.readEntry("type", QString());
    my_ui.comboBox->setCurrentIndex(temp == "IMAP" ? 0 : 1);
    temp = general_group.readEntry("time", QString());
    my_ui.spinBox->setValue(temp.toInt());
    my_ui.checkBox->setChecked(QVariant(general_group.readEntry("play_sound")).toBool());

    connect(parent, SIGNAL(okClicked()), this, SLOT(changeConfig()));
    parent->addPage(conf_widget, i18n("Settings"), "example");
}

void MailWidget1::paintInterface (QPainter *p, const QStyleOptionGraphicsItem *option, const QRect &contentsRect) {
    KIcon *draw_icon;
    QString message = QString::number(mails);
    if (mails >= 0) {
      draw_icon = mails > 0 ? &icon_new : &icon;
      message += mails != 1 ? " new mails" : " new mail";
    }
    else {
      draw_icon = &error_icon;
      message = "ERROR!";
    }
    p->setRenderHint(QPainter::SmoothPixmapTransform);
    p->setRenderHint(QPainter::Antialiasing);

     m_svg.resize((int)contentsRect.width(), (int)contentsRect.height());

    // We place the icon and text
    p->drawPixmap(12, 12, draw_icon->pixmap((int)contentsRect.width(),(int)contentsRect.width()-20));
    p->save();
    p->setPen(Qt::white);
    p->drawText(contentsRect, Qt::AlignBottom | Qt::AlignHCenter, message);
    p->restore();
}

void MailWidget1::update_plasmoid (int i) {
    mails = i;
    update();
}

void MailWidget1::changeConfig() {
    general_group.writeEntry("user", my_ui.lineEdit->text());
    general_group.writeEntry("pw", my_ui.lineEdit_2->text());
    general_group.writeEntry("server", my_ui.lineEdit_3->text());
    general_group.writeEntry("type", my_ui.comboBox->currentText());
    general_group.writeEntry("time", my_ui.spinBox->value());
    general_group.writeEntry("play_sound", my_ui.checkBox->isChecked());
}

#include "plasmoid.moc"
#include "thread.moc"
