/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2009 Giulio Camuffo	 		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef INFOMANAGER_H
#define INFOMANAGER_H

#include <QObject>

#include <QtCore/QVariantMap>

class QGraphicsWidget;

class InfoManager : public QObject {
    Q_OBJECT

    public:
        InfoManager(void);
        ~InfoManager(void);

	void registerVolumeWidget(QGraphicsWidget* widget);
	void registerInfoWidget(QGraphicsWidget* widget);
	void registerButtonsWidget(QGraphicsWidget* widget);
	void registerRatingWidget(QGraphicsWidget* widget);
	void registerCoverWidget(QGraphicsWidget* widget);
	void registerMeterWidget(QGraphicsWidget* widget);
	void registerPlaylistWidget(QGraphicsWidget* widget);

    private slots:
	void updateMetadata(const QVariantMap& metadata);

    signals:
	void updateInfos(const QString& artist, const QString& album, const QString& title);
	void updateCover(const QString& path);
	void updateStatus(const int& status);
	void updatePosition(int pos, int total);
	void updateRating(const int& rating);
	void updateVolume(const int& volume);

};

#endif
