/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef PLAYWOLF_H
#define PLAYWOLF_H
 
#include <Plasma/PopupApplet>

///Ui includes
#include "ui_generalPage.h"
#include "ui_horizontalPage.h"
#include "ui_verticalPage.h"

class QGraphicsGridLayout;

namespace Plasma {
    class ExtenderItem;
};

class WolfMeter;
class WolfLabel;
class WolfButtons;
class InfoWidget;
class PlayerController;
class FlowLayout;
class DialogWidget;
class InfoManager;

class PlayWolf : public Plasma::PopupApplet
{
    Q_OBJECT
    public:
        PlayWolf(QObject *parent, const QVariantList &args);
        ~PlayWolf();

        void init();
	void constraintsEvent(Plasma::Constraints constraints);
	QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const;

	void hoverEnterEvent(QGraphicsSceneHoverEvent *event);
	void hoverLeaveEvent(QGraphicsSceneHoverEvent *event);
	void wheelEvent(QGraphicsSceneWheelEvent *event);

    protected:
	void createConfigurationInterface(KConfigDialog *parent);
	void initExtenderItem(Plasma::ExtenderItem *item);

    protected slots:
        void configAccepted();

    private:
	void resetWidgets();
	void popupEvent(bool show);

	WolfButtons *buttons;
	InfoWidget *infos;
	WolfMeter *meter;
	QGraphicsGridLayout *layout;
	WolfLabel *cover;
	QPixmap coverImage;
	Ui::generalPage generalUi;
	Ui::verticalPage verticalUi;
	Ui::horizontalPage horizontalUi;
	QFont customFont;
	DialogWidget *miscDialog;
	InfoWidget *infosDialog;
	InfoManager* infoManager;

	int widthOnPanel;
	int heightOnPanel;
	bool showCover;
	bool wheelSeek;
	bool showInformationsOnHPanel;
};
 
K_EXPORT_PLASMA_APPLET(playwolf, PlayWolf)
 
#endif