/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/


#include "wolfbuttons.h"

#include <KIcon>
#include <Plasma/IconWidget>
#include "flowlayout.h"
#include "playercontroller.h"

WolfButtons::WolfButtons(QGraphicsWidget *parent)
    : QGraphicsWidget(parent)
{
    layout = new FlowLayout(this);
    layout->setOrientation(FlowLayout::Horizontal);
    layout->setContentsMargins(0,0,0,0);
    setLayout(layout);

    playPause = new Plasma::IconWidget(KIcon("media-playback-start"),"",this);
    stop = new Plasma::IconWidget(KIcon("media-playback-stop"), "", this);
    next = new Plasma::IconWidget(KIcon("media-skip-forward"), "", this);
    prev = new Plasma::IconWidget(KIcon("media-skip-backward"), "", this);  
    showAmarok = new Plasma::IconWidget(KIcon("amarok"), "", this);

    playPause->setMinimumSize(20,20);
    stop->setMinimumSize(20,20);
    prev->setMinimumSize(20,20);
    next->setMinimumSize(20,20);
    showAmarok->setMinimumSize(20,20);

    layout->addItem(prev);
    layout->addItem(playPause);
    layout->addItem(stop);
    layout->addItem(next);
    
    showAmarok->hide();

    connect(playPause,SIGNAL(clicked()), this,SIGNAL(playPausePressed()));    
    connect(stop,SIGNAL(clicked()), this,SIGNAL(stopPressed()));
    connect(prev,SIGNAL(clicked()), this,SIGNAL(prevPressed()));
    connect(next,SIGNAL(clicked()), this,SIGNAL(nextPressed()));
    connect(showAmarok,SIGNAL(clicked()), this,SIGNAL(showAmarokPressed()));
}
 
WolfButtons::~WolfButtons() {
}

void WolfButtons::setStatus(const int &status) {

    if (status == PAUSED) {
	playPause->setIcon(KIcon("media-playback-start"));
	stop->setEnabled(true);
    }
    else if (status == PLAYING) {
	playPause->setIcon(KIcon("media-playback-pause"));	
	stop->setEnabled(true);
    }
    else {
	playPause->setIcon(KIcon("media-playback-start"));	
	stop->setEnabled(false);
    }

    playPause->update();
}

void WolfButtons::resizeEvent(QGraphicsSceneResizeEvent *event) {
    QGraphicsWidget::resizeEvent(event);

    adjustLayoutSpacing();
}

void WolfButtons::setAmarokButtonShown(bool amarokShow) {

    if (amarokShow) {
	if (layout->count() == 4) {
	    layout->setPrimarySpacing(0);
	    layout->addItem(showAmarok);
	    showAmarok->show();
	    if (not isVisible()) {
		show();
		hide();
	    }
	    adjustLayoutSpacing();
	}
    }
    else { 
	if (layout->count() == 5) {
	    layout->setPrimarySpacing(0);
	    layout->removeItem(showAmarok);
	    showAmarok->hide();
	    adjustLayoutSpacing();
	}
    }
}

bool WolfButtons::isAmarokButtonShown(void) {
    if (layout->count() == 4)
	return false;
    else
	return true;
}

void WolfButtons::adjustLayoutSpacing() {
    qreal spacing = playPause->contentsRect().width() - playPause->contentsRect().height();
    if (spacing >= 0)
	layout->setPrimarySpacing(spacing);
}

#include "wolfbuttons.moc"