/***********************************************************************************
* Run Command: Plasmoid to run commands without terminal.
* Copyright (C) 2008 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef RUNCOMMAND_HEADER
#define RUNCOMMAND_HEADER

#include <QMenu>
#include <QStringList>
#include <QtGui/QGraphicsProxyWidget>

#include <plasma/plasma_export.h>
#include <Plasma/Applet>

#include <khistorycombobox.h>
#include <KLineEdit>
#include <KCompletion>
#include <KAction>

#include "ui_configuration.h"

class KHistoryComboBox;

class PLASMA_EXPORT RunCommandComboBox : public QGraphicsProxyWidget
{
    public:
        RunCommandComboBox(QGraphicsWidget *parent = 0);

        KHistoryComboBox *comboBox;
        KLineEdit *lineEdit;
};


class QSizeF;

class RunCommand : public Plasma::Applet
{
    Q_OBJECT

    public:
        RunCommand(QObject *parent, const QVariantList &args);

        void init();
        void constraintsEvent(Plasma::Constraints);
        void setHistory();

    public slots:
        void configAccepted();
        void configClosed();
        void activated();
        void addContextMenuItems(QMenu* menu);
        void setWidth(int width);
        void setActive(int index);
        void clearHistory();
        void textChanged(QString text);
        void getCommand();
        void runCommand(QString command);

    protected:
        void createConfigurationInterface(KConfigDialog *parent);

    private:
        RunCommandComboBox *m_field;
        QStringList m_commands;
        QList<QAction*> m_actions;
        KCompletion *m_completion;
        KAction *m_destroyAction;
        Ui::configuration m_ui;
};

K_EXPORT_PLASMA_APPLET(runcommand, RunCommand)
#endif
