/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef STASKSTOOLTIP_H
#define STASKSTOOLTIP_H

#include <QBoxLayout>
#include <QGridLayout>
#include <QPixmap>
#include <QWidget>
#include <QLabel>
#include <QPainter>
#include <QPaintEvent>
#include <QEvent>
#include <QMouseEvent>

#include <Plasma/FrameSvg>

#include <taskmanager/groupmanager.h>
#include <KWindowSystem>
#include <NETRootInfo>

class QRectF;
class QSizeF;
class STasksWindowPreview;

class STasksToolTip : public QWidget
{
    Q_OBJECT

    public:
        STasksToolTip(int size, QWidget *parent);
        ~STasksToolTip();

    protected:
        void paintEvent(QPaintEvent *event);
        void resizeEvent(QResizeEvent *event);
        void enterEvent(QEvent *event);
        void leaveEvent(QEvent *event);
        void mousePressEvent(QMouseEvent *event);

    public slots:
        void setPreview(QPixmap pixmap, WId window = 0);
        void setTasks(TaskManager::ItemList tasks);
        void show();
        void hide(bool force = false);
        void updateTheme();

    private:
        QList<STasksWindowPreview*> m_previews;
        QGridLayout *m_mainLayout;
        QGridLayout *m_tasksLayout;
        Plasma::FrameSvg *m_background;
        bool m_canHide;
        bool m_alreadyShown;
        bool m_previewsAvailable;
        int m_size;
};

#endif
