/***********************************************************************************
* STasks
* Copyright (C) 2009 Marcin Baszczewski <marcin.baszczewski@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#include "stasks_windowpreview.h"

#include <QPainter>

#include <KWindowSystem>

//OTHER
#include <taskmanager/taskmanager.h>
#include <taskmanager/abstractgroupableitem.h>
#include <taskmanager/groupmanager.h>
#include <taskmanager/taskitem.h>
#include <taskmanager/startup.h>
#include <taskmanager/taskactions.h>

STasksWindowPreview::STasksWindowPreview(QPixmap pixmap, QWidget *parent) : QWidget(parent)
{
    m_pixmap = pixmap;

    m_window = 0;

    m_opacity = 0.75;

    m_background = new Plasma::FrameSvg(this);
    m_background->setImagePath("widgets/frame");
    m_background->setElementPrefix("raised");

    qreal left, top, right, bottom;

    m_background->getMargins(left, top, right, bottom);

    QSize size = QSize((pixmap.width() + left + right), (pixmap.height() + top + bottom));

    m_background->resizeFrame(size);

    setFixedSize(size);

    updateTheme();

    connect(m_background, SIGNAL(repaintNeeded()), this, SLOT(updateTheme()));
}

STasksWindowPreview::~STasksWindowPreview()
{
    delete m_background;
}

void STasksWindowPreview::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event)

    QPainter painter(this);
    painter.setOpacity(m_opacity);

    qreal left, top, right, bottom;

    m_background->getMargins(left, top, right, bottom);
    m_background->paintFrame(&painter);

    painter.setOpacity(1);
    painter.drawPixmap(left, top, m_pixmap);
}

void STasksWindowPreview::enterEvent(QEvent *event)
{
    Q_UNUSED(event)

    m_opacity = 1;

    update();
}

void STasksWindowPreview::leaveEvent(QEvent *event)
{
    Q_UNUSED(event)

    m_opacity = 0.75;

    update();
}

void STasksWindowPreview::mousePressEvent(QMouseEvent *event)
{
    KWindowSystem::forceActiveWindow(m_window);
    
    m_opacity = 1;
    event->ignore();
}

void STasksWindowPreview::setWindow(WId window)
{
    m_window = window;
}

void STasksWindowPreview::updateTheme()
{
    m_background->clearCache();

    update();
}
