/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef MMINFODISPLAY_H
#define MMINFODISPLAY_H

#include <QGroupBox>

#include <QGridLayout>
#include <QMouseEvent>

#include "mmlabel.h"

class MMInfoDisplay : public QGroupBox
{
Q_OBJECT   
 
    public:
        MMInfoDisplay(QWidget *parent = 0);
        virtual ~MMInfoDisplay(void);

	void placeObjects(void);
	void setTitle(const QString &title);
	void setTime(const QString &time);
	void setArtist(const QString &artist);
	void setAlbum(const QString &album);
	void setTrack(const QString &track);
	void setTextColor(QColor color);
	QColor getTextColor(void);
	void setIsOnPanel(bool,bool);
	bool getIsOnPanel(void);
	void setScrollStrings(bool);
	bool getScrollStrings(void);

	void mousePressEvent(QMouseEvent *);

    signals:
	void clicked();
    
    private:
        QImage m_image;
	MMLabel *time;
	MMLabel *title;
	MMLabel *artist;
	MMLabel *album;
	MMLabel *track;
//                 *coverImage,
	QColor textColor;
	bool isOnPanel;
	bool isSlim;
	int m_height;
	QGridLayout *m_layout;
	MMInfoDisplay *dialogWidget;
    
};


#endif



