/***********************************************************************************
* CPU Load: Plasmoid to monitor CPU Load.
* Copyright (C) 2008  Alexey Tyapkin
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/
// Here we avoid loading the header multiple times
#ifndef CPULOAD_HEADER
#define CPULOAD_HEADER
// We need the Plasma Applet headers
#include <KIcon>
 
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <Plasma/DataEngine>
#include <QFont>
#include <qwidget.h>
 
class QSizeF;
 
// Define our plasma Applet
class cpuload : public Plasma::Applet
{
    Q_OBJECT
    public:
        // Basic Create/Destroy
        cpuload(QObject *parent, const QVariantList &args);
        ~cpuload();
 
        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
	void init();

protected:
	inline bool test(int ifcpu1, int ifcpu2, int ifcpu3, int iscpu1, int iscpu2, int iscpu3) {
		if (((int)(ifcpu1 != iscpu1) + (int)(ifcpu2 != iscpu2) + (int)(ifcpu3 != iscpu3)) > 0)  {
			return true;
		}
		return false;
	}

protected slots:
        void dataUpdated(const QString& source, const Plasma::DataEngine::Data &data);

    private:
        Plasma::Svg m_svg;
        KIcon m_icon;
	int iXCount;
	int iYCount;
	int iXStep;
	int iYStep;
	int iWidth, iWidth1, iWidth2;
	int iHeight;
	int iCPU, iCPU1, iCPU2;
	int iSCPU, iSCPU1, iSCPU2;
	int iNCPU, iNCPU1, iNCPU2;
	int iDCPU, iDCPU1, iDCPU2;
        QPixmap *pm;//(size());
	QPixmap *dpm;
	QBitmap *mask;

	QPainterPath cpuNiceGraph;
	QPainterPath cpuDiskGraph;
	QPainterPath cpuSysGraph;
	QPainterPath cpuGraph;

	QColor userColor;
	QColor diskColor;
	QColor niceColor;
	QColor systemColor;

	QFont plasmoidFont;
	QString sCpuModel;
};

// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(cpuload, cpuload)
#endif
