/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_DIRECTORS

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/***********************************************************************
 * director.swg
 *
 *     This file contains support for director classes that proxy
 *     method calls from C++ to Java extensions.
 *
 * Author : Scott Michel (scottm@aero.org)
 *
 * This file was adapted from the python director.swg, written by
 * Mark Rose (mrose@stm.lbl.gov)
 ************************************************************************/

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (jthis_ == NULL) {
        weak_global_ = weak_global;
        if (jobj)
          jthis_ = ((weak_global_ || !mem_own) ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj));
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_ != NULL) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
  private:
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Acquire Java VM environment from Java VM */
    JNIEnv *swig_acquire_jenv() const {
      JNIEnv *env = NULL;
      swig_jvm_->AttachCurrentThread((void **) &env, NULL);
      return env;
    }

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnv *jenv = swig_acquire_jenv();
      jobject jobj = swig_self_.peek();
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      swig_self_.release(swig_acquire_jenv());
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  static jclass jclass_playercore_javaJNI = NULL;
  static jmethodID director_methids[5];
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <libplayercore/playercore.h>
#include <server/libplayerdrivers/driverregistry.h>



size_t player_devaddr_t_sizeof(void)
{
  return(sizeof(player_devaddr_t));
}
player_devaddr_t* buf_to_player_devaddr_t(void* buf)
{
  return((player_devaddr_t*)(buf));
}
void* player_devaddr_t_to_buf(player_devaddr_t* msg)
{
  return((void*)(msg));
}
size_t player_msghdr_t_sizeof(void)
{
  return(sizeof(player_msghdr_t));
}
player_msghdr_t* buf_to_player_msghdr_t(void* buf)
{
  return((player_msghdr_t*)(buf));
}
void* player_msghdr_t_to_buf(player_msghdr_t* msg)
{
  return((void*)(msg));
}
size_t player_point_2d_t_sizeof(void)
{
  return(sizeof(player_point_2d_t));
}
player_point_2d_t* buf_to_player_point_2d_t(void* buf)
{
  return((player_point_2d_t*)(buf));
}
void* player_point_2d_t_to_buf(player_point_2d_t* msg)
{
  return((void*)(msg));
}
size_t player_point_3d_t_sizeof(void)
{
  return(sizeof(player_point_3d_t));
}
player_point_3d_t* buf_to_player_point_3d_t(void* buf)
{
  return((player_point_3d_t*)(buf));
}
void* player_point_3d_t_to_buf(player_point_3d_t* msg)
{
  return((void*)(msg));
}
size_t player_pose_t_sizeof(void)
{
  return(sizeof(player_pose_t));
}
player_pose_t* buf_to_player_pose_t(void* buf)
{
  return((player_pose_t*)(buf));
}
void* player_pose_t_to_buf(player_pose_t* msg)
{
  return((void*)(msg));
}
size_t player_pose3d_t_sizeof(void)
{
  return(sizeof(player_pose3d_t));
}
player_pose3d_t* buf_to_player_pose3d_t(void* buf)
{
  return((player_pose3d_t*)(buf));
}
void* player_pose3d_t_to_buf(player_pose3d_t* msg)
{
  return((void*)(msg));
}
size_t player_bbox_t_sizeof(void)
{
  return(sizeof(player_bbox_t));
}
player_bbox_t* buf_to_player_bbox_t(void* buf)
{
  return((player_bbox_t*)(buf));
}
void* player_bbox_t_to_buf(player_bbox_t* msg)
{
  return((void*)(msg));
}
size_t player_bbox3d_t_sizeof(void)
{
  return(sizeof(player_bbox3d_t));
}
player_bbox3d_t* buf_to_player_bbox3d_t(void* buf)
{
  return((player_bbox3d_t*)(buf));
}
void* player_bbox3d_t_to_buf(player_bbox3d_t* msg)
{
  return((void*)(msg));
}
size_t player_segment_t_sizeof(void)
{
  return(sizeof(player_segment_t));
}
player_segment_t* buf_to_player_segment_t(void* buf)
{
  return((player_segment_t*)(buf));
}
void* player_segment_t_to_buf(player_segment_t* msg)
{
  return((void*)(msg));
}
size_t player_color_t_sizeof(void)
{
  return(sizeof(player_color_t));
}
player_color_t* buf_to_player_color_t(void* buf)
{
  return((player_color_t*)(buf));
}
void* player_color_t_to_buf(player_color_t* msg)
{
  return((void*)(msg));
}
size_t player_bool_t_sizeof(void)
{
  return(sizeof(player_bool_t));
}
player_bool_t* buf_to_player_bool_t(void* buf)
{
  return((player_bool_t*)(buf));
}
void* player_bool_t_to_buf(player_bool_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_actuator_t_sizeof(void)
{
  return(sizeof(player_actarray_actuator_t));
}
player_actarray_actuator_t* buf_to_player_actarray_actuator_t(void* buf)
{
  return((player_actarray_actuator_t*)(buf));
}
void* player_actarray_actuator_t_to_buf(player_actarray_actuator_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_data_t_sizeof(void)
{
  return(sizeof(player_actarray_data_t));
}
player_actarray_data_t* buf_to_player_actarray_data_t(void* buf)
{
  return((player_actarray_data_t*)(buf));
}
void* player_actarray_data_t_to_buf(player_actarray_data_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_actuatorgeom_t_sizeof(void)
{
  return(sizeof(player_actarray_actuatorgeom_t));
}
player_actarray_actuatorgeom_t* buf_to_player_actarray_actuatorgeom_t(void* buf)
{
  return((player_actarray_actuatorgeom_t*)(buf));
}
void* player_actarray_actuatorgeom_t_to_buf(player_actarray_actuatorgeom_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_geom_t_sizeof(void)
{
  return(sizeof(player_actarray_geom_t));
}
player_actarray_geom_t* buf_to_player_actarray_geom_t(void* buf)
{
  return((player_actarray_geom_t*)(buf));
}
void* player_actarray_geom_t_to_buf(player_actarray_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_position_cmd_t_sizeof(void)
{
  return(sizeof(player_actarray_position_cmd_t));
}
player_actarray_position_cmd_t* buf_to_player_actarray_position_cmd_t(void* buf)
{
  return((player_actarray_position_cmd_t*)(buf));
}
void* player_actarray_position_cmd_t_to_buf(player_actarray_position_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_speed_cmd_t_sizeof(void)
{
  return(sizeof(player_actarray_speed_cmd_t));
}
player_actarray_speed_cmd_t* buf_to_player_actarray_speed_cmd_t(void* buf)
{
  return((player_actarray_speed_cmd_t*)(buf));
}
void* player_actarray_speed_cmd_t_to_buf(player_actarray_speed_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_home_cmd_t_sizeof(void)
{
  return(sizeof(player_actarray_home_cmd_t));
}
player_actarray_home_cmd_t* buf_to_player_actarray_home_cmd_t(void* buf)
{
  return((player_actarray_home_cmd_t*)(buf));
}
void* player_actarray_home_cmd_t_to_buf(player_actarray_home_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_power_config_t_sizeof(void)
{
  return(sizeof(player_actarray_power_config_t));
}
player_actarray_power_config_t* buf_to_player_actarray_power_config_t(void* buf)
{
  return((player_actarray_power_config_t*)(buf));
}
void* player_actarray_power_config_t_to_buf(player_actarray_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_brakes_config_t_sizeof(void)
{
  return(sizeof(player_actarray_brakes_config_t));
}
player_actarray_brakes_config_t* buf_to_player_actarray_brakes_config_t(void* buf)
{
  return((player_actarray_brakes_config_t*)(buf));
}
void* player_actarray_brakes_config_t_to_buf(player_actarray_brakes_config_t* msg)
{
  return((void*)(msg));
}
size_t player_actarray_speed_config_t_sizeof(void)
{
  return(sizeof(player_actarray_speed_config_t));
}
player_actarray_speed_config_t* buf_to_player_actarray_speed_config_t(void* buf)
{
  return((player_actarray_speed_config_t*)(buf));
}
void* player_actarray_speed_config_t_to_buf(player_actarray_speed_config_t* msg)
{
  return((void*)(msg));
}
size_t player_aio_data_t_sizeof(void)
{
  return(sizeof(player_aio_data_t));
}
player_aio_data_t* buf_to_player_aio_data_t(void* buf)
{
  return((player_aio_data_t*)(buf));
}
void* player_aio_data_t_to_buf(player_aio_data_t* msg)
{
  return((void*)(msg));
}
size_t player_aio_cmd_t_sizeof(void)
{
  return(sizeof(player_aio_cmd_t));
}
player_aio_cmd_t* buf_to_player_aio_cmd_t(void* buf)
{
  return((player_aio_cmd_t*)(buf));
}
void* player_aio_cmd_t_to_buf(player_aio_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_audio_data_t_sizeof(void)
{
  return(sizeof(player_audio_data_t));
}
player_audio_data_t* buf_to_player_audio_data_t(void* buf)
{
  return((player_audio_data_t*)(buf));
}
void* player_audio_data_t_to_buf(player_audio_data_t* msg)
{
  return((void*)(msg));
}
size_t player_audio_cmd_t_sizeof(void)
{
  return(sizeof(player_audio_cmd_t));
}
player_audio_cmd_t* buf_to_player_audio_cmd_t(void* buf)
{
  return((player_audio_cmd_t*)(buf));
}
void* player_audio_cmd_t_to_buf(player_audio_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_audiodsp_data_t_sizeof(void)
{
  return(sizeof(player_audiodsp_data_t));
}
player_audiodsp_data_t* buf_to_player_audiodsp_data_t(void* buf)
{
  return((player_audiodsp_data_t*)(buf));
}
void* player_audiodsp_data_t_to_buf(player_audiodsp_data_t* msg)
{
  return((void*)(msg));
}
size_t player_audiodsp_cmd_t_sizeof(void)
{
  return(sizeof(player_audiodsp_cmd_t));
}
player_audiodsp_cmd_t* buf_to_player_audiodsp_cmd_t(void* buf)
{
  return((player_audiodsp_cmd_t*)(buf));
}
void* player_audiodsp_cmd_t_to_buf(player_audiodsp_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_audiodsp_config_t_sizeof(void)
{
  return(sizeof(player_audiodsp_config_t));
}
player_audiodsp_config_t* buf_to_player_audiodsp_config_t(void* buf)
{
  return((player_audiodsp_config_t*)(buf));
}
void* player_audiodsp_config_t_to_buf(player_audiodsp_config_t* msg)
{
  return((void*)(msg));
}
size_t player_audiomixer_cmd_t_sizeof(void)
{
  return(sizeof(player_audiomixer_cmd_t));
}
player_audiomixer_cmd_t* buf_to_player_audiomixer_cmd_t(void* buf)
{
  return((player_audiomixer_cmd_t*)(buf));
}
void* player_audiomixer_cmd_t_to_buf(player_audiomixer_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_audiomixer_config_t_sizeof(void)
{
  return(sizeof(player_audiomixer_config_t));
}
player_audiomixer_config_t* buf_to_player_audiomixer_config_t(void* buf)
{
  return((player_audiomixer_config_t*)(buf));
}
void* player_audiomixer_config_t_to_buf(player_audiomixer_config_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_data_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_data_t));
}
player_blinkenlight_data_t* buf_to_player_blinkenlight_data_t(void* buf)
{
  return((player_blinkenlight_data_t*)(buf));
}
void* player_blinkenlight_data_t_to_buf(player_blinkenlight_data_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_cmd_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_cmd_t));
}
player_blinkenlight_cmd_t* buf_to_player_blinkenlight_cmd_t(void* buf)
{
  return((player_blinkenlight_cmd_t*)(buf));
}
void* player_blinkenlight_cmd_t_to_buf(player_blinkenlight_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_cmd_power_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_cmd_power_t));
}
player_blinkenlight_cmd_power_t* buf_to_player_blinkenlight_cmd_power_t(void* buf)
{
  return((player_blinkenlight_cmd_power_t*)(buf));
}
void* player_blinkenlight_cmd_power_t_to_buf(player_blinkenlight_cmd_power_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_cmd_color_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_cmd_color_t));
}
player_blinkenlight_cmd_color_t* buf_to_player_blinkenlight_cmd_color_t(void* buf)
{
  return((player_blinkenlight_cmd_color_t*)(buf));
}
void* player_blinkenlight_cmd_color_t_to_buf(player_blinkenlight_cmd_color_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_cmd_period_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_cmd_period_t));
}
player_blinkenlight_cmd_period_t* buf_to_player_blinkenlight_cmd_period_t(void* buf)
{
  return((player_blinkenlight_cmd_period_t*)(buf));
}
void* player_blinkenlight_cmd_period_t_to_buf(player_blinkenlight_cmd_period_t* msg)
{
  return((void*)(msg));
}
size_t player_blinkenlight_cmd_dutycycle_t_sizeof(void)
{
  return(sizeof(player_blinkenlight_cmd_dutycycle_t));
}
player_blinkenlight_cmd_dutycycle_t* buf_to_player_blinkenlight_cmd_dutycycle_t(void* buf)
{
  return((player_blinkenlight_cmd_dutycycle_t*)(buf));
}
void* player_blinkenlight_cmd_dutycycle_t_to_buf(player_blinkenlight_cmd_dutycycle_t* msg)
{
  return((void*)(msg));
}
size_t player_blobfinder_blob_t_sizeof(void)
{
  return(sizeof(player_blobfinder_blob_t));
}
player_blobfinder_blob_t* buf_to_player_blobfinder_blob_t(void* buf)
{
  return((player_blobfinder_blob_t*)(buf));
}
void* player_blobfinder_blob_t_to_buf(player_blobfinder_blob_t* msg)
{
  return((void*)(msg));
}
size_t player_blobfinder_data_t_sizeof(void)
{
  return(sizeof(player_blobfinder_data_t));
}
player_blobfinder_data_t* buf_to_player_blobfinder_data_t(void* buf)
{
  return((player_blobfinder_data_t*)(buf));
}
void* player_blobfinder_data_t_to_buf(player_blobfinder_data_t* msg)
{
  return((void*)(msg));
}
size_t player_blobfinder_color_config_t_sizeof(void)
{
  return(sizeof(player_blobfinder_color_config_t));
}
player_blobfinder_color_config_t* buf_to_player_blobfinder_color_config_t(void* buf)
{
  return((player_blobfinder_color_config_t*)(buf));
}
void* player_blobfinder_color_config_t_to_buf(player_blobfinder_color_config_t* msg)
{
  return((void*)(msg));
}
size_t player_blobfinder_imager_config_t_sizeof(void)
{
  return(sizeof(player_blobfinder_imager_config_t));
}
player_blobfinder_imager_config_t* buf_to_player_blobfinder_imager_config_t(void* buf)
{
  return((player_blobfinder_imager_config_t*)(buf));
}
void* player_blobfinder_imager_config_t_to_buf(player_blobfinder_imager_config_t* msg)
{
  return((void*)(msg));
}
size_t player_bumper_data_t_sizeof(void)
{
  return(sizeof(player_bumper_data_t));
}
player_bumper_data_t* buf_to_player_bumper_data_t(void* buf)
{
  return((player_bumper_data_t*)(buf));
}
void* player_bumper_data_t_to_buf(player_bumper_data_t* msg)
{
  return((void*)(msg));
}
size_t player_bumper_define_t_sizeof(void)
{
  return(sizeof(player_bumper_define_t));
}
player_bumper_define_t* buf_to_player_bumper_define_t(void* buf)
{
  return((player_bumper_define_t*)(buf));
}
void* player_bumper_define_t_to_buf(player_bumper_define_t* msg)
{
  return((void*)(msg));
}
size_t player_bumper_geom_t_sizeof(void)
{
  return(sizeof(player_bumper_geom_t));
}
player_bumper_geom_t* buf_to_player_bumper_geom_t(void* buf)
{
  return((player_bumper_geom_t*)(buf));
}
void* player_bumper_geom_t_to_buf(player_bumper_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_camera_data_t_sizeof(void)
{
  return(sizeof(player_camera_data_t));
}
player_camera_data_t* buf_to_player_camera_data_t(void* buf)
{
  return((player_camera_data_t*)(buf));
}
void* player_camera_data_t_to_buf(player_camera_data_t* msg)
{
  return((void*)(msg));
}
size_t player_dio_data_t_sizeof(void)
{
  return(sizeof(player_dio_data_t));
}
player_dio_data_t* buf_to_player_dio_data_t(void* buf)
{
  return((player_dio_data_t*)(buf));
}
void* player_dio_data_t_to_buf(player_dio_data_t* msg)
{
  return((void*)(msg));
}
size_t player_dio_cmd_t_sizeof(void)
{
  return(sizeof(player_dio_cmd_t));
}
player_dio_cmd_t* buf_to_player_dio_cmd_t(void* buf)
{
  return((player_dio_cmd_t*)(buf));
}
void* player_dio_cmd_t_to_buf(player_dio_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_energy_data_t_sizeof(void)
{
  return(sizeof(player_energy_data_t));
}
player_energy_data_t* buf_to_player_energy_data_t(void* buf)
{
  return((player_energy_data_t*)(buf));
}
void* player_energy_data_t_to_buf(player_energy_data_t* msg)
{
  return((void*)(msg));
}
size_t player_energy_chargepolicy_config_t_sizeof(void)
{
  return(sizeof(player_energy_chargepolicy_config_t));
}
player_energy_chargepolicy_config_t* buf_to_player_energy_chargepolicy_config_t(void* buf)
{
  return((player_energy_chargepolicy_config_t*)(buf));
}
void* player_energy_chargepolicy_config_t_to_buf(player_energy_chargepolicy_config_t* msg)
{
  return((void*)(msg));
}
size_t player_fiducial_item_t_sizeof(void)
{
  return(sizeof(player_fiducial_item_t));
}
player_fiducial_item_t* buf_to_player_fiducial_item_t(void* buf)
{
  return((player_fiducial_item_t*)(buf));
}
void* player_fiducial_item_t_to_buf(player_fiducial_item_t* msg)
{
  return((void*)(msg));
}
size_t player_fiducial_data_t_sizeof(void)
{
  return(sizeof(player_fiducial_data_t));
}
player_fiducial_data_t* buf_to_player_fiducial_data_t(void* buf)
{
  return((player_fiducial_data_t*)(buf));
}
void* player_fiducial_data_t_to_buf(player_fiducial_data_t* msg)
{
  return((void*)(msg));
}
size_t player_fiducial_geom_t_sizeof(void)
{
  return(sizeof(player_fiducial_geom_t));
}
player_fiducial_geom_t* buf_to_player_fiducial_geom_t(void* buf)
{
  return((player_fiducial_geom_t*)(buf));
}
void* player_fiducial_geom_t_to_buf(player_fiducial_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_fiducial_fov_t_sizeof(void)
{
  return(sizeof(player_fiducial_fov_t));
}
player_fiducial_fov_t* buf_to_player_fiducial_fov_t(void* buf)
{
  return((player_fiducial_fov_t*)(buf));
}
void* player_fiducial_fov_t_to_buf(player_fiducial_fov_t* msg)
{
  return((void*)(msg));
}
size_t player_fiducial_id_t_sizeof(void)
{
  return(sizeof(player_fiducial_id_t));
}
player_fiducial_id_t* buf_to_player_fiducial_id_t(void* buf)
{
  return((player_fiducial_id_t*)(buf));
}
void* player_fiducial_id_t_to_buf(player_fiducial_id_t* msg)
{
  return((void*)(msg));
}
size_t player_gps_data_t_sizeof(void)
{
  return(sizeof(player_gps_data_t));
}
player_gps_data_t* buf_to_player_gps_data_t(void* buf)
{
  return((player_gps_data_t*)(buf));
}
void* player_gps_data_t_to_buf(player_gps_data_t* msg)
{
  return((void*)(msg));
}
size_t player_graphics2d_cmd_points_t_sizeof(void)
{
  return(sizeof(player_graphics2d_cmd_points_t));
}
player_graphics2d_cmd_points_t* buf_to_player_graphics2d_cmd_points_t(void* buf)
{
  return((player_graphics2d_cmd_points_t*)(buf));
}
void* player_graphics2d_cmd_points_t_to_buf(player_graphics2d_cmd_points_t* msg)
{
  return((void*)(msg));
}
size_t player_graphics2d_cmd_polyline_t_sizeof(void)
{
  return(sizeof(player_graphics2d_cmd_polyline_t));
}
player_graphics2d_cmd_polyline_t* buf_to_player_graphics2d_cmd_polyline_t(void* buf)
{
  return((player_graphics2d_cmd_polyline_t*)(buf));
}
void* player_graphics2d_cmd_polyline_t_to_buf(player_graphics2d_cmd_polyline_t* msg)
{
  return((void*)(msg));
}
size_t player_graphics2d_cmd_polygon_t_sizeof(void)
{
  return(sizeof(player_graphics2d_cmd_polygon_t));
}
player_graphics2d_cmd_polygon_t* buf_to_player_graphics2d_cmd_polygon_t(void* buf)
{
  return((player_graphics2d_cmd_polygon_t*)(buf));
}
void* player_graphics2d_cmd_polygon_t_to_buf(player_graphics2d_cmd_polygon_t* msg)
{
  return((void*)(msg));
}
size_t player_graphics3d_cmd_draw_t_sizeof(void)
{
  return(sizeof(player_graphics3d_cmd_draw_t));
}
player_graphics3d_cmd_draw_t* buf_to_player_graphics3d_cmd_draw_t(void* buf)
{
  return((player_graphics3d_cmd_draw_t*)(buf));
}
void* player_graphics3d_cmd_draw_t_to_buf(player_graphics3d_cmd_draw_t* msg)
{
  return((void*)(msg));
}
size_t player_gripper_data_t_sizeof(void)
{
  return(sizeof(player_gripper_data_t));
}
player_gripper_data_t* buf_to_player_gripper_data_t(void* buf)
{
  return((player_gripper_data_t*)(buf));
}
void* player_gripper_data_t_to_buf(player_gripper_data_t* msg)
{
  return((void*)(msg));
}
size_t player_gripper_cmd_t_sizeof(void)
{
  return(sizeof(player_gripper_cmd_t));
}
player_gripper_cmd_t* buf_to_player_gripper_cmd_t(void* buf)
{
  return((player_gripper_cmd_t*)(buf));
}
void* player_gripper_cmd_t_to_buf(player_gripper_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_gripper_geom_t_sizeof(void)
{
  return(sizeof(player_gripper_geom_t));
}
player_gripper_geom_t* buf_to_player_gripper_geom_t(void* buf)
{
  return((player_gripper_geom_t*)(buf));
}
void* player_gripper_geom_t_to_buf(player_gripper_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_ir_data_t_sizeof(void)
{
  return(sizeof(player_ir_data_t));
}
player_ir_data_t* buf_to_player_ir_data_t(void* buf)
{
  return((player_ir_data_t*)(buf));
}
void* player_ir_data_t_to_buf(player_ir_data_t* msg)
{
  return((void*)(msg));
}
size_t player_ir_pose_t_sizeof(void)
{
  return(sizeof(player_ir_pose_t));
}
player_ir_pose_t* buf_to_player_ir_pose_t(void* buf)
{
  return((player_ir_pose_t*)(buf));
}
void* player_ir_pose_t_to_buf(player_ir_pose_t* msg)
{
  return((void*)(msg));
}
size_t player_ir_power_req_t_sizeof(void)
{
  return(sizeof(player_ir_power_req_t));
}
player_ir_power_req_t* buf_to_player_ir_power_req_t(void* buf)
{
  return((player_ir_power_req_t*)(buf));
}
void* player_ir_power_req_t_to_buf(player_ir_power_req_t* msg)
{
  return((void*)(msg));
}
size_t player_joystick_data_t_sizeof(void)
{
  return(sizeof(player_joystick_data_t));
}
player_joystick_data_t* buf_to_player_joystick_data_t(void* buf)
{
  return((player_joystick_data_t*)(buf));
}
void* player_joystick_data_t_to_buf(player_joystick_data_t* msg)
{
  return((void*)(msg));
}
size_t player_laser_data_t_sizeof(void)
{
  return(sizeof(player_laser_data_t));
}
player_laser_data_t* buf_to_player_laser_data_t(void* buf)
{
  return((player_laser_data_t*)(buf));
}
void* player_laser_data_t_to_buf(player_laser_data_t* msg)
{
  return((void*)(msg));
}
size_t player_laser_data_scanpose_t_sizeof(void)
{
  return(sizeof(player_laser_data_scanpose_t));
}
player_laser_data_scanpose_t* buf_to_player_laser_data_scanpose_t(void* buf)
{
  return((player_laser_data_scanpose_t*)(buf));
}
void* player_laser_data_scanpose_t_to_buf(player_laser_data_scanpose_t* msg)
{
  return((void*)(msg));
}
size_t player_laser_geom_t_sizeof(void)
{
  return(sizeof(player_laser_geom_t));
}
player_laser_geom_t* buf_to_player_laser_geom_t(void* buf)
{
  return((player_laser_geom_t*)(buf));
}
void* player_laser_geom_t_to_buf(player_laser_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_laser_config_t_sizeof(void)
{
  return(sizeof(player_laser_config_t));
}
player_laser_config_t* buf_to_player_laser_config_t(void* buf)
{
  return((player_laser_config_t*)(buf));
}
void* player_laser_config_t_to_buf(player_laser_config_t* msg)
{
  return((void*)(msg));
}
size_t player_laser_power_config_t_sizeof(void)
{
  return(sizeof(player_laser_power_config_t));
}
player_laser_power_config_t* buf_to_player_laser_power_config_t(void* buf)
{
  return((player_laser_power_config_t*)(buf));
}
void* player_laser_power_config_t_to_buf(player_laser_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_data_t_sizeof(void)
{
  return(sizeof(player_limb_data_t));
}
player_limb_data_t* buf_to_player_limb_data_t(void* buf)
{
  return((player_limb_data_t*)(buf));
}
void* player_limb_data_t_to_buf(player_limb_data_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_home_cmd_t_sizeof(void)
{
  return(sizeof(player_limb_home_cmd_t));
}
player_limb_home_cmd_t* buf_to_player_limb_home_cmd_t(void* buf)
{
  return((player_limb_home_cmd_t*)(buf));
}
void* player_limb_home_cmd_t_to_buf(player_limb_home_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_stop_cmd_t_sizeof(void)
{
  return(sizeof(player_limb_stop_cmd_t));
}
player_limb_stop_cmd_t* buf_to_player_limb_stop_cmd_t(void* buf)
{
  return((player_limb_stop_cmd_t*)(buf));
}
void* player_limb_stop_cmd_t_to_buf(player_limb_stop_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_setpose_cmd_t_sizeof(void)
{
  return(sizeof(player_limb_setpose_cmd_t));
}
player_limb_setpose_cmd_t* buf_to_player_limb_setpose_cmd_t(void* buf)
{
  return((player_limb_setpose_cmd_t*)(buf));
}
void* player_limb_setpose_cmd_t_to_buf(player_limb_setpose_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_setposition_cmd_t_sizeof(void)
{
  return(sizeof(player_limb_setposition_cmd_t));
}
player_limb_setposition_cmd_t* buf_to_player_limb_setposition_cmd_t(void* buf)
{
  return((player_limb_setposition_cmd_t*)(buf));
}
void* player_limb_setposition_cmd_t_to_buf(player_limb_setposition_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_vecmove_cmd_t_sizeof(void)
{
  return(sizeof(player_limb_vecmove_cmd_t));
}
player_limb_vecmove_cmd_t* buf_to_player_limb_vecmove_cmd_t(void* buf)
{
  return((player_limb_vecmove_cmd_t*)(buf));
}
void* player_limb_vecmove_cmd_t_to_buf(player_limb_vecmove_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_power_req_t_sizeof(void)
{
  return(sizeof(player_limb_power_req_t));
}
player_limb_power_req_t* buf_to_player_limb_power_req_t(void* buf)
{
  return((player_limb_power_req_t*)(buf));
}
void* player_limb_power_req_t_to_buf(player_limb_power_req_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_brakes_req_t_sizeof(void)
{
  return(sizeof(player_limb_brakes_req_t));
}
player_limb_brakes_req_t* buf_to_player_limb_brakes_req_t(void* buf)
{
  return((player_limb_brakes_req_t*)(buf));
}
void* player_limb_brakes_req_t_to_buf(player_limb_brakes_req_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_geom_req_t_sizeof(void)
{
  return(sizeof(player_limb_geom_req_t));
}
player_limb_geom_req_t* buf_to_player_limb_geom_req_t(void* buf)
{
  return((player_limb_geom_req_t*)(buf));
}
void* player_limb_geom_req_t_to_buf(player_limb_geom_req_t* msg)
{
  return((void*)(msg));
}
size_t player_limb_speed_req_t_sizeof(void)
{
  return(sizeof(player_limb_speed_req_t));
}
player_limb_speed_req_t* buf_to_player_limb_speed_req_t(void* buf)
{
  return((player_limb_speed_req_t*)(buf));
}
void* player_limb_speed_req_t_to_buf(player_limb_speed_req_t* msg)
{
  return((void*)(msg));
}
size_t player_localize_hypoth_t_sizeof(void)
{
  return(sizeof(player_localize_hypoth_t));
}
player_localize_hypoth_t* buf_to_player_localize_hypoth_t(void* buf)
{
  return((player_localize_hypoth_t*)(buf));
}
void* player_localize_hypoth_t_to_buf(player_localize_hypoth_t* msg)
{
  return((void*)(msg));
}
size_t player_localize_data_t_sizeof(void)
{
  return(sizeof(player_localize_data_t));
}
player_localize_data_t* buf_to_player_localize_data_t(void* buf)
{
  return((player_localize_data_t*)(buf));
}
void* player_localize_data_t_to_buf(player_localize_data_t* msg)
{
  return((void*)(msg));
}
size_t player_localize_set_pose_t_sizeof(void)
{
  return(sizeof(player_localize_set_pose_t));
}
player_localize_set_pose_t* buf_to_player_localize_set_pose_t(void* buf)
{
  return((player_localize_set_pose_t*)(buf));
}
void* player_localize_set_pose_t_to_buf(player_localize_set_pose_t* msg)
{
  return((void*)(msg));
}
size_t player_localize_particle_t_sizeof(void)
{
  return(sizeof(player_localize_particle_t));
}
player_localize_particle_t* buf_to_player_localize_particle_t(void* buf)
{
  return((player_localize_particle_t*)(buf));
}
void* player_localize_particle_t_to_buf(player_localize_particle_t* msg)
{
  return((void*)(msg));
}
size_t player_localize_get_particles_t_sizeof(void)
{
  return(sizeof(player_localize_get_particles_t));
}
player_localize_get_particles_t* buf_to_player_localize_get_particles_t(void* buf)
{
  return((player_localize_get_particles_t*)(buf));
}
void* player_localize_get_particles_t_to_buf(player_localize_get_particles_t* msg)
{
  return((void*)(msg));
}
size_t player_log_set_write_state_t_sizeof(void)
{
  return(sizeof(player_log_set_write_state_t));
}
player_log_set_write_state_t* buf_to_player_log_set_write_state_t(void* buf)
{
  return((player_log_set_write_state_t*)(buf));
}
void* player_log_set_write_state_t_to_buf(player_log_set_write_state_t* msg)
{
  return((void*)(msg));
}
size_t player_log_set_read_state_t_sizeof(void)
{
  return(sizeof(player_log_set_read_state_t));
}
player_log_set_read_state_t* buf_to_player_log_set_read_state_t(void* buf)
{
  return((player_log_set_read_state_t*)(buf));
}
void* player_log_set_read_state_t_to_buf(player_log_set_read_state_t* msg)
{
  return((void*)(msg));
}
size_t player_log_set_read_rewind_t_sizeof(void)
{
  return(sizeof(player_log_set_read_rewind_t));
}
player_log_set_read_rewind_t* buf_to_player_log_set_read_rewind_t(void* buf)
{
  return((player_log_set_read_rewind_t*)(buf));
}
void* player_log_set_read_rewind_t_to_buf(player_log_set_read_rewind_t* msg)
{
  return((void*)(msg));
}
size_t player_log_get_state_t_sizeof(void)
{
  return(sizeof(player_log_get_state_t));
}
player_log_get_state_t* buf_to_player_log_get_state_t(void* buf)
{
  return((player_log_get_state_t*)(buf));
}
void* player_log_get_state_t_to_buf(player_log_get_state_t* msg)
{
  return((void*)(msg));
}
size_t player_log_set_filename_t_sizeof(void)
{
  return(sizeof(player_log_set_filename_t));
}
player_log_set_filename_t* buf_to_player_log_set_filename_t(void* buf)
{
  return((player_log_set_filename_t*)(buf));
}
void* player_log_set_filename_t_to_buf(player_log_set_filename_t* msg)
{
  return((void*)(msg));
}
size_t player_map_info_t_sizeof(void)
{
  return(sizeof(player_map_info_t));
}
player_map_info_t* buf_to_player_map_info_t(void* buf)
{
  return((player_map_info_t*)(buf));
}
void* player_map_info_t_to_buf(player_map_info_t* msg)
{
  return((void*)(msg));
}
size_t player_map_data_t_sizeof(void)
{
  return(sizeof(player_map_data_t));
}
player_map_data_t* buf_to_player_map_data_t(void* buf)
{
  return((player_map_data_t*)(buf));
}
void* player_map_data_t_to_buf(player_map_data_t* msg)
{
  return((void*)(msg));
}
size_t player_map_data_vector_t_sizeof(void)
{
  return(sizeof(player_map_data_vector_t));
}
player_map_data_vector_t* buf_to_player_map_data_vector_t(void* buf)
{
  return((player_map_data_vector_t*)(buf));
}
void* player_map_data_vector_t_to_buf(player_map_data_vector_t* msg)
{
  return((void*)(msg));
}
size_t player_mcom_data_t_sizeof(void)
{
  return(sizeof(player_mcom_data_t));
}
player_mcom_data_t* buf_to_player_mcom_data_t(void* buf)
{
  return((player_mcom_data_t*)(buf));
}
void* player_mcom_data_t_to_buf(player_mcom_data_t* msg)
{
  return((void*)(msg));
}
size_t player_mcom_config_t_sizeof(void)
{
  return(sizeof(player_mcom_config_t));
}
player_mcom_config_t* buf_to_player_mcom_config_t(void* buf)
{
  return((player_mcom_config_t*)(buf));
}
void* player_mcom_config_t_to_buf(player_mcom_config_t* msg)
{
  return((void*)(msg));
}
size_t player_mcom_return_t_sizeof(void)
{
  return(sizeof(player_mcom_return_t));
}
player_mcom_return_t* buf_to_player_mcom_return_t(void* buf)
{
  return((player_mcom_return_t*)(buf));
}
void* player_mcom_return_t_to_buf(player_mcom_return_t* msg)
{
  return((void*)(msg));
}
size_t player_opaque_data_t_sizeof(void)
{
  return(sizeof(player_opaque_data_t));
}
player_opaque_data_t* buf_to_player_opaque_data_t(void* buf)
{
  return((player_opaque_data_t*)(buf));
}
void* player_opaque_data_t_to_buf(player_opaque_data_t* msg)
{
  return((void*)(msg));
}
size_t player_planner_data_t_sizeof(void)
{
  return(sizeof(player_planner_data_t));
}
player_planner_data_t* buf_to_player_planner_data_t(void* buf)
{
  return((player_planner_data_t*)(buf));
}
void* player_planner_data_t_to_buf(player_planner_data_t* msg)
{
  return((void*)(msg));
}
size_t player_planner_cmd_t_sizeof(void)
{
  return(sizeof(player_planner_cmd_t));
}
player_planner_cmd_t* buf_to_player_planner_cmd_t(void* buf)
{
  return((player_planner_cmd_t*)(buf));
}
void* player_planner_cmd_t_to_buf(player_planner_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_planner_waypoints_req_t_sizeof(void)
{
  return(sizeof(player_planner_waypoints_req_t));
}
player_planner_waypoints_req_t* buf_to_player_planner_waypoints_req_t(void* buf)
{
  return((player_planner_waypoints_req_t*)(buf));
}
void* player_planner_waypoints_req_t_to_buf(player_planner_waypoints_req_t* msg)
{
  return((void*)(msg));
}
size_t player_planner_enable_req_t_sizeof(void)
{
  return(sizeof(player_planner_enable_req_t));
}
player_planner_enable_req_t* buf_to_player_planner_enable_req_t(void* buf)
{
  return((player_planner_enable_req_t*)(buf));
}
void* player_planner_enable_req_t_to_buf(player_planner_enable_req_t* msg)
{
  return((void*)(msg));
}
size_t player_device_devlist_t_sizeof(void)
{
  return(sizeof(player_device_devlist_t));
}
player_device_devlist_t* buf_to_player_device_devlist_t(void* buf)
{
  return((player_device_devlist_t*)(buf));
}
void* player_device_devlist_t_to_buf(player_device_devlist_t* msg)
{
  return((void*)(msg));
}
size_t player_device_driverinfo_t_sizeof(void)
{
  return(sizeof(player_device_driverinfo_t));
}
player_device_driverinfo_t* buf_to_player_device_driverinfo_t(void* buf)
{
  return((player_device_driverinfo_t*)(buf));
}
void* player_device_driverinfo_t_to_buf(player_device_driverinfo_t* msg)
{
  return((void*)(msg));
}
size_t player_device_req_t_sizeof(void)
{
  return(sizeof(player_device_req_t));
}
player_device_req_t* buf_to_player_device_req_t(void* buf)
{
  return((player_device_req_t*)(buf));
}
void* player_device_req_t_to_buf(player_device_req_t* msg)
{
  return((void*)(msg));
}
size_t player_device_data_req_t_sizeof(void)
{
  return(sizeof(player_device_data_req_t));
}
player_device_data_req_t* buf_to_player_device_data_req_t(void* buf)
{
  return((player_device_data_req_t*)(buf));
}
void* player_device_data_req_t_to_buf(player_device_data_req_t* msg)
{
  return((void*)(msg));
}
size_t player_device_datamode_req_t_sizeof(void)
{
  return(sizeof(player_device_datamode_req_t));
}
player_device_datamode_req_t* buf_to_player_device_datamode_req_t(void* buf)
{
  return((player_device_datamode_req_t*)(buf));
}
void* player_device_datamode_req_t_to_buf(player_device_datamode_req_t* msg)
{
  return((void*)(msg));
}
size_t player_device_auth_req_t_sizeof(void)
{
  return(sizeof(player_device_auth_req_t));
}
player_device_auth_req_t* buf_to_player_device_auth_req_t(void* buf)
{
  return((player_device_auth_req_t*)(buf));
}
void* player_device_auth_req_t_to_buf(player_device_auth_req_t* msg)
{
  return((void*)(msg));
}
size_t player_device_nameservice_req_t_sizeof(void)
{
  return(sizeof(player_device_nameservice_req_t));
}
player_device_nameservice_req_t* buf_to_player_device_nameservice_req_t(void* buf)
{
  return((player_device_nameservice_req_t*)(buf));
}
void* player_device_nameservice_req_t_to_buf(player_device_nameservice_req_t* msg)
{
  return((void*)(msg));
}
size_t player_add_replace_rule_req_t_sizeof(void)
{
  return(sizeof(player_add_replace_rule_req_t));
}
player_add_replace_rule_req_t* buf_to_player_add_replace_rule_req_t(void* buf)
{
  return((player_add_replace_rule_req_t*)(buf));
}
void* player_add_replace_rule_req_t_to_buf(player_add_replace_rule_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_data_t_sizeof(void)
{
  return(sizeof(player_position1d_data_t));
}
player_position1d_data_t* buf_to_player_position1d_data_t(void* buf)
{
  return((player_position1d_data_t*)(buf));
}
void* player_position1d_data_t_to_buf(player_position1d_data_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_cmd_vel_t_sizeof(void)
{
  return(sizeof(player_position1d_cmd_vel_t));
}
player_position1d_cmd_vel_t* buf_to_player_position1d_cmd_vel_t(void* buf)
{
  return((player_position1d_cmd_vel_t*)(buf));
}
void* player_position1d_cmd_vel_t_to_buf(player_position1d_cmd_vel_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_cmd_pos_t_sizeof(void)
{
  return(sizeof(player_position1d_cmd_pos_t));
}
player_position1d_cmd_pos_t* buf_to_player_position1d_cmd_pos_t(void* buf)
{
  return((player_position1d_cmd_pos_t*)(buf));
}
void* player_position1d_cmd_pos_t_to_buf(player_position1d_cmd_pos_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_geom_t_sizeof(void)
{
  return(sizeof(player_position1d_geom_t));
}
player_position1d_geom_t* buf_to_player_position1d_geom_t(void* buf)
{
  return((player_position1d_geom_t*)(buf));
}
void* player_position1d_geom_t_to_buf(player_position1d_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_power_config_t_sizeof(void)
{
  return(sizeof(player_position1d_power_config_t));
}
player_position1d_power_config_t* buf_to_player_position1d_power_config_t(void* buf)
{
  return((player_position1d_power_config_t*)(buf));
}
void* player_position1d_power_config_t_to_buf(player_position1d_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_velocity_mode_config_t_sizeof(void)
{
  return(sizeof(player_position1d_velocity_mode_config_t));
}
player_position1d_velocity_mode_config_t* buf_to_player_position1d_velocity_mode_config_t(void* buf)
{
  return((player_position1d_velocity_mode_config_t*)(buf));
}
void* player_position1d_velocity_mode_config_t_to_buf(player_position1d_velocity_mode_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_reset_odom_config_t_sizeof(void)
{
  return(sizeof(player_position1d_reset_odom_config_t));
}
player_position1d_reset_odom_config_t* buf_to_player_position1d_reset_odom_config_t(void* buf)
{
  return((player_position1d_reset_odom_config_t*)(buf));
}
void* player_position1d_reset_odom_config_t_to_buf(player_position1d_reset_odom_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_position_mode_req_t_sizeof(void)
{
  return(sizeof(player_position1d_position_mode_req_t));
}
player_position1d_position_mode_req_t* buf_to_player_position1d_position_mode_req_t(void* buf)
{
  return((player_position1d_position_mode_req_t*)(buf));
}
void* player_position1d_position_mode_req_t_to_buf(player_position1d_position_mode_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_set_odom_req_t_sizeof(void)
{
  return(sizeof(player_position1d_set_odom_req_t));
}
player_position1d_set_odom_req_t* buf_to_player_position1d_set_odom_req_t(void* buf)
{
  return((player_position1d_set_odom_req_t*)(buf));
}
void* player_position1d_set_odom_req_t_to_buf(player_position1d_set_odom_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_speed_pid_req_t_sizeof(void)
{
  return(sizeof(player_position1d_speed_pid_req_t));
}
player_position1d_speed_pid_req_t* buf_to_player_position1d_speed_pid_req_t(void* buf)
{
  return((player_position1d_speed_pid_req_t*)(buf));
}
void* player_position1d_speed_pid_req_t_to_buf(player_position1d_speed_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_position_pid_req_t_sizeof(void)
{
  return(sizeof(player_position1d_position_pid_req_t));
}
player_position1d_position_pid_req_t* buf_to_player_position1d_position_pid_req_t(void* buf)
{
  return((player_position1d_position_pid_req_t*)(buf));
}
void* player_position1d_position_pid_req_t_to_buf(player_position1d_position_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position1d_speed_prof_req_t_sizeof(void)
{
  return(sizeof(player_position1d_speed_prof_req_t));
}
player_position1d_speed_prof_req_t* buf_to_player_position1d_speed_prof_req_t(void* buf)
{
  return((player_position1d_speed_prof_req_t*)(buf));
}
void* player_position1d_speed_prof_req_t_to_buf(player_position1d_speed_prof_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_data_t_sizeof(void)
{
  return(sizeof(player_position2d_data_t));
}
player_position2d_data_t* buf_to_player_position2d_data_t(void* buf)
{
  return((player_position2d_data_t*)(buf));
}
void* player_position2d_data_t_to_buf(player_position2d_data_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_cmd_vel_t_sizeof(void)
{
  return(sizeof(player_position2d_cmd_vel_t));
}
player_position2d_cmd_vel_t* buf_to_player_position2d_cmd_vel_t(void* buf)
{
  return((player_position2d_cmd_vel_t*)(buf));
}
void* player_position2d_cmd_vel_t_to_buf(player_position2d_cmd_vel_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_cmd_pos_t_sizeof(void)
{
  return(sizeof(player_position2d_cmd_pos_t));
}
player_position2d_cmd_pos_t* buf_to_player_position2d_cmd_pos_t(void* buf)
{
  return((player_position2d_cmd_pos_t*)(buf));
}
void* player_position2d_cmd_pos_t_to_buf(player_position2d_cmd_pos_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_cmd_car_t_sizeof(void)
{
  return(sizeof(player_position2d_cmd_car_t));
}
player_position2d_cmd_car_t* buf_to_player_position2d_cmd_car_t(void* buf)
{
  return((player_position2d_cmd_car_t*)(buf));
}
void* player_position2d_cmd_car_t_to_buf(player_position2d_cmd_car_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_geom_t_sizeof(void)
{
  return(sizeof(player_position2d_geom_t));
}
player_position2d_geom_t* buf_to_player_position2d_geom_t(void* buf)
{
  return((player_position2d_geom_t*)(buf));
}
void* player_position2d_geom_t_to_buf(player_position2d_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_power_config_t_sizeof(void)
{
  return(sizeof(player_position2d_power_config_t));
}
player_position2d_power_config_t* buf_to_player_position2d_power_config_t(void* buf)
{
  return((player_position2d_power_config_t*)(buf));
}
void* player_position2d_power_config_t_to_buf(player_position2d_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_velocity_mode_config_t_sizeof(void)
{
  return(sizeof(player_position2d_velocity_mode_config_t));
}
player_position2d_velocity_mode_config_t* buf_to_player_position2d_velocity_mode_config_t(void* buf)
{
  return((player_position2d_velocity_mode_config_t*)(buf));
}
void* player_position2d_velocity_mode_config_t_to_buf(player_position2d_velocity_mode_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_reset_odom_config_t_sizeof(void)
{
  return(sizeof(player_position2d_reset_odom_config_t));
}
player_position2d_reset_odom_config_t* buf_to_player_position2d_reset_odom_config_t(void* buf)
{
  return((player_position2d_reset_odom_config_t*)(buf));
}
void* player_position2d_reset_odom_config_t_to_buf(player_position2d_reset_odom_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_position_mode_req_t_sizeof(void)
{
  return(sizeof(player_position2d_position_mode_req_t));
}
player_position2d_position_mode_req_t* buf_to_player_position2d_position_mode_req_t(void* buf)
{
  return((player_position2d_position_mode_req_t*)(buf));
}
void* player_position2d_position_mode_req_t_to_buf(player_position2d_position_mode_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_set_odom_req_t_sizeof(void)
{
  return(sizeof(player_position2d_set_odom_req_t));
}
player_position2d_set_odom_req_t* buf_to_player_position2d_set_odom_req_t(void* buf)
{
  return((player_position2d_set_odom_req_t*)(buf));
}
void* player_position2d_set_odom_req_t_to_buf(player_position2d_set_odom_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_speed_pid_req_t_sizeof(void)
{
  return(sizeof(player_position2d_speed_pid_req_t));
}
player_position2d_speed_pid_req_t* buf_to_player_position2d_speed_pid_req_t(void* buf)
{
  return((player_position2d_speed_pid_req_t*)(buf));
}
void* player_position2d_speed_pid_req_t_to_buf(player_position2d_speed_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_position_pid_req_t_sizeof(void)
{
  return(sizeof(player_position2d_position_pid_req_t));
}
player_position2d_position_pid_req_t* buf_to_player_position2d_position_pid_req_t(void* buf)
{
  return((player_position2d_position_pid_req_t*)(buf));
}
void* player_position2d_position_pid_req_t_to_buf(player_position2d_position_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position2d_speed_prof_req_t_sizeof(void)
{
  return(sizeof(player_position2d_speed_prof_req_t));
}
player_position2d_speed_prof_req_t* buf_to_player_position2d_speed_prof_req_t(void* buf)
{
  return((player_position2d_speed_prof_req_t*)(buf));
}
void* player_position2d_speed_prof_req_t_to_buf(player_position2d_speed_prof_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_data_t_sizeof(void)
{
  return(sizeof(player_position3d_data_t));
}
player_position3d_data_t* buf_to_player_position3d_data_t(void* buf)
{
  return((player_position3d_data_t*)(buf));
}
void* player_position3d_data_t_to_buf(player_position3d_data_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_cmd_pos_t_sizeof(void)
{
  return(sizeof(player_position3d_cmd_pos_t));
}
player_position3d_cmd_pos_t* buf_to_player_position3d_cmd_pos_t(void* buf)
{
  return((player_position3d_cmd_pos_t*)(buf));
}
void* player_position3d_cmd_pos_t_to_buf(player_position3d_cmd_pos_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_cmd_vel_t_sizeof(void)
{
  return(sizeof(player_position3d_cmd_vel_t));
}
player_position3d_cmd_vel_t* buf_to_player_position3d_cmd_vel_t(void* buf)
{
  return((player_position3d_cmd_vel_t*)(buf));
}
void* player_position3d_cmd_vel_t_to_buf(player_position3d_cmd_vel_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_geom_t_sizeof(void)
{
  return(sizeof(player_position3d_geom_t));
}
player_position3d_geom_t* buf_to_player_position3d_geom_t(void* buf)
{
  return((player_position3d_geom_t*)(buf));
}
void* player_position3d_geom_t_to_buf(player_position3d_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_power_config_t_sizeof(void)
{
  return(sizeof(player_position3d_power_config_t));
}
player_position3d_power_config_t* buf_to_player_position3d_power_config_t(void* buf)
{
  return((player_position3d_power_config_t*)(buf));
}
void* player_position3d_power_config_t_to_buf(player_position3d_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_position_mode_req_t_sizeof(void)
{
  return(sizeof(player_position3d_position_mode_req_t));
}
player_position3d_position_mode_req_t* buf_to_player_position3d_position_mode_req_t(void* buf)
{
  return((player_position3d_position_mode_req_t*)(buf));
}
void* player_position3d_position_mode_req_t_to_buf(player_position3d_position_mode_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_velocity_mode_config_t_sizeof(void)
{
  return(sizeof(player_position3d_velocity_mode_config_t));
}
player_position3d_velocity_mode_config_t* buf_to_player_position3d_velocity_mode_config_t(void* buf)
{
  return((player_position3d_velocity_mode_config_t*)(buf));
}
void* player_position3d_velocity_mode_config_t_to_buf(player_position3d_velocity_mode_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_set_odom_req_t_sizeof(void)
{
  return(sizeof(player_position3d_set_odom_req_t));
}
player_position3d_set_odom_req_t* buf_to_player_position3d_set_odom_req_t(void* buf)
{
  return((player_position3d_set_odom_req_t*)(buf));
}
void* player_position3d_set_odom_req_t_to_buf(player_position3d_set_odom_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_reset_odom_config_t_sizeof(void)
{
  return(sizeof(player_position3d_reset_odom_config_t));
}
player_position3d_reset_odom_config_t* buf_to_player_position3d_reset_odom_config_t(void* buf)
{
  return((player_position3d_reset_odom_config_t*)(buf));
}
void* player_position3d_reset_odom_config_t_to_buf(player_position3d_reset_odom_config_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_speed_pid_req_t_sizeof(void)
{
  return(sizeof(player_position3d_speed_pid_req_t));
}
player_position3d_speed_pid_req_t* buf_to_player_position3d_speed_pid_req_t(void* buf)
{
  return((player_position3d_speed_pid_req_t*)(buf));
}
void* player_position3d_speed_pid_req_t_to_buf(player_position3d_speed_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_position_pid_req_t_sizeof(void)
{
  return(sizeof(player_position3d_position_pid_req_t));
}
player_position3d_position_pid_req_t* buf_to_player_position3d_position_pid_req_t(void* buf)
{
  return((player_position3d_position_pid_req_t*)(buf));
}
void* player_position3d_position_pid_req_t_to_buf(player_position3d_position_pid_req_t* msg)
{
  return((void*)(msg));
}
size_t player_position3d_speed_prof_req_t_sizeof(void)
{
  return(sizeof(player_position3d_speed_prof_req_t));
}
player_position3d_speed_prof_req_t* buf_to_player_position3d_speed_prof_req_t(void* buf)
{
  return((player_position3d_speed_prof_req_t*)(buf));
}
void* player_position3d_speed_prof_req_t_to_buf(player_position3d_speed_prof_req_t* msg)
{
  return((void*)(msg));
}
size_t player_power_data_t_sizeof(void)
{
  return(sizeof(player_power_data_t));
}
player_power_data_t* buf_to_player_power_data_t(void* buf)
{
  return((player_power_data_t*)(buf));
}
void* player_power_data_t_to_buf(player_power_data_t* msg)
{
  return((void*)(msg));
}
size_t player_power_chargepolicy_config_t_sizeof(void)
{
  return(sizeof(player_power_chargepolicy_config_t));
}
player_power_chargepolicy_config_t* buf_to_player_power_chargepolicy_config_t(void* buf)
{
  return((player_power_chargepolicy_config_t*)(buf));
}
void* player_power_chargepolicy_config_t_to_buf(player_power_chargepolicy_config_t* msg)
{
  return((void*)(msg));
}
size_t player_ptz_data_t_sizeof(void)
{
  return(sizeof(player_ptz_data_t));
}
player_ptz_data_t* buf_to_player_ptz_data_t(void* buf)
{
  return((player_ptz_data_t*)(buf));
}
void* player_ptz_data_t_to_buf(player_ptz_data_t* msg)
{
  return((void*)(msg));
}
size_t player_ptz_cmd_t_sizeof(void)
{
  return(sizeof(player_ptz_cmd_t));
}
player_ptz_cmd_t* buf_to_player_ptz_cmd_t(void* buf)
{
  return((player_ptz_cmd_t*)(buf));
}
void* player_ptz_cmd_t_to_buf(player_ptz_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_ptz_geom_t_sizeof(void)
{
  return(sizeof(player_ptz_geom_t));
}
player_ptz_geom_t* buf_to_player_ptz_geom_t(void* buf)
{
  return((player_ptz_geom_t*)(buf));
}
void* player_ptz_geom_t_to_buf(player_ptz_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_ptz_req_generic_t_sizeof(void)
{
  return(sizeof(player_ptz_req_generic_t));
}
player_ptz_req_generic_t* buf_to_player_ptz_req_generic_t(void* buf)
{
  return((player_ptz_req_generic_t*)(buf));
}
void* player_ptz_req_generic_t_to_buf(player_ptz_req_generic_t* msg)
{
  return((void*)(msg));
}
size_t player_ptz_req_control_mode_t_sizeof(void)
{
  return(sizeof(player_ptz_req_control_mode_t));
}
player_ptz_req_control_mode_t* buf_to_player_ptz_req_control_mode_t(void* buf)
{
  return((player_ptz_req_control_mode_t*)(buf));
}
void* player_ptz_req_control_mode_t_to_buf(player_ptz_req_control_mode_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_data_t_sizeof(void)
{
  return(sizeof(player_simulation_data_t));
}
player_simulation_data_t* buf_to_player_simulation_data_t(void* buf)
{
  return((player_simulation_data_t*)(buf));
}
void* player_simulation_data_t_to_buf(player_simulation_data_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_cmd_t_sizeof(void)
{
  return(sizeof(player_simulation_cmd_t));
}
player_simulation_cmd_t* buf_to_player_simulation_cmd_t(void* buf)
{
  return((player_simulation_cmd_t*)(buf));
}
void* player_simulation_cmd_t_to_buf(player_simulation_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_pose2d_req_t_sizeof(void)
{
  return(sizeof(player_simulation_pose2d_req_t));
}
player_simulation_pose2d_req_t* buf_to_player_simulation_pose2d_req_t(void* buf)
{
  return((player_simulation_pose2d_req_t*)(buf));
}
void* player_simulation_pose2d_req_t_to_buf(player_simulation_pose2d_req_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_property_int_req_t_sizeof(void)
{
  return(sizeof(player_simulation_property_int_req_t));
}
player_simulation_property_int_req_t* buf_to_player_simulation_property_int_req_t(void* buf)
{
  return((player_simulation_property_int_req_t*)(buf));
}
void* player_simulation_property_int_req_t_to_buf(player_simulation_property_int_req_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_property_float_req_t_sizeof(void)
{
  return(sizeof(player_simulation_property_float_req_t));
}
player_simulation_property_float_req_t* buf_to_player_simulation_property_float_req_t(void* buf)
{
  return((player_simulation_property_float_req_t*)(buf));
}
void* player_simulation_property_float_req_t_to_buf(player_simulation_property_float_req_t* msg)
{
  return((void*)(msg));
}
size_t player_simulation_property_string_req_t_sizeof(void)
{
  return(sizeof(player_simulation_property_string_req_t));
}
player_simulation_property_string_req_t* buf_to_player_simulation_property_string_req_t(void* buf)
{
  return((player_simulation_property_string_req_t*)(buf));
}
void* player_simulation_property_string_req_t_to_buf(player_simulation_property_string_req_t* msg)
{
  return((void*)(msg));
}
size_t player_sonar_data_t_sizeof(void)
{
  return(sizeof(player_sonar_data_t));
}
player_sonar_data_t* buf_to_player_sonar_data_t(void* buf)
{
  return((player_sonar_data_t*)(buf));
}
void* player_sonar_data_t_to_buf(player_sonar_data_t* msg)
{
  return((void*)(msg));
}
size_t player_sonar_geom_t_sizeof(void)
{
  return(sizeof(player_sonar_geom_t));
}
player_sonar_geom_t* buf_to_player_sonar_geom_t(void* buf)
{
  return((player_sonar_geom_t*)(buf));
}
void* player_sonar_geom_t_to_buf(player_sonar_geom_t* msg)
{
  return((void*)(msg));
}
size_t player_sonar_power_config_t_sizeof(void)
{
  return(sizeof(player_sonar_power_config_t));
}
player_sonar_power_config_t* buf_to_player_sonar_power_config_t(void* buf)
{
  return((player_sonar_power_config_t*)(buf));
}
void* player_sonar_power_config_t_to_buf(player_sonar_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_sound_cmd_t_sizeof(void)
{
  return(sizeof(player_sound_cmd_t));
}
player_sound_cmd_t* buf_to_player_sound_cmd_t(void* buf)
{
  return((player_sound_cmd_t*)(buf));
}
void* player_sound_cmd_t_to_buf(player_sound_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_speech_cmd_t_sizeof(void)
{
  return(sizeof(player_speech_cmd_t));
}
player_speech_cmd_t* buf_to_player_speech_cmd_t(void* buf)
{
  return((player_speech_cmd_t*)(buf));
}
void* player_speech_cmd_t_to_buf(player_speech_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_speech_recognition_data_t_sizeof(void)
{
  return(sizeof(player_speech_recognition_data_t));
}
player_speech_recognition_data_t* buf_to_player_speech_recognition_data_t(void* buf)
{
  return((player_speech_recognition_data_t*)(buf));
}
void* player_speech_recognition_data_t_to_buf(player_speech_recognition_data_t* msg)
{
  return((void*)(msg));
}
size_t player_truth_pose_t_sizeof(void)
{
  return(sizeof(player_truth_pose_t));
}
player_truth_pose_t* buf_to_player_truth_pose_t(void* buf)
{
  return((player_truth_pose_t*)(buf));
}
void* player_truth_pose_t_to_buf(player_truth_pose_t* msg)
{
  return((void*)(msg));
}
size_t player_truth_fiducial_id_t_sizeof(void)
{
  return(sizeof(player_truth_fiducial_id_t));
}
player_truth_fiducial_id_t* buf_to_player_truth_fiducial_id_t(void* buf)
{
  return((player_truth_fiducial_id_t*)(buf));
}
void* player_truth_fiducial_id_t_to_buf(player_truth_fiducial_id_t* msg)
{
  return((void*)(msg));
}
size_t player_waveform_data_t_sizeof(void)
{
  return(sizeof(player_waveform_data_t));
}
player_waveform_data_t* buf_to_player_waveform_data_t(void* buf)
{
  return((player_waveform_data_t*)(buf));
}
void* player_waveform_data_t_to_buf(player_waveform_data_t* msg)
{
  return((void*)(msg));
}
size_t player_wifi_link_t_sizeof(void)
{
  return(sizeof(player_wifi_link_t));
}
player_wifi_link_t* buf_to_player_wifi_link_t(void* buf)
{
  return((player_wifi_link_t*)(buf));
}
void* player_wifi_link_t_to_buf(player_wifi_link_t* msg)
{
  return((void*)(msg));
}
size_t player_wifi_data_t_sizeof(void)
{
  return(sizeof(player_wifi_data_t));
}
player_wifi_data_t* buf_to_player_wifi_data_t(void* buf)
{
  return((player_wifi_data_t*)(buf));
}
void* player_wifi_data_t_to_buf(player_wifi_data_t* msg)
{
  return((void*)(msg));
}
size_t player_wifi_mac_req_t_sizeof(void)
{
  return(sizeof(player_wifi_mac_req_t));
}
player_wifi_mac_req_t* buf_to_player_wifi_mac_req_t(void* buf)
{
  return((player_wifi_mac_req_t*)(buf));
}
void* player_wifi_mac_req_t_to_buf(player_wifi_mac_req_t* msg)
{
  return((void*)(msg));
}
size_t player_wifi_iwspy_addr_req_t_sizeof(void)
{
  return(sizeof(player_wifi_iwspy_addr_req_t));
}
player_wifi_iwspy_addr_req_t* buf_to_player_wifi_iwspy_addr_req_t(void* buf)
{
  return((player_wifi_iwspy_addr_req_t*)(buf));
}
void* player_wifi_iwspy_addr_req_t_to_buf(player_wifi_iwspy_addr_req_t* msg)
{
  return((void*)(msg));
}
size_t player_rfid_tag_t_sizeof(void)
{
  return(sizeof(player_rfid_tag_t));
}
player_rfid_tag_t* buf_to_player_rfid_tag_t(void* buf)
{
  return((player_rfid_tag_t*)(buf));
}
void* player_rfid_tag_t_to_buf(player_rfid_tag_t* msg)
{
  return((void*)(msg));
}
size_t player_rfid_data_t_sizeof(void)
{
  return(sizeof(player_rfid_data_t));
}
player_rfid_data_t* buf_to_player_rfid_data_t(void* buf)
{
  return((player_rfid_data_t*)(buf));
}
void* player_rfid_data_t_to_buf(player_rfid_data_t* msg)
{
  return((void*)(msg));
}
size_t player_rfid_cmd_t_sizeof(void)
{
  return(sizeof(player_rfid_cmd_t));
}
player_rfid_cmd_t* buf_to_player_rfid_cmd_t(void* buf)
{
  return((player_rfid_cmd_t*)(buf));
}
void* player_rfid_cmd_t_to_buf(player_rfid_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_node_data_t_sizeof(void)
{
  return(sizeof(player_wsn_node_data_t));
}
player_wsn_node_data_t* buf_to_player_wsn_node_data_t(void* buf)
{
  return((player_wsn_node_data_t*)(buf));
}
void* player_wsn_node_data_t_to_buf(player_wsn_node_data_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_data_t_sizeof(void)
{
  return(sizeof(player_wsn_data_t));
}
player_wsn_data_t* buf_to_player_wsn_data_t(void* buf)
{
  return((player_wsn_data_t*)(buf));
}
void* player_wsn_data_t_to_buf(player_wsn_data_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_cmd_t_sizeof(void)
{
  return(sizeof(player_wsn_cmd_t));
}
player_wsn_cmd_t* buf_to_player_wsn_cmd_t(void* buf)
{
  return((player_wsn_cmd_t*)(buf));
}
void* player_wsn_cmd_t_to_buf(player_wsn_cmd_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_power_config_t_sizeof(void)
{
  return(sizeof(player_wsn_power_config_t));
}
player_wsn_power_config_t* buf_to_player_wsn_power_config_t(void* buf)
{
  return((player_wsn_power_config_t*)(buf));
}
void* player_wsn_power_config_t_to_buf(player_wsn_power_config_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_datatype_config_t_sizeof(void)
{
  return(sizeof(player_wsn_datatype_config_t));
}
player_wsn_datatype_config_t* buf_to_player_wsn_datatype_config_t(void* buf)
{
  return((player_wsn_datatype_config_t*)(buf));
}
void* player_wsn_datatype_config_t_to_buf(player_wsn_datatype_config_t* msg)
{
  return((void*)(msg));
}
size_t player_wsn_datafreq_config_t_sizeof(void)
{
  return(sizeof(player_wsn_datafreq_config_t));
}
player_wsn_datafreq_config_t* buf_to_player_wsn_datafreq_config_t(void* buf)
{
  return((player_wsn_datafreq_config_t*)(buf));
}
void* player_wsn_datafreq_config_t_to_buf(player_wsn_datafreq_config_t* msg)
{
  return((void*)(msg));
}




/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "playercore_java_wrap.h"

SwigDirector_Driver::SwigDirector_Driver(JNIEnv *jenv, ConfigFile *cf, int section, bool overwrite_cmds, size_t queue_maxlen, int interf): Driver(cf, section, overwrite_cmds, queue_maxlen, interf), Swig::Director(jenv) {
}

SwigDirector_Driver::SwigDirector_Driver(JNIEnv *jenv, ConfigFile *cf, int section, bool overwrite_cmds, size_t queue_maxlen): Driver(cf, section, overwrite_cmds, queue_maxlen), Swig::Director(jenv) {
}

SwigDirector_Driver::~SwigDirector_Driver() {
    swig_disconnect_director_self("swigDirectorDisconnect");
}


int SwigDirector_Driver::Setup() {
    int result ;
    jint jresult  = 0 ;
    JNIEnv * jenv = (JNIEnv *) NULL ;
    jobject  jobj = (jobject) NULL ;
    
    if (!swig_override[0]) {
        jenv = swig_acquire_jenv();
        SWIG_JavaThrowException(jenv, SWIG_JavaDirectorPureVirtual,
        "Attempted to invoke pure virtual method Driver::Setup.");
        return result;
    }
    jenv = swig_acquire_jenv();
    jobj = swig_get_self(jenv);
    if (jobj != NULL && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_playercore_javaJNI, Swig::director_methids[0], jobj);
        if (jenv->ExceptionOccurred()) return result;
        result = (int)jresult; 
    }  else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
    }
    return result;
}

void SwigDirector_Driver::Update() {
    JNIEnv * jenv = (JNIEnv *) NULL ;
    jobject  jobj = (jobject) NULL ;
    
    if (!swig_override[1]) {
        Driver::Update();
        return;
    }
    jenv = swig_acquire_jenv();
    jobj = swig_get_self(jenv);
    if (jobj != NULL && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jenv->CallStaticVoidMethod(Swig::jclass_playercore_javaJNI, Swig::director_methids[1], jobj);
        if (jenv->ExceptionOccurred()) return ;
    }  else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
    }
}

void SwigDirector_Driver::MainQuit() {
    JNIEnv * jenv = (JNIEnv *) NULL ;
    jobject  jobj = (jobject) NULL ;
    
    if (!swig_override[2]) {
        Driver::MainQuit();
        return;
    }
    jenv = swig_acquire_jenv();
    jobj = swig_get_self(jenv);
    if (jobj != NULL && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jenv->CallStaticVoidMethod(Swig::jclass_playercore_javaJNI, Swig::director_methids[2], jobj);
        if (jenv->ExceptionOccurred()) return ;
    }  else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
    }
}

int SwigDirector_Driver::Shutdown() {
    int result ;
    jint jresult  = 0 ;
    JNIEnv * jenv = (JNIEnv *) NULL ;
    jobject  jobj = (jobject) NULL ;
    
    if (!swig_override[3]) {
        jenv = swig_acquire_jenv();
        SWIG_JavaThrowException(jenv, SWIG_JavaDirectorPureVirtual,
        "Attempted to invoke pure virtual method Driver::Shutdown.");
        return result;
    }
    jenv = swig_acquire_jenv();
    jobj = swig_get_self(jenv);
    if (jobj != NULL && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_playercore_javaJNI, Swig::director_methids[3], jobj);
        if (jenv->ExceptionOccurred()) return result;
        result = (int)jresult; 
    }  else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
    }
    return result;
}

void SwigDirector_Driver::Main() {
    JNIEnv * jenv = (JNIEnv *) NULL ;
    jobject  jobj = (jobject) NULL ;
    
    if (!swig_override[4]) {
        Driver::Main();
        return;
    }
    jenv = swig_acquire_jenv();
    jobj = swig_get_self(jenv);
    if (jobj != NULL && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jenv->CallStaticVoidMethod(Swig::jclass_playercore_javaJNI, Swig::director_methids[4], jobj);
        if (jenv->ExceptionOccurred()) return ;
    }  else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
    }
}

void SwigDirector_Driver::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
    static struct {
        const char *mname;
        const char *mdesc;
        jmethodID base_methid;
    } methods[] = {
        {
            "Setup", "()I", NULL 
        },
        {
            "Update", "()V", NULL 
        },
        {
            "MainQuit", "()V", NULL 
        },
        {
            "Shutdown", "()I", NULL 
        },
        {
            "Main", "()V", NULL 
        }
    };
    
    static jclass baseclass  = 0 ;
    
    if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
        if (baseclass == NULL) {
            baseclass = jenv->FindClass("net/sourceforge/playerstage/Jplayercore/Driver");
            if (baseclass == NULL) return;
            baseclass = (jclass) jenv->NewGlobalRef(baseclass);
        }
        bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
        for (int i = 0; i < 5; ++i) {
            if (methods[i].base_methid == NULL) {
                methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
                if (methods[i].base_methid == NULL) return;
            }
            swig_override[i] = false;
            if (derived) {
                jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
                swig_override[i] = (methid != methods[i].base_methid);
                jenv->ExceptionClear();
            }
        }
    }
}



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_hostname_1to_1packedaddr(JNIEnv *jenv, jclass jcls, jlongArray jarg1, jstring jarg2) {
    jint jresult = 0 ;
    uint32_t *arg1 = (uint32_t *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    uint32_t temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return 0;
        }
        if (jenv->GetArrayLength(jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return 0;
        }
        arg1 = &temp1; 
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)hostname_to_packedaddr(arg1,(char const *)arg2);
    
    jresult = (jint)result; 
    {
        jlong jvalue = (jlong)temp1;
        jenv->SetLongArrayRegion(jarg1, 0, 1, &jvalue);
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1ConfigFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    uint32_t arg1 ;
    uint32_t arg2 ;
    ConfigFile *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (uint32_t)jarg1; 
    arg2 = (uint32_t)jarg2; 
    result = (ConfigFile *)new ConfigFile(arg1,arg2);
    
    *(ConfigFile **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1ConfigFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    uint32_t arg2 ;
    ConfigFile *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = (uint32_t)jarg2; 
    result = (ConfigFile *)new ConfigFile((char const *)arg1,arg2);
    
    *(ConfigFile **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1ConfigFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1Load(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (bool)(arg1)->Load((char const *)arg2);
    
    jresult = (jboolean)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1WarnUnused(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    result = (bool)(arg1)->WarnUnused();
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadBool(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jboolean jarg4) {
    jboolean jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    bool arg4 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = jarg4 ? true : false; 
    result = (bool)(arg1)->ReadBool(arg2,(char const *)arg3,arg4);
    
    jresult = (jboolean)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadString(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4) {
    jstring jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (char *)(arg1)->ReadString(arg2,(char const *)arg3,(char const *)arg4);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    result = (int)(arg1)->ReadInt(arg2,(char const *)arg3,arg4);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jdouble jarg4) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    double arg4 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (double)jarg4; 
    result = (double)(arg1)->ReadFloat(arg2,(char const *)arg3,arg4);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jdouble jarg4) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    double arg4 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (double)jarg4; 
    result = (double)(arg1)->ReadLength(arg2,(char const *)arg3,arg4);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jdouble jarg4) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    double arg4 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (double)jarg4; 
    result = (double)(arg1)->ReadAngle(arg2,(char const *)arg3,arg4);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    uint32_t arg4 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (uint32_t)jarg4; 
    result = (uint32_t)(arg1)->ReadColor(arg2,(char const *)arg3,arg4);
    
    jresult = (jlong)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4) {
    jstring jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    char *arg4 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (char *)(arg1)->ReadFilename(arg2,(char const *)arg3,(char const *)arg4);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1GetTupleCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (int)(arg1)->GetTupleCount(arg2,(char const *)arg3);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleString(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jstring jarg5) {
    jstring jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    char *arg5 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
            if (!arg5) return 0;
        }
    }
    result = (char *)(arg1)->ReadTupleString(arg2,(char const *)arg3,arg4,(char const *)arg5);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg5) jenv->ReleaseStringUTFChars(jarg5, arg5); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleInt(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jint jarg5) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    int arg5 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    result = (int)(arg1)->ReadTupleInt(arg2,(char const *)arg3,arg4,arg5);
    
    jresult = (jint)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jdouble jarg5) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    double arg5 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    arg5 = (double)jarg5; 
    result = (double)(arg1)->ReadTupleFloat(arg2,(char const *)arg3,arg4,arg5);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jdouble jarg5) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    double arg5 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    arg5 = (double)jarg5; 
    result = (double)(arg1)->ReadTupleLength(arg2,(char const *)arg3,arg4,arg5);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jdouble jarg5) {
    jdouble jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    double arg5 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    arg5 = (double)jarg5; 
    result = (double)(arg1)->ReadTupleAngle(arg2,(char const *)arg3,arg4,arg5);
    
    jresult = (jdouble)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadTupleColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jlong jarg5) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    uint32_t arg5 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    arg4 = (int)jarg4; 
    arg5 = (uint32_t)jarg5; 
    result = (uint32_t)(arg1)->ReadTupleColor(arg2,(char const *)arg3,arg4,arg5);
    
    jresult = (jlong)result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ReadDeviceAddr(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jint jarg5, jint jarg6, jstring jarg7) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    int arg3 ;
    char *arg4 = (char *) 0 ;
    int arg5 ;
    int arg6 ;
    char *arg7 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    arg3 = (int)jarg3; 
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    arg5 = (int)jarg5; 
    arg6 = (int)jarg6; 
    {
        arg7 = 0;
        if (jarg7) {
            arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
            if (!arg7) return 0;
        }
    }
    result = (int)(arg1)->ReadDeviceAddr(arg2,arg3,(char const *)arg4,arg5,arg6,(char const *)arg7);
    
    jresult = (jint)result; 
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    {
        if (arg7) jenv->ReleaseStringUTFChars(jarg7, arg7); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ParseDriver(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (bool)(arg1)->ParseDriver(arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1ParseAllDrivers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    result = (bool)(arg1)->ParseAllDrivers();
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1GetSectionCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    result = (int)(arg1)->GetSectionCount();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1GetSectionType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)(arg1)->GetSectionType(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1LookupSection(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)(arg1)->LookupSection((char const *)arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1GetSectionParent(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)(arg1)->GetSectionParent(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1DumpTokens(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    (arg1)->DumpTokens();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1DumpSections(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    (arg1)->DumpSections();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1DumpFields(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    (arg1)->DumpFields();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1filename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg1->filename) delete [] arg1->filename;
        if (arg2) {
            arg1->filename = (char *) (new char[strlen(arg2)+1]);
            strcpy((char *) arg1->filename,arg2);
        } else {
            arg1->filename = 0;
        }
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ConfigFile_1filename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    result = (char *) ((arg1)->filename);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_LOCALHOST_1ADDR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16777343;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Device(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    player_devaddr_t arg1 ;
    Driver *arg2 = (Driver *) 0 ;
    Device *result;
    player_devaddr_t *argp1 ;
    
    (void)jenv;
    (void)jcls;
    argp1 = *(player_devaddr_t **)(void *)&jarg1; 
    if (!argp1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg1 = *argp1; 
    arg2 = *(Driver **)(void *)&jarg2; 
    result = (Device *)new Device(arg1,arg2);
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1Device(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Device *arg1 = (Device *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1Subscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    result = (int)(arg1)->Subscribe(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1Unsubscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    result = (int)(arg1)->Unsubscribe(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1PutMsg_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jshort jarg3, jshort jarg4, jlong jarg5, jlong jarg6, jlong jarg7) {
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    uint8_t arg3 ;
    uint8_t arg4 ;
    void *arg5 = (void *) 0 ;
    size_t arg6 ;
    double *arg7 = (double *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = (uint8_t)jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = *(void **)(void *)&jarg5; 
    arg6 = (size_t)jarg6; 
    arg7 = *(double **)(void *)&jarg7; 
    (arg1)->PutMsg(arg2,arg3,arg4,arg5,arg6,arg7);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1PutMsg_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    player_msghdr_t *arg3 = (player_msghdr_t *) 0 ;
    void *arg4 = (void *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = *(player_msghdr_t **)(void *)&jarg3; 
    arg4 = *(void **)(void *)&jarg4; 
    (arg1)->PutMsg(arg2,arg3,arg4);
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1Request_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jshort jarg3, jshort jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jboolean jarg8) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    uint8_t arg3 ;
    uint8_t arg4 ;
    void *arg5 = (void *) 0 ;
    size_t arg6 ;
    double *arg7 = (double *) 0 ;
    bool arg8 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = (uint8_t)jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = *(void **)(void *)&jarg5; 
    arg6 = (size_t)jarg6; 
    arg7 = *(double **)(void *)&jarg7; 
    arg8 = jarg8 ? true : false; 
    result = (Message *)(arg1)->Request(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1Request_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jshort jarg3, jshort jarg4, jlong jarg5, jlong jarg6, jlong jarg7) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    uint8_t arg3 ;
    uint8_t arg4 ;
    void *arg5 = (void *) 0 ;
    size_t arg6 ;
    double *arg7 = (double *) 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = (uint8_t)jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = *(void **)(void *)&jarg5; 
    arg6 = (size_t)jarg6; 
    arg7 = *(double **)(void *)&jarg7; 
    result = (Message *)(arg1)->Request(arg2,arg3,arg4,arg5,arg6,arg7);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1MatchDeviceAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    player_devaddr_t arg1 ;
    player_devaddr_t arg2 ;
    bool result;
    player_devaddr_t *argp1 ;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    argp1 = *(player_devaddr_t **)(void *)&jarg1; 
    if (!argp1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg1 = *argp1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    result = (bool)Device::MatchDeviceAddress(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Device *arg1 = (Device *) 0 ;
    Device *arg2 = (Device *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(Device **)(void *)&jarg2; 
    if (arg1) (arg1)->next = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    Device *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result = (Device *) ((arg1)->next);
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Device *arg1 = (Device *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (arg1) (arg1)->addr = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result = (player_devaddr_t *)& ((arg1)->addr);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1drivername_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    Device *arg1 = (Device *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->drivername,arg2,PLAYER_MAX_DRIVER_STRING_LEN);
        else arg1->drivername[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1drivername_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->drivername);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1driver_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Device *arg1 = (Device *) 0 ;
    Driver *arg2 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(Driver **)(void *)&jarg2; 
    if (arg1) (arg1)->driver = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1driver_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    Driver *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result = (Driver *) ((arg1)->driver);
    
    *(Driver **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1queues_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Device *arg1 = (Device *) 0 ;
    MessageQueue **arg2 = (MessageQueue **) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = *(MessageQueue ***)(void *)&jarg2; 
    if (arg1) (arg1)->queues = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1queues_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    MessageQueue **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result = (MessageQueue **) ((arg1)->queues);
    
    *(MessageQueue ***)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1len_1queues_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Device *arg1 = (Device *) 0 ;
    size_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    arg2 = (size_t)jarg2; 
    if (arg1) (arg1)->len_queues = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Device_1len_1queues_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Device *arg1 = (Device *) 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Device **)(void *)&jarg1; 
    result =  ((arg1)->len_queues);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1DeviceTable(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DeviceTable *result;
    
    (void)jenv;
    (void)jcls;
    result = (DeviceTable *)new DeviceTable();
    
    *(DeviceTable **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1DeviceTable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1AddDevice_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jboolean jarg4) {
    jint jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    player_devaddr_t arg2 ;
    Driver *arg3 = (Driver *) 0 ;
    bool arg4 ;
    int result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    arg3 = *(Driver **)(void *)&jarg3; 
    arg4 = jarg4 ? true : false; 
    result = (int)(arg1)->AddDevice(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1AddDevice_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jint jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    player_devaddr_t arg2 ;
    Driver *arg3 = (Driver *) 0 ;
    int result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    arg3 = *(Driver **)(void *)&jarg3; 
    result = (int)(arg1)->AddDevice(arg2,arg3);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1GetDevice_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
    jlong jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    player_devaddr_t arg2 ;
    bool arg3 ;
    Device *result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    arg3 = jarg3 ? true : false; 
    result = (Device *)(arg1)->GetDevice(arg2,arg3);
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1GetDevice_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    player_devaddr_t arg2 ;
    Device *result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    result = (Device *)(arg1)->GetDevice(arg2);
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1GetFirstDevice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    Device *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    result = (Device *)(arg1)->GetFirstDevice();
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1GetNextDevice(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    Device *arg2 = (Device *) 0 ;
    Device *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    arg2 = *(Device **)(void *)&jarg2; 
    result = (Device *)(arg1)->GetNextDevice(arg2);
    
    *(Device **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1Size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    result = (int)(arg1)->Size();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1UpdateDevices(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    (arg1)->UpdateDevices();
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1StartAlwaysonDrivers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    result = (int)(arg1)->StartAlwaysonDrivers();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DeviceTable_1AddRemoteDriverFn(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    DeviceTable *arg1 = (DeviceTable *) 0 ;
    remote_driver_fn_t arg2 = (remote_driver_fn_t) 0 ;
    void *arg3 = (void *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DeviceTable **)(void *)&jarg1; 
    arg2 = *(remote_driver_fn_t *)(void *)&jarg2; 
    arg3 = *(void **)(void *)&jarg3; 
    (arg1)->AddRemoteDriverFn(arg2,arg3);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1driverthread_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    pthread_t arg2 ;
    pthread_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(pthread_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null pthread_t");
        return ;
    }
    arg2 = *argp2; 
    if (arg1) (arg1)->driverthread = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1driverthread_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    pthread_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result =  ((arg1)->driverthread);
    
    *(pthread_t **)(void *)&jresult = new pthread_t((pthread_t &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Lock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->Lock();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Unlock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->Unlock();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1ret_1queue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    if (arg1) (arg1)->ret_queue = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1ret_1queue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (MessageQueue *) ((arg1)->ret_queue);
    
    *(MessageQueue **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Publish_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jshort jarg4, jshort jarg5, jlong jarg6, jlong jarg7, jlong jarg8) {
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    MessageQueue *arg3 = (MessageQueue *) 0 ;
    uint8_t arg4 ;
    uint8_t arg5 ;
    void *arg6 = (void *) 0 ;
    size_t arg7 ;
    double *arg8 = (double *) 0 ;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return ;
    }
    arg2 = *argp2; 
    arg3 = *(MessageQueue **)(void *)&jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = (uint8_t)jarg5; 
    arg6 = *(void **)(void *)&jarg6; 
    arg7 = (size_t)jarg7; 
    arg8 = *(double **)(void *)&jarg8; 
    (arg1)->Publish(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Publish_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jshort jarg4, jshort jarg5, jlong jarg6, jlong jarg7) {
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    MessageQueue *arg3 = (MessageQueue *) 0 ;
    uint8_t arg4 ;
    uint8_t arg5 ;
    void *arg6 = (void *) 0 ;
    size_t arg7 ;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return ;
    }
    arg2 = *argp2; 
    arg3 = *(MessageQueue **)(void *)&jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = (uint8_t)jarg5; 
    arg6 = *(void **)(void *)&jarg6; 
    arg7 = (size_t)jarg7; 
    (arg1)->Publish(arg2,arg3,arg4,arg5,arg6,arg7);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Publish_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jshort jarg4, jshort jarg5, jlong jarg6) {
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    MessageQueue *arg3 = (MessageQueue *) 0 ;
    uint8_t arg4 ;
    uint8_t arg5 ;
    void *arg6 = (void *) 0 ;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return ;
    }
    arg2 = *argp2; 
    arg3 = *(MessageQueue **)(void *)&jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = (uint8_t)jarg5; 
    arg6 = *(void **)(void *)&jarg6; 
    (arg1)->Publish(arg2,arg3,arg4,arg5,arg6);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Publish_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jshort jarg4, jshort jarg5) {
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    MessageQueue *arg3 = (MessageQueue *) 0 ;
    uint8_t arg4 ;
    uint8_t arg5 ;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return ;
    }
    arg2 = *argp2; 
    arg3 = *(MessageQueue **)(void *)&jarg3; 
    arg4 = (uint8_t)jarg4; 
    arg5 = (uint8_t)jarg5; 
    (arg1)->Publish(arg2,arg3,arg4,arg5);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Publish_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    player_msghdr_t *arg3 = (player_msghdr_t *) 0 ;
    void *arg4 = (void *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = *(player_msghdr_t **)(void *)&jarg3; 
    arg4 = *(void **)(void *)&jarg4; 
    (arg1)->Publish(arg2,arg3,arg4);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1device_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (arg1) (arg1)->device_addr = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1device_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (player_devaddr_t *)& ((arg1)->device_addr);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1subscriptions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->subscriptions = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1subscriptions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (int) ((arg1)->subscriptions);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1entries_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    if (arg1) (arg1)->entries = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1entries_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (int) ((arg1)->entries);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1alwayson_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = jarg2 ? true : false; 
    if (arg1) (arg1)->alwayson = arg2;
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1alwayson_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (bool) ((arg1)->alwayson);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1InQueue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    if (arg1) (arg1)->InQueue = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1InQueue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (MessageQueue *) ((arg1)->InQueue);
    
    *(MessageQueue **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Driver_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3, jlong jarg4, jint jarg5) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    bool arg3 ;
    size_t arg4 ;
    int arg5 ;
    Driver *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = jarg3 ? true : false; 
    arg4 = (size_t)jarg4; 
    arg5 = (int)jarg5; 
    result = (Driver *)new SwigDirector_Driver(jenv,arg1,arg2,arg3,arg4,arg5);
    
    *(Driver **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Driver_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    bool arg3 ;
    size_t arg4 ;
    Driver *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = jarg3 ? true : false; 
    arg4 = (size_t)jarg4; 
    result = (Driver *)new SwigDirector_Driver(jenv,arg1,arg2,arg3,arg4);
    
    *(Driver **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Driver_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    bool arg3 ;
    Driver *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = jarg3 ? true : false; 
    result = (Driver *)new SwigDirector_Driver(jenv,arg1,arg2,arg3);
    
    *(Driver **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Driver_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    ConfigFile *arg1 = (ConfigFile *) 0 ;
    int arg2 ;
    Driver *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(ConfigFile **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (Driver *)new SwigDirector_Driver(jenv,arg1,arg2);
    
    *(Driver **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1Driver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1GetError(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (int)(arg1)->GetError();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Subscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    int result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    result = (int)(arg1)->Subscribe(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Unsubscribe(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    player_devaddr_t arg2 ;
    int result;
    player_devaddr_t *argp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    argp2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (!argp2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg2 = *argp2; 
    result = (int)(arg1)->Unsubscribe(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Setup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (int)(arg1)->Setup();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Shutdown(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    result = (int)(arg1)->Shutdown();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Main(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->Main();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1MainQuit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->MainQuit();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1ProcessMessages_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    Driver *arg1 = (Driver *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    (arg1)->ProcessMessages(arg2);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1ProcessMessages_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->ProcessMessages();
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1ProcessMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jint jresult = 0 ;
    Driver *arg1 = (Driver *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    player_msghdr *arg3 = (player_msghdr *) 0 ;
    void *arg4 = (void *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    arg3 = *(player_msghdr **)(void *)&jarg3; 
    arg4 = *(void **)(void *)&jarg4; 
    result = (int)(arg1)->ProcessMessage(arg2,arg3,arg4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1Update(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Driver *arg1 = (Driver *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Driver **)(void *)&jarg1; 
    (arg1)->Update();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
    Driver *obj = *((Driver **)(void *)&objarg);
    (void)jcls;
    SwigDirector_Driver *director = dynamic_cast<SwigDirector_Driver *>(obj);
    if (director) {
        director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
    }
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Driver_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
    Driver *obj = *((Driver **)(void *)&objarg);
    SwigDirector_Driver *director = dynamic_cast<SwigDirector_Driver *>(obj);
    (void)jcls;
    if (director) {
        director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
    }
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1initfunc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    DriverInitFn arg2 = (DriverInitFn) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    arg2 = *(DriverInitFn *)(void *)&jarg2; 
    if (arg1) (arg1)->initfunc = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1initfunc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    DriverInitFn result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    result = (DriverInitFn) ((arg1)->initfunc);
    
    *(DriverInitFn *)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->name,arg2,PLAYER_MAX_DRIVER_STRING_LEN);
        else arg1->name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    DriverEntry *arg2 = (DriverEntry *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    arg2 = *(DriverEntry **)(void *)&jarg2; 
    if (arg1) (arg1)->next = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverEntry_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    DriverEntry *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    result = (DriverEntry *) ((arg1)->next);
    
    *(DriverEntry **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1DriverEntry(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DriverEntry *result;
    
    (void)jenv;
    (void)jcls;
    result = (DriverEntry *)new DriverEntry();
    
    *(DriverEntry **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1DriverEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DriverEntry *arg1 = (DriverEntry *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverEntry **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1DriverTable(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DriverTable *result;
    
    (void)jenv;
    (void)jcls;
    result = (DriverTable *)new DriverTable();
    
    *(DriverTable **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1DriverTable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    DriverTable *arg1 = (DriverTable *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverTable_1AddDriver(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
    jint jresult = 0 ;
    DriverTable *arg1 = (DriverTable *) 0 ;
    char *arg2 = (char *) 0 ;
    DriverInitFn arg3 = (DriverInitFn) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(DriverInitFn *)(void *)&jarg3; 
    result = (int)(arg1)->AddDriver(arg2,arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverTable_1GetDriverEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    DriverTable *arg1 = (DriverTable *) 0 ;
    char *arg2 = (char *) 0 ;
    DriverEntry *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (DriverEntry *)(arg1)->GetDriverEntry((char const *)arg2);
    
    *(DriverEntry **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverTable_1Size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    DriverTable *arg1 = (DriverTable *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    result = (int)(arg1)->Size();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverTable_1GetDriverName(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    DriverTable *arg1 = (DriverTable *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)(arg1)->GetDriverName(arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_DriverTable_1SortDrivers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    DriverTable *arg1 = (DriverTable *) 0 ;
    char **result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(DriverTable **)(void *)&jarg1; 
    result = (char **)(arg1)->SortDrivers();
    
    *(char ***)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ErrorInit(JNIEnv *jenv, jclass jcls, jint jarg1) {
    int arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    ErrorInit(arg1);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_ErrorPrint(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jstring jarg3, jint jarg4, jstring jarg5) {
    int arg1 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    int arg4 ;
    char *arg5 = (char *) 0 ;
    void *arg6 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    arg2 = (int)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return ;
        }
    }
    arg4 = (int)jarg4; 
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
            if (!arg5) return ;
        }
    }
    ErrorPrint(arg1,arg2,(char const *)arg3,arg4,(char const *)arg5,arg6);
    
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        if (arg5) jenv->ReleaseStringUTFChars(jarg5, arg5); 
    }
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ERR_1ERR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ERR_1WARN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ERR_1MSG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ERR_1DBG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_deviceTable_1get(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DeviceTable *result;
    
    (void)jenv;
    (void)jcls;
    result = (DeviceTable *)deviceTable;
    
    *(DeviceTable **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GlobalTime_1get(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    PlayerTime *result;
    
    (void)jenv;
    (void)jcls;
    result = (PlayerTime *)GlobalTime;
    
    *(PlayerTime **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_driverTable_1get(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    DriverTable *result;
    
    (void)jenv;
    (void)jcls;
    result = (DriverTable *)driverTable;
    
    *(DriverTable **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_playerversion_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *)(char *)playerversion;
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1quit_1get(JNIEnv *jenv, jclass jcls) {
    jboolean jresult = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    result = (bool)player_quit;
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1quiet_1startup_1get(JNIEnv *jenv, jclass jcls) {
    jboolean jresult = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    result = (bool)player_quiet_startup;
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1globals_1init(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    player_globals_init();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1globals_1fini(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    player_globals_fini();
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Message_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
    jlong jresult = 0 ;
    player_msghdr *arg1 = 0 ;
    void *arg2 = (void *) 0 ;
    unsigned int arg3 ;
    MessageQueue *arg4 = (MessageQueue *) 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "player_msghdr const & reference is null");
        return 0;
    } 
    arg2 = *(void **)(void *)&jarg2; 
    arg3 = (unsigned int)jarg3; 
    arg4 = *(MessageQueue **)(void *)&jarg4; 
    result = (Message *)new Message((player_msghdr const &)*arg1,(void const *)arg2,arg3,arg4);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Message_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
    jlong jresult = 0 ;
    player_msghdr *arg1 = 0 ;
    void *arg2 = (void *) 0 ;
    unsigned int arg3 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "player_msghdr const & reference is null");
        return 0;
    } 
    arg2 = *(void **)(void *)&jarg2; 
    arg3 = (unsigned int)jarg3; 
    result = (Message *)new Message((player_msghdr const &)*arg1,(void const *)arg2,arg3);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1Message_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1;
    if(!arg1) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Message const & reference is null");
        return 0;
    } 
    result = (Message *)new Message((Message const &)*arg1);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1Message(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Message *arg1 = (Message *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1MatchMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jlong jarg4) {
    jboolean jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    int arg2 ;
    int arg3 ;
    player_devaddr_t arg4 ;
    bool result;
    player_devaddr_t *argp4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    argp4 = *(player_devaddr_t **)(void *)&jarg4; 
    if (!argp4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null player_devaddr_t");
        return 0;
    }
    arg4 = *argp4; 
    result = (bool)Message::MatchMessage(arg1,arg2,arg3,arg4);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1GetData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (void *)(arg1)->GetData();
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1GetHeader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    player_msghdr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (player_msghdr_t *)(arg1)->GetHeader();
    
    *(player_msghdr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1GetPayload(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (void *)(arg1)->GetPayload();
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1GetPayloadSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (arg1)->GetPayloadSize();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (unsigned int)(arg1)->GetSize();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1Compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    Message *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    arg2 = *(Message **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Message & reference is null");
        return 0;
    } 
    result = (bool)(arg1)->Compare(*arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1DecRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Message *arg1 = (Message *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    (arg1)->DecRef();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1SetReady(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    Message *arg1 = (Message *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    (arg1)->SetReady();
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1Ready(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (bool)((Message const *)arg1)->Ready();
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1Queue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Message *arg1 = (Message *) 0 ;
    MessageQueue *arg2 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    arg2 = *(MessageQueue **)(void *)&jarg2; 
    if (arg1) (arg1)->Queue = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1Queue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    MessageQueue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (MessageQueue *) ((arg1)->Queue);
    
    *(MessageQueue **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1RefCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    Message *arg1 = (Message *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    arg2 = *(unsigned int **)(void *)&jarg2; 
    if (arg1) (arg1)->RefCount = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_Message_1RefCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    Message *arg1 = (Message *) 0 ;
    unsigned int *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(Message **)(void *)&jarg1; 
    result = (unsigned int *) ((arg1)->RefCount);
    
    *(unsigned int **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1MessageQueueElement(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    MessageQueueElement *result;
    
    (void)jenv;
    (void)jcls;
    result = (MessageQueueElement *)new MessageQueueElement();
    
    *(MessageQueueElement **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1MessageQueueElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueueElement *arg1 = (MessageQueueElement *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueueElement **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueueElement_1msg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    MessageQueueElement *arg1 = (MessageQueueElement *) 0 ;
    Message *arg2 = (Message *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueueElement **)(void *)&jarg1; 
    arg2 = *(Message **)(void *)&jarg2; 
    if (arg1) (arg1)->msg = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueueElement_1msg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    MessageQueueElement *arg1 = (MessageQueueElement *) 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueueElement **)(void *)&jarg1; 
    result = (Message *) ((arg1)->msg);
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1MessageReplaceRule(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jboolean jarg7) {
    jlong jresult = 0 ;
    int arg1 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    bool arg7 ;
    MessageReplaceRule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = (int)jarg6; 
    arg7 = jarg7 ? true : false; 
    result = (MessageReplaceRule *)new MessageReplaceRule(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    *(MessageReplaceRule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1Match(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    player_msghdr_t *arg2 = (player_msghdr_t *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    arg2 = *(player_msghdr_t **)(void *)&jarg2; 
    result = (bool)(arg1)->Match(arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1Equivalent(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7) {
    jboolean jresult = 0 ;
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    int arg7 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = (int)jarg6; 
    arg7 = (int)jarg7; 
    result = (bool)(arg1)->Equivalent(arg2,arg3,arg4,arg5,arg6,arg7);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1replace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    arg2 = jarg2 ? true : false; 
    if (arg1) (arg1)->replace = arg2;
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1replace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    result = (bool) ((arg1)->replace);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1next_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    MessageReplaceRule *arg2 = (MessageReplaceRule *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    arg2 = *(MessageReplaceRule **)(void *)&jarg2; 
    if (arg1) (arg1)->next = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageReplaceRule_1next_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    MessageReplaceRule *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    result = (MessageReplaceRule *) ((arg1)->next);
    
    *(MessageReplaceRule **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1MessageReplaceRule(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageReplaceRule *arg1 = (MessageReplaceRule *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageReplaceRule **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1MessageQueue(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    bool arg1 ;
    size_t arg2 ;
    MessageQueue *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = jarg1 ? true : false; 
    arg2 = (size_t)jarg2; 
    result = (MessageQueue *)new MessageQueue(arg1,arg2);
    
    *(MessageQueue **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1MessageQueue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Empty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    result = (bool)(arg1)->Empty();
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Push_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
    jlong jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    Message *arg2 = 0 ;
    bool arg3 ;
    MessageQueueElement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = *(Message **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Message & reference is null");
        return 0;
    } 
    arg3 = jarg3 ? true : false; 
    result = (MessageQueueElement *)(arg1)->Push(*arg2,arg3);
    
    *(MessageQueueElement **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Push_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    Message *arg2 = 0 ;
    MessageQueueElement *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = *(Message **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Message & reference is null");
        return 0;
    } 
    result = (MessageQueueElement *)(arg1)->Push(*arg2);
    
    *(MessageQueueElement **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Pop(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    result = (Message *)(arg1)->Pop();
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1PopReady(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    Message *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    result = (Message *)(arg1)->PopReady();
    
    *(Message **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1SetReplace(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = jarg2 ? true : false; 
    (arg1)->SetReplace(arg2);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1AddReplaceRule_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jboolean jarg8) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    int arg7 ;
    bool arg8 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = (int)jarg6; 
    arg7 = (int)jarg7; 
    arg8 = jarg8 ? true : false; 
    (arg1)->AddReplaceRule(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1AddReplaceRule_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    player_devaddr_t *arg2 = 0 ;
    int arg3 ;
    int arg4 ;
    bool arg5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "player_devaddr_t const & reference is null");
        return ;
    } 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = jarg5 ? true : false; 
    (arg1)->AddReplaceRule((player_devaddr const &)*arg2,arg3,arg4,arg5);
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1CheckReplace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    player_msghdr_t *arg2 = (player_msghdr_t *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = *(player_msghdr_t **)(void *)&jarg2; 
    result = (bool)(arg1)->CheckReplace(arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Wait(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    (arg1)->Wait();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1DataAvailable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    (arg1)->DataAvailable();
    
}


JNIEXPORT jboolean JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1Filter(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    Message *arg2 = 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = *(Message **)(void *)&jarg2;
    if(!arg2) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Message & reference is null");
        return 0;
    } 
    result = (bool)(arg1)->Filter(*arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1ClearFilter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    (arg1)->ClearFilter();
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1SetFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    int arg6 ;
    int arg7 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (int)jarg3; 
    arg4 = (int)jarg4; 
    arg5 = (int)jarg5; 
    arg6 = (int)jarg6; 
    arg7 = (int)jarg7; 
    (arg1)->SetFilter(arg2,arg3,arg4,arg5,arg6,arg7);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1SetPull(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    bool arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    arg2 = jarg2 ? true : false; 
    (arg1)->SetPull(arg2);
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1MarkAllReady(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    (arg1)->MarkAllReady();
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MessageQueue_1GetLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    MessageQueue *arg1 = (MessageQueue *) 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(MessageQueue **)(void *)&jarg1; 
    result = (arg1)->GetLength();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAX_1MESSAGE_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8388608;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAX_1DRIVER_1STRING_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAX_1DEVICES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGQUEUE_1DEFAULT_1MAXLEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IDENT_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "Player v.";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IDENT_1STRLEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1KEYLEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1RESP_1ACK_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1SYNCH_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MSGTYPE_1RESP_1NACK_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1NULL_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRIPPER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIO_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 12;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GPS_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 13;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 14;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 15;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DIO_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 20;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 21;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 22;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 23;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WAVEFORM_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 24;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 25;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 26;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SOUND_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 27;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 28;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 29;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 30;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 31;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 33;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1NOMAD_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 34;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 40;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 42;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 44;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 45;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ENERGY_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 46;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1JOYSTICK_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 49;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1RECOGNITION_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 50;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 51;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 52;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 53;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 54;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 55;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 56;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 57;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS3D_1CODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 58;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "actarray";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "aio";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIO_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "audio";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "audiodsp";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "audiomixer";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "blinkenlight";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "blobfinder";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "bumper";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "camera";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ENERGY_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "energy";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DIO_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "dio";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRIPPER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "gripper";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "fiducial";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GPS_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "gps";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "ir";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1JOYSTICK_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "joystick";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "laser";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "limb";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "localize";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "log";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "map";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "mcom";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1NOMAD_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "nomad";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1NULL_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "null";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "opaque";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "planner";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "player";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "position1d";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "position2d";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "position3d";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "power";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "ptz";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "rfid";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "simulation";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "sonar";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SOUND_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "sound";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "speech";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1RECOGNITION_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "speech_recognition";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "truth";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WAVEFORM_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "waveform";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "wifi";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "graphics2d";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS3D_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "graphics3d";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "wsn";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1host_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->host = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1host_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->host);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1robot_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->robot = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1robot_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->robot);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1interf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->interf = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1interf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->interf);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->index = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->index);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1devaddr_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_devaddr_t *)new player_devaddr_t();
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1devaddr_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (arg1) (arg1)->addr = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (player_devaddr_t *)& ((arg1)->addr);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->type);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1subtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->subtype = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1subtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->subtype);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1timestamp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->timestamp = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1timestamp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (double) ((arg1)->timestamp);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1seq_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->seq = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1seq_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->seq);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->size = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->size);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1msghdr_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_msghdr_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_msghdr_t *)new player_msghdr_t();
    
    *(player_msghdr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1msghdr_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1px_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->px = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1px_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->px);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1py_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->py = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1py_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->py);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1point_12d_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_point_2d_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_point_2d_t *)new player_point_2d_t();
    
    *(player_point_2d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1point_12d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1px_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->px = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1px_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->px);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1py_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->py = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1py_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->py);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1pz_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pz = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1pz_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pz);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1point_13d_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_point_3d_t *)new player_point_3d_t();
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1point_13d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1px_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->px = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1px_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    result = (float) ((arg1)->px);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1py_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->py = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1py_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    result = (float) ((arg1)->py);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1pa_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pa = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1pa_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pa);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1pose_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_pose_t *)new player_pose_t();
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1pose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1px_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->px = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1px_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->px);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1py_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->py = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1py_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->py);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1pz_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pz = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1pz_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pz);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1proll_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->proll = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1proll_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->proll);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1ppitch_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ppitch = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1ppitch_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ppitch);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1pyaw_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pyaw = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1pyaw_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pyaw);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1pose3d_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_pose3d_t *)new player_pose3d_t();
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1pose3d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1sw_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->sw = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1sw_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    result = (float) ((arg1)->sw);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1sl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->sl = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1sl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    result = (float) ((arg1)->sl);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bbox_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bbox_t *)new player_bbox_t();
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bbox_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sw_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->sw = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sw_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->sw);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->sl = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->sl);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sh_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->sh = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sh_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    result = (float) ((arg1)->sh);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bbox3d_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bbox3d_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bbox3d_t *)new player_bbox3d_t();
    
    *(player_bbox3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bbox3d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1x0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->x0 = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1x0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    result = (float) ((arg1)->x0);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1y0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->y0 = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1y0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    result = (float) ((arg1)->y0);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1x1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->x1 = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1x1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    result = (float) ((arg1)->x1);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1y1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->y1 = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1y1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    result = (float) ((arg1)->y1);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1segment_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_segment_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_segment_t *)new player_segment_t();
    
    *(player_segment_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1segment_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1alpha_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->alpha = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1alpha_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->alpha);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1red_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->red = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1red_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->red);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1green_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->green = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1green_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->green);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1blue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->blue = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1blue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_color_t *arg1 = (player_color_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->blue);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1color_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_color_t *)new player_color_t();
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1color_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_color_t *arg1 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bool_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_bool_t *arg1 = (player_bool_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bool_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bool_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_bool_t *arg1 = (player_bool_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bool_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bool_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bool_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bool_t *)new player_bool_t();
    
    *(player_bool_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bool_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bool_t *arg1 = (player_bool_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bool_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1NUM_1ACTUATORS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1ACTSTATE_1IDLE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1ACTSTATE_1MOVING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1ACTSTATE_1BRAKED_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1ACTSTATE_1STALLED_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1TYPE_1LINEAR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1TYPE_1ROTARY_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1POWER_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1BRAKES_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1GET_1GEOM_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1SPEED_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1POS_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1SPEED_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1HOME_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ACTARRAY_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->position = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    result = (float) ((arg1)->position);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuator_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1actuator_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_actuator_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_actuator_t *)new player_actarray_actuator_t();
    
    *(player_actarray_actuator_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1actuator_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_actuator_t *arg1 = (player_actarray_actuator_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuator_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1data_1t_1actuators_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_actarray_data_t *arg1 = (player_actarray_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->actuators_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1data_1t_1actuators_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_actarray_data_t *arg1 = (player_actarray_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->actuators_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1data_1t_1actuators_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_actarray_data_t *arg1 = (player_actarray_data_t *) 0 ;
    player_actarray_actuator_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 16) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_actarray_actuator_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_actarray_actuator_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_actarray_actuator_t *b = (player_actarray_actuator_t *) arg1->actuators;
        for (ii = 0; ii < (size_t)16; ii++) b[ii] = *((player_actarray_actuator_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_actarray_actuator_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1data_1t_1actuators_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_actarray_data_t *arg1 = (player_actarray_data_t *) 0 ;
    player_actarray_actuator_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_data_t **)(void *)&jarg1; 
    result = (player_actarray_actuator_t *)(player_actarray_actuator_t *) ((arg1)->actuators);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(16);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<16; i++) {
            arr[i] = 0;
            *(player_actarray_actuator_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_data_t *)new player_actarray_data_t();
    
    *(player_actarray_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_data_t *arg1 = (player_actarray_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->type);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1min_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->min = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1min_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (float) ((arg1)->min);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1centre_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->centre = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1centre_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (float) ((arg1)->centre);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1max_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1max_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1home_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->home = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1home_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (float) ((arg1)->home);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1config_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->config_speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1config_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (float) ((arg1)->config_speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1hasbrakes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->hasbrakes = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1actuatorgeom_1t_1hasbrakes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->hasbrakes);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1actuatorgeom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_actuatorgeom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_actuatorgeom_t *)new player_actarray_actuatorgeom_t();
    
    *(player_actarray_actuatorgeom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1actuatorgeom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_actuatorgeom_t *arg1 = (player_actarray_actuatorgeom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_actuatorgeom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1geom_1t_1actuators_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_actarray_geom_t *arg1 = (player_actarray_geom_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_geom_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->actuators_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1geom_1t_1actuators_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_actarray_geom_t *arg1 = (player_actarray_geom_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_geom_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->actuators_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1geom_1t_1actuators_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_actarray_geom_t *arg1 = (player_actarray_geom_t *) 0 ;
    player_actarray_actuatorgeom_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_geom_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 16) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_actarray_actuatorgeom_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_actarray_actuatorgeom_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_actarray_actuatorgeom_t *b = (player_actarray_actuatorgeom_t *) arg1->actuators;
        for (ii = 0; ii < (size_t)16; ii++) b[ii] = *((player_actarray_actuatorgeom_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_actarray_actuatorgeom_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1geom_1t_1actuators_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_actarray_geom_t *arg1 = (player_actarray_geom_t *) 0 ;
    player_actarray_actuatorgeom_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_geom_t **)(void *)&jarg1; 
    result = (player_actarray_actuatorgeom_t *)(player_actarray_actuatorgeom_t *) ((arg1)->actuators);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(16);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<16; i++) {
            arr[i] = 0;
            *(player_actarray_actuatorgeom_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_geom_t *)new player_actarray_geom_t();
    
    *(player_actarray_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_geom_t *arg1 = (player_actarray_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1position_1cmd_1t_1joint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_actarray_position_cmd_t *arg1 = (player_actarray_position_cmd_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_position_cmd_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->joint = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1position_1cmd_1t_1joint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_actarray_position_cmd_t *arg1 = (player_actarray_position_cmd_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_position_cmd_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->joint);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1position_1cmd_1t_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_position_cmd_t *arg1 = (player_actarray_position_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_position_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->position = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1position_1cmd_1t_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_position_cmd_t *arg1 = (player_actarray_position_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_position_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->position);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1position_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_position_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_position_cmd_t *)new player_actarray_position_cmd_t();
    
    *(player_actarray_position_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1position_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_position_cmd_t *arg1 = (player_actarray_position_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_position_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1cmd_1t_1joint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_actarray_speed_cmd_t *arg1 = (player_actarray_speed_cmd_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_cmd_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->joint = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1cmd_1t_1joint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_actarray_speed_cmd_t *arg1 = (player_actarray_speed_cmd_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_cmd_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->joint);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1cmd_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_speed_cmd_t *arg1 = (player_actarray_speed_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1cmd_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_speed_cmd_t *arg1 = (player_actarray_speed_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1speed_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_speed_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_speed_cmd_t *)new player_actarray_speed_cmd_t();
    
    *(player_actarray_speed_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1speed_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_speed_cmd_t *arg1 = (player_actarray_speed_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1home_1cmd_1t_1joint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_actarray_home_cmd_t *arg1 = (player_actarray_home_cmd_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_home_cmd_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->joint = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1home_1cmd_1t_1joint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_actarray_home_cmd_t *arg1 = (player_actarray_home_cmd_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_home_cmd_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->joint);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1home_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_home_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_home_cmd_t *)new player_actarray_home_cmd_t();
    
    *(player_actarray_home_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1home_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_home_cmd_t *arg1 = (player_actarray_home_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_home_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1power_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_actarray_power_config_t *arg1 = (player_actarray_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1power_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_actarray_power_config_t *arg1 = (player_actarray_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_power_config_t *)new player_actarray_power_config_t();
    
    *(player_actarray_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_power_config_t *arg1 = (player_actarray_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1brakes_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_actarray_brakes_config_t *arg1 = (player_actarray_brakes_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_brakes_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1brakes_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_actarray_brakes_config_t *arg1 = (player_actarray_brakes_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_brakes_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1brakes_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_brakes_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_brakes_config_t *)new player_actarray_brakes_config_t();
    
    *(player_actarray_brakes_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1brakes_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_brakes_config_t *arg1 = (player_actarray_brakes_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_brakes_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1config_1t_1joint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_actarray_speed_config_t *arg1 = (player_actarray_speed_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->joint = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1config_1t_1joint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_actarray_speed_config_t *arg1 = (player_actarray_speed_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->joint);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1config_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_actarray_speed_config_t *arg1 = (player_actarray_speed_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1actarray_1speed_1config_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_actarray_speed_config_t *arg1 = (player_actarray_speed_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1actarray_1speed_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_actarray_speed_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_actarray_speed_config_t *)new player_actarray_speed_config_t();
    
    *(player_actarray_speed_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1actarray_1speed_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_actarray_speed_config_t *arg1 = (player_actarray_speed_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_actarray_speed_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1MAX_1INPUTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1MAX_1OUTPUTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1CMD_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AIO_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1data_1t_1voltages_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_aio_data_t *arg1 = (player_aio_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->voltages_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1data_1t_1voltages_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_aio_data_t *arg1 = (player_aio_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->voltages_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1data_1t_1voltages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_aio_data_t *arg1 = (player_aio_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 8) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->voltages;
        for (ii = 0; ii < (size_t)8; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1data_1t_1voltages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_aio_data_t *arg1 = (player_aio_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->voltages);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 8); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1aio_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_aio_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_aio_data_t *)new player_aio_data_t();
    
    *(player_aio_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1aio_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_aio_data_t *arg1 = (player_aio_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1cmd_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_aio_cmd_t *arg1 = (player_aio_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1cmd_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_aio_cmd_t *arg1 = (player_aio_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1cmd_1t_1voltage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_aio_cmd_t *arg1 = (player_aio_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->voltage = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1aio_1cmd_1t_1voltage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_aio_cmd_t *arg1 = (player_aio_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->voltage);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1aio_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_aio_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_aio_cmd_t *)new player_aio_cmd_t();
    
    *(player_aio_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1aio_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_aio_cmd_t *arg1 = (player_aio_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_aio_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIO_1DATA_1BUFFER_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 20;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIO_1PAIRS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1frequency_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->frequency_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1frequency_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->frequency_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->frequency;
        for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->frequency);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 5); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1amplitude_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->amplitude_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1amplitude_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->amplitude_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1amplitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 5) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->amplitude;
        for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1data_1t_1amplitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->amplitude);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 5); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audio_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audio_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audio_data_t *)new player_audio_data_t();
    
    *(player_audio_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audio_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audio_data_t *arg1 = (player_audio_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->frequency = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->frequency);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1amplitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->amplitude = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1amplitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->amplitude);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1duration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->duration = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audio_1cmd_1t_1duration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->duration);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audio_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audio_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audio_cmd_t *)new player_audio_cmd_t();
    
    *(player_audio_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audio_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audio_cmd_t *arg1 = (player_audio_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audio_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1MAX_1FREQS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1MAX_1BITSTRING_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1SET_1CONFIG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1GET_1CONFIG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1PLAY_1TONE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1PLAY_1CHIRP_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1REPLAY_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIODSP_1DATA_1TONES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1frequency_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->frequency_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1frequency_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->frequency_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 8) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->frequency;
        for (ii = 0; ii < (size_t)8; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->frequency);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 8); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1amplitude_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->amplitude_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1amplitude_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->amplitude_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1amplitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 8) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->amplitude;
        for (ii = 0; ii < (size_t)8; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1data_1t_1amplitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->amplitude);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 8); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audiodsp_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audiodsp_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audiodsp_data_t *)new player_audiodsp_data_t();
    
    *(player_audiodsp_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audiodsp_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audiodsp_data_t *arg1 = (player_audiodsp_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->frequency = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->frequency);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1amplitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->amplitude = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1amplitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->amplitude);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1duration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->duration = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1duration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->duration);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1bit_1string_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bit_string_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1bit_1string_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bit_string_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1bit_1string_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 64) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->bit_string;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1cmd_1t_1bit_1string_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->bit_string);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 64); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audiodsp_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audiodsp_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audiodsp_cmd_t *)new player_audiodsp_cmd_t();
    
    *(player_audiodsp_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audiodsp_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audiodsp_cmd_t *arg1 = (player_audiodsp_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->format = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->format);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->frequency = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->frequency);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1channels_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->channels = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiodsp_1config_1t_1channels_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->channels);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audiodsp_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audiodsp_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audiodsp_config_t *)new player_audiodsp_config_t();
    
    *(player_audiodsp_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audiodsp_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audiodsp_config_t *arg1 = (player_audiodsp_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiodsp_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1MASTER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1PCM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1LINE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1MIC_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1IGAIN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1SET_1OGAIN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1AUDIOMIXER_1GET_1LEVELS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1cmd_1t_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_cmd_t *arg1 = (player_audiomixer_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1cmd_1t_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_cmd_t *arg1 = (player_audiomixer_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1cmd_1t_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_cmd_t *arg1 = (player_audiomixer_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1cmd_1t_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_cmd_t *arg1 = (player_audiomixer_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audiomixer_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audiomixer_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audiomixer_cmd_t *)new player_audiomixer_cmd_t();
    
    *(player_audiomixer_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audiomixer_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audiomixer_cmd_t *arg1 = (player_audiomixer_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1master_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->master_left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1master_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->master_left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1master_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->master_right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1master_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->master_right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1pcm_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->pcm_left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1pcm_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->pcm_left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1pcm_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->pcm_right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1pcm_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->pcm_right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1line_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->line_left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1line_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->line_left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1line_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->line_right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1line_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->line_right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1mic_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mic_left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1mic_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mic_left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1mic_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mic_right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1mic_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mic_right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1i_1gain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->i_gain = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1i_1gain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->i_gain);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1o_1gain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->o_gain = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1audiomixer_1config_1t_1o_1gain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->o_gain);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1audiomixer_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_audiomixer_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_audiomixer_config_t *)new player_audiomixer_config_t();
    
    *(player_audiomixer_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1audiomixer_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_audiomixer_config_t *arg1 = (player_audiomixer_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_audiomixer_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CMD_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CMD_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CMD_1COLOR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CMD_1PERIOD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLINKENLIGHT_1CMD_1DUTYCYCLE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1enable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1enable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1period_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->period = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1period_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->period);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1dutycycle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->dutycycle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1dutycycle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->dutycycle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1data_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_data_t *)new player_blinkenlight_data_t();
    
    *(player_blinkenlight_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_data_t *arg1 = (player_blinkenlight_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1enable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1enable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1period_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->period = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1period_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->period);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1dutycycle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->dutycycle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1dutycycle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->dutycycle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_cmd_t *)new player_blinkenlight_cmd_t();
    
    *(player_blinkenlight_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_cmd_t *arg1 = (player_blinkenlight_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1power_1t_1enable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_blinkenlight_cmd_power_t *arg1 = (player_blinkenlight_cmd_power_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_power_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1power_1t_1enable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_blinkenlight_cmd_power_t *arg1 = (player_blinkenlight_cmd_power_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_power_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1cmd_1power_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_power_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_cmd_power_t *)new player_blinkenlight_cmd_power_t();
    
    *(player_blinkenlight_cmd_power_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1cmd_1power_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_cmd_power_t *arg1 = (player_blinkenlight_cmd_power_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_power_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1color_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blinkenlight_cmd_color_t *arg1 = (player_blinkenlight_cmd_color_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_color_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1color_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_color_t *arg1 = (player_blinkenlight_cmd_color_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_color_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1cmd_1color_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_color_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_cmd_color_t *)new player_blinkenlight_cmd_color_t();
    
    *(player_blinkenlight_cmd_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1cmd_1color_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_cmd_color_t *arg1 = (player_blinkenlight_cmd_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_color_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1period_1t_1period_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_cmd_period_t *arg1 = (player_blinkenlight_cmd_period_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_period_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->period = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1period_1t_1period_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_cmd_period_t *arg1 = (player_blinkenlight_cmd_period_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_period_t **)(void *)&jarg1; 
    result = (float) ((arg1)->period);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1cmd_1period_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_period_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_cmd_period_t *)new player_blinkenlight_cmd_period_t();
    
    *(player_blinkenlight_cmd_period_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1cmd_1period_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_cmd_period_t *arg1 = (player_blinkenlight_cmd_period_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_period_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1dutycycle_1t_1dutycycle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blinkenlight_cmd_dutycycle_t *arg1 = (player_blinkenlight_cmd_dutycycle_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_dutycycle_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->dutycycle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blinkenlight_1cmd_1dutycycle_1t_1dutycycle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blinkenlight_cmd_dutycycle_t *arg1 = (player_blinkenlight_cmd_dutycycle_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_dutycycle_t **)(void *)&jarg1; 
    result = (float) ((arg1)->dutycycle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blinkenlight_1cmd_1dutycycle_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blinkenlight_cmd_dutycycle_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blinkenlight_cmd_dutycycle_t *)new player_blinkenlight_cmd_dutycycle_t();
    
    *(player_blinkenlight_cmd_dutycycle_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blinkenlight_1cmd_1dutycycle_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blinkenlight_cmd_dutycycle_t *arg1 = (player_blinkenlight_cmd_dutycycle_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blinkenlight_cmd_dutycycle_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1MAX_1BLOBS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1DATA_1BLOBS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1REQ_1SET_1COLOR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BLOBFINDER_1REQ_1SET_1IMAGER_1PARAMS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->color = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->color);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1area_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->area = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1area_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->area);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->x = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->x);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->y = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->y);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1left_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->left = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1left_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->left);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1right_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->right = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1right_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->right);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1top_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->top = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1top_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->top);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1bottom_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bottom = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1bottom_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bottom);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->range = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1blob_1t_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    result = (float) ((arg1)->range);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blobfinder_1blob_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blobfinder_blob_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blobfinder_blob_t *)new player_blobfinder_blob_t();
    
    *(player_blobfinder_blob_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blobfinder_1blob_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blobfinder_blob_t *arg1 = (player_blobfinder_blob_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_blob_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->width);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1height_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1height_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->height);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1blobs_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->blobs_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1blobs_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->blobs_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1blobs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    player_blobfinder_blob_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 256) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_blobfinder_blob_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_blobfinder_blob_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_blobfinder_blob_t *b = (player_blobfinder_blob_t *) arg1->blobs;
        for (ii = 0; ii < (size_t)256; ii++) b[ii] = *((player_blobfinder_blob_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_blobfinder_blob_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1data_1t_1blobs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    player_blobfinder_blob_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    result = (player_blobfinder_blob_t *)(player_blobfinder_blob_t *) ((arg1)->blobs);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(256);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<256; i++) {
            arr[i] = 0;
            *(player_blobfinder_blob_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blobfinder_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blobfinder_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blobfinder_data_t *)new player_blobfinder_data_t();
    
    *(player_blobfinder_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blobfinder_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blobfinder_data_t *arg1 = (player_blobfinder_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1rmin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->rmin = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1rmin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->rmin);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1rmax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->rmax = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1rmax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->rmax);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1gmin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->gmin = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1gmin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->gmin);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1gmax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->gmax = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1gmax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->gmax);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1bmin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bmin = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1bmin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bmin);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1bmax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bmax = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1color_1config_1t_1bmax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bmax);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blobfinder_1color_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blobfinder_color_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blobfinder_color_config_t *)new player_blobfinder_color_config_t();
    
    *(player_blobfinder_color_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blobfinder_1color_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blobfinder_color_config_t *arg1 = (player_blobfinder_color_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_color_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1brightness_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->brightness = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1brightness_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->brightness);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1contrast_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->contrast = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1contrast_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->contrast);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1colormode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->colormode = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1colormode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->colormode);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1autogain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->autogain = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1blobfinder_1imager_1config_1t_1autogain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->autogain);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1blobfinder_1imager_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_blobfinder_imager_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_blobfinder_imager_config_t *)new player_blobfinder_imager_config_t();
    
    *(player_blobfinder_imager_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1blobfinder_1imager_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_blobfinder_imager_config_t *arg1 = (player_blobfinder_imager_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_blobfinder_imager_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1MAX_1SAMPLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1BUMPER_1DATA_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1data_1t_1bumpers_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_bumper_data_t *arg1 = (player_bumper_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bumpers_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1data_1t_1bumpers_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bumper_data_t *arg1 = (player_bumper_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bumpers_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1data_1t_1bumpers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_bumper_data_t *arg1 = (player_bumper_data_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->bumpers;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1data_1t_1bumpers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_bumper_data_t *arg1 = (player_bumper_data_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_data_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->bumpers);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bumper_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bumper_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bumper_data_t *)new player_bumper_data_t();
    
    *(player_bumper_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bumper_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bumper_data_t *arg1 = (player_bumper_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1length_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->length = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1length_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    result = (float) ((arg1)->length);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1radius_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->radius = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1define_1t_1radius_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    result = (float) ((arg1)->radius);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bumper_1define_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bumper_define_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bumper_define_t *)new player_bumper_define_t();
    
    *(player_bumper_define_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bumper_1define_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bumper_define_t *arg1 = (player_bumper_define_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_define_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1geom_1t_1bumper_1def_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_bumper_geom_t *arg1 = (player_bumper_geom_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_geom_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bumper_def_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1geom_1t_1bumper_1def_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bumper_geom_t *arg1 = (player_bumper_geom_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_geom_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bumper_def_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1geom_1t_1bumper_1def_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_bumper_geom_t *arg1 = (player_bumper_geom_t *) 0 ;
    player_bumper_define_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_geom_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 32) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_bumper_define_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_bumper_define_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_bumper_define_t *b = (player_bumper_define_t *) arg1->bumper_def;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((player_bumper_define_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_bumper_define_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bumper_1geom_1t_1bumper_1def_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_bumper_geom_t *arg1 = (player_bumper_geom_t *) 0 ;
    player_bumper_define_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_geom_t **)(void *)&jarg1; 
    result = (player_bumper_define_t *)(player_bumper_define_t *) ((arg1)->bumper_def);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(32);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<32; i++) {
            arr[i] = 0;
            *(player_bumper_define_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1bumper_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_bumper_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_bumper_geom_t *)new player_bumper_geom_t();
    
    *(player_bumper_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1bumper_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_bumper_geom_t *arg1 = (player_bumper_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bumper_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1IMAGE_1WIDTH_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1920;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1IMAGE_1HEIGHT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1080;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1IMAGE_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) (1920*1080*4);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1FORMAT_1MONO8_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1FORMAT_1MONO16_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1FORMAT_1RGB565_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1FORMAT_1RGB888_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1COMPRESS_1RAW_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CAMERA_1COMPRESS_1JPEG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->width);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1height_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1height_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->height);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1bpp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bpp = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1bpp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bpp);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->format = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->format);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1fdiv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->fdiv = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1fdiv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->fdiv);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1compression_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->compression = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1compression_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->compression);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1image_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->image_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1image_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->image_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1image_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != (1920*1080*4)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->image;
        for (ii = 0; ii < (size_t)(1920*1080*4); ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1camera_1data_1t_1image_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->image);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, (1920*1080*4)); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1camera_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_camera_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_camera_data_t *)new player_camera_data_t();
    
    *(player_camera_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1camera_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_camera_data_t *arg1 = (player_camera_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_camera_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DIO_1DATA_1VALUES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DIO_1CMD_1VALUES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1data_1t_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_dio_data_t *arg1 = (player_dio_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1data_1t_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_dio_data_t *arg1 = (player_dio_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1data_1t_1digin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_dio_data_t *arg1 = (player_dio_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->digin = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1data_1t_1digin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_dio_data_t *arg1 = (player_dio_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->digin);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1dio_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_dio_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_dio_data_t *)new player_dio_data_t();
    
    *(player_dio_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1dio_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_dio_data_t *arg1 = (player_dio_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1cmd_1t_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_dio_cmd_t *arg1 = (player_dio_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1cmd_1t_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_dio_cmd_t *arg1 = (player_dio_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1cmd_1t_1digout_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_dio_cmd_t *arg1 = (player_dio_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->digout = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1dio_1cmd_1t_1digout_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_dio_cmd_t *arg1 = (player_dio_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->digout);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1dio_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_dio_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_dio_cmd_t *)new player_dio_cmd_t();
    
    *(player_dio_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1dio_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_dio_cmd_t *arg1 = (player_dio_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_dio_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ENERGY_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ENERGY_1SET_1CHARGING_1POLICY_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1joules_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->joules = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1joules_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->joules);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1watts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->watts = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1watts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->watts);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1charging_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->charging = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1data_1t_1charging_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->charging);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1energy_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_energy_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_energy_data_t *)new player_energy_data_t();
    
    *(player_energy_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1energy_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_energy_data_t *arg1 = (player_energy_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1chargepolicy_1config_1t_1enable_1input_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_energy_chargepolicy_config_t *arg1 = (player_energy_chargepolicy_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_chargepolicy_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable_input = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1chargepolicy_1config_1t_1enable_1input_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_energy_chargepolicy_config_t *arg1 = (player_energy_chargepolicy_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_chargepolicy_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable_input);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1chargepolicy_1config_1t_1enable_1output_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_energy_chargepolicy_config_t *arg1 = (player_energy_chargepolicy_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_chargepolicy_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable_output = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1energy_1chargepolicy_1config_1t_1enable_1output_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_energy_chargepolicy_config_t *arg1 = (player_energy_chargepolicy_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_chargepolicy_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable_output);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1energy_1chargepolicy_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_energy_chargepolicy_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_energy_chargepolicy_config_t *)new player_energy_chargepolicy_config_t();
    
    *(player_energy_chargepolicy_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1energy_1chargepolicy_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_energy_chargepolicy_config_t *arg1 = (player_energy_chargepolicy_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_energy_chargepolicy_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1MAX_1SAMPLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1DATA_1SCAN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1REQ_1GET_1FOV_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1REQ_1SET_1FOV_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1REQ_1GET_1ID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1FIDUCIAL_1REQ_1SET_1ID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pose);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1upose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->upose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1item_1t_1upose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->upose);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1fiducial_1item_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_fiducial_item_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_fiducial_item_t *)new player_fiducial_item_t();
    
    *(player_fiducial_item_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1fiducial_1item_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_fiducial_item_t *arg1 = (player_fiducial_item_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_item_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1data_1t_1fiducials_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_data_t *arg1 = (player_fiducial_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->fiducials_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1data_1t_1fiducials_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_data_t *arg1 = (player_fiducial_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->fiducials_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1data_1t_1fiducials_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_fiducial_data_t *arg1 = (player_fiducial_data_t *) 0 ;
    player_fiducial_item_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 32) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_fiducial_item_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_fiducial_item_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_fiducial_item_t *b = (player_fiducial_item_t *) arg1->fiducials;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((player_fiducial_item_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_fiducial_item_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1data_1t_1fiducials_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_fiducial_data_t *arg1 = (player_fiducial_data_t *) 0 ;
    player_fiducial_item_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_data_t **)(void *)&jarg1; 
    result = (player_fiducial_item_t *)(player_fiducial_item_t *) ((arg1)->fiducials);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(32);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<32; i++) {
            arr[i] = 0;
            *(player_fiducial_item_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1fiducial_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_fiducial_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_fiducial_data_t *)new player_fiducial_data_t();
    
    *(player_fiducial_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1fiducial_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_fiducial_data_t *arg1 = (player_fiducial_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1fiducial_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->fiducial_size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1geom_1t_1fiducial_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->fiducial_size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1fiducial_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_fiducial_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_fiducial_geom_t *)new player_fiducial_geom_t();
    
    *(player_fiducial_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1fiducial_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_fiducial_geom_t *arg1 = (player_fiducial_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1min_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->min_range = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1min_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    result = (float) ((arg1)->min_range);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1max_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max_range = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1max_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max_range);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1view_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->view_angle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1fov_1t_1view_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    result = (float) ((arg1)->view_angle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1fiducial_1fov_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_fiducial_fov_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_fiducial_fov_t *)new player_fiducial_fov_t();
    
    *(player_fiducial_fov_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1fiducial_1fov_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_fiducial_fov_t *arg1 = (player_fiducial_fov_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_fov_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1id_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_fiducial_id_t *arg1 = (player_fiducial_id_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_id_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1fiducial_1id_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_fiducial_id_t *arg1 = (player_fiducial_id_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_id_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1fiducial_1id_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_fiducial_id_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_fiducial_id_t *)new player_fiducial_id_t();
    
    *(player_fiducial_id_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1fiducial_1id_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_fiducial_id_t *arg1 = (player_fiducial_id_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_fiducial_id_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GPS_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1time_1sec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->time_sec = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1time_1sec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->time_sec);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1time_1usec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->time_usec = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1time_1usec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->time_usec);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1latitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->latitude = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1latitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->latitude);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1longitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->longitude = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1longitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->longitude);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1altitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->altitude = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1altitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->altitude);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1utm_1e_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->utm_e = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1utm_1e_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (double) ((arg1)->utm_e);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1utm_1n_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->utm_n = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1utm_1n_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (double) ((arg1)->utm_n);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1quality_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->quality = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1quality_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->quality);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1num_1sats_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->num_sats = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1num_1sats_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->num_sats);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1hdop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->hdop = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1hdop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->hdop);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1vdop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->vdop = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1vdop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->vdop);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1err_1horz_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->err_horz = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1err_1horz_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (double) ((arg1)->err_horz);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1err_1vert_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->err_vert = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gps_1data_1t_1err_1vert_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    result = (double) ((arg1)->err_vert);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1gps_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_gps_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_gps_data_t *)new player_gps_data_t();
    
    *(player_gps_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1gps_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_gps_data_t *arg1 = (player_gps_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gps_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1MAX_1POINTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1CMD_1CLEAR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1CMD_1POINTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1CMD_1POLYLINE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS2D_1CMD_1POLYGON_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->count = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->count);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1points_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    player_point_2d_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 64) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_point_2d_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_point_2d_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_point_2d_t *b = (player_point_2d_t *) arg1->points;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((player_point_2d_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_point_2d_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1points_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    player_point_2d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    result = (player_point_2d_t *)(player_point_2d_t *) ((arg1)->points);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(64);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<64; i++) {
            arr[i] = 0;
            *(player_point_2d_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1points_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1graphics2d_1cmd_1points_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_points_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_graphics2d_cmd_points_t *)new player_graphics2d_cmd_points_t();
    
    *(player_graphics2d_cmd_points_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1graphics2d_1cmd_1points_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_graphics2d_cmd_points_t *arg1 = (player_graphics2d_cmd_points_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_points_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->count = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->count);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1points_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    player_point_2d_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 64) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_point_2d_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_point_2d_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_point_2d_t *b = (player_point_2d_t *) arg1->points;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((player_point_2d_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_point_2d_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1points_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    player_point_2d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    result = (player_point_2d_t *)(player_point_2d_t *) ((arg1)->points);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(64);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<64; i++) {
            arr[i] = 0;
            *(player_point_2d_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polyline_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1graphics2d_1cmd_1polyline_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_polyline_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_graphics2d_cmd_polyline_t *)new player_graphics2d_cmd_polyline_t();
    
    *(player_graphics2d_cmd_polyline_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1graphics2d_1cmd_1polyline_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_graphics2d_cmd_polyline_t *arg1 = (player_graphics2d_cmd_polyline_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polyline_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->count = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->count);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1points_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_point_2d_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 64) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_point_2d_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_point_2d_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_point_2d_t *b = (player_point_2d_t *) arg1->points;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((player_point_2d_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_point_2d_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1points_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_point_2d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    result = (player_point_2d_t *)(player_point_2d_t *) ((arg1)->points);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(64);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<64; i++) {
            arr[i] = 0;
            *(player_point_2d_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1fill_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->fill_color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1fill_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->fill_color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1filled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->filled = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics2d_1cmd_1polygon_1t_1filled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->filled);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1graphics2d_1cmd_1polygon_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_graphics2d_cmd_polygon_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_graphics2d_cmd_polygon_t *)new player_graphics2d_cmd_polygon_t();
    
    *(player_graphics2d_cmd_polygon_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1graphics2d_1cmd_1polygon_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_graphics2d_cmd_polygon_t *arg1 = (player_graphics2d_cmd_polygon_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics2d_cmd_polygon_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS3D_1MAX_1POINTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS3D_1CMD_1CLEAR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRAPHICS3D_1CMD_1DRAW_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1draw_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->draw_mode = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1draw_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->draw_mode);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1points_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->points_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1points_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->points_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1points_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    player_point_3d_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 64) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_point_3d_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_point_3d_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_point_3d_t *b = (player_point_3d_t *) arg1->points;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((player_point_3d_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_point_3d_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1points_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)(player_point_3d_t *) ((arg1)->points);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(64);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<64; i++) {
            arr[i] = 0;
            *(player_point_3d_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1color_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    player_color_t *arg2 = (player_color_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    arg2 = *(player_color_t **)(void *)&jarg2; 
    if (arg1) (arg1)->color = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1graphics3d_1cmd_1draw_1t_1color_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    result = (player_color_t *)& ((arg1)->color);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1graphics3d_1cmd_1draw_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_graphics3d_cmd_draw_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_graphics3d_cmd_draw_t *)new player_graphics3d_cmd_draw_t();
    
    *(player_graphics3d_cmd_draw_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1graphics3d_1cmd_1draw_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_graphics3d_cmd_draw_t *arg1 = (player_graphics3d_cmd_draw_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_graphics3d_cmd_draw_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRIPPER_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRIPPER_1CMD_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1GRIPPER_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPopen_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPclose_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPstop_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_LIFTup_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_LIFTdown_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_LIFTstop_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPstore_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPdeploy_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPhalt_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 15;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_GRIPpress_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_LIFTcarry_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 17;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1data_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_data_t *arg1 = (player_gripper_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1data_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_data_t *arg1 = (player_gripper_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->state);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1data_1t_1beams_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_data_t *arg1 = (player_gripper_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->beams = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1data_1t_1beams_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_data_t *arg1 = (player_gripper_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->beams);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1gripper_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_gripper_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_gripper_data_t *)new player_gripper_data_t();
    
    *(player_gripper_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1gripper_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_gripper_data_t *arg1 = (player_gripper_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1cmd_1t_1cmd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_cmd_t *arg1 = (player_gripper_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->cmd = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1cmd_1t_1cmd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_cmd_t *arg1 = (player_gripper_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->cmd);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1cmd_1t_1arg_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_cmd_t *arg1 = (player_gripper_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->arg = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1cmd_1t_1arg_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_cmd_t *arg1 = (player_gripper_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->arg);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1gripper_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_gripper_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_gripper_cmd_t *)new player_gripper_cmd_t();
    
    *(player_gripper_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1gripper_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_gripper_cmd_t *arg1 = (player_gripper_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_geom_t *arg1 = (player_gripper_geom_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_geom_t *arg1 = (player_gripper_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_gripper_geom_t *arg1 = (player_gripper_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1gripper_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_gripper_geom_t *arg1 = (player_gripper_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1gripper_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_gripper_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_gripper_geom_t *)new player_gripper_geom_t();
    
    *(player_gripper_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1gripper_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_gripper_geom_t *arg1 = (player_gripper_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_gripper_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1MAX_1SAMPLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1POSE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1IR_1DATA_1RANGES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1voltages_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->voltages_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1voltages_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->voltages_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1voltages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->voltages;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1voltages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->voltages);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 32); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1ranges_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->ranges_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1ranges_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->ranges_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1ranges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->ranges;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1data_1t_1ranges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->ranges);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 32); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ir_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ir_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ir_data_t *)new player_ir_data_t();
    
    *(player_ir_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ir_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ir_data_t *arg1 = (player_ir_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1pose_1t_1poses_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ir_pose_t *arg1 = (player_ir_pose_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_pose_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->poses_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1pose_1t_1poses_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ir_pose_t *arg1 = (player_ir_pose_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_pose_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->poses_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1pose_1t_1poses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_ir_pose_t *arg1 = (player_ir_pose_t *) 0 ;
    player_pose_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_pose_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 32) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_pose_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_pose_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_pose_t *b = (player_pose_t *) arg1->poses;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((player_pose_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_pose_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1pose_1t_1poses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_ir_pose_t *arg1 = (player_ir_pose_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_pose_t **)(void *)&jarg1; 
    result = (player_pose_t *)(player_pose_t *) ((arg1)->poses);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(32);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<32; i++) {
            arr[i] = 0;
            *(player_pose_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ir_1pose_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ir_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ir_pose_t *)new player_ir_pose_t();
    
    *(player_ir_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ir_1pose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ir_pose_t *arg1 = (player_ir_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_pose_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1power_1req_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_ir_power_req_t *arg1 = (player_ir_power_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_power_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ir_1power_1req_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_ir_power_req_t *arg1 = (player_ir_power_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_power_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ir_1power_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ir_power_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ir_power_req_t *)new player_ir_power_req_t();
    
    *(player_ir_power_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ir_1power_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ir_power_req_t *arg1 = (player_ir_power_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ir_power_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1JOYSTICK_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1xpos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->xpos = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1xpos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->xpos);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1ypos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->ypos = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1ypos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->ypos);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1xscale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->xscale = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1xscale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->xscale);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1yscale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->yscale = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1yscale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->yscale);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1buttons_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->buttons = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1joystick_1data_1t_1buttons_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->buttons);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1joystick_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_joystick_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_joystick_data_t *)new player_joystick_data_t();
    
    *(player_joystick_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1joystick_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_joystick_data_t *arg1 = (player_joystick_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_joystick_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1MAX_1SAMPLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1024;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1DATA_1SCAN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1DATA_1SCANPOSE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1REQ_1SET_1CONFIG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1REQ_1GET_1CONFIG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LASER_1REQ_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1min_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->min_angle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1min_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->min_angle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1max_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max_angle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1max_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max_angle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1resolution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->resolution = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1resolution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->resolution);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1max_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max_range = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1max_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max_range);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1ranges_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->ranges_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1ranges_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->ranges_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1ranges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 1024) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->ranges;
        for (ii = 0; ii < (size_t)1024; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1ranges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->ranges);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 1024); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1intensity_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->intensity_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1intensity_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->intensity_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1intensity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 1024) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->intensity;
        for (ii = 0; ii < (size_t)1024; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1intensity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->intensity);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 1024); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1laser_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_laser_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_laser_data_t *)new player_laser_data_t();
    
    *(player_laser_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1laser_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_laser_data_t *arg1 = (player_laser_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1scanpose_1t_1scan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_data_scanpose_t *arg1 = (player_laser_data_scanpose_t *) 0 ;
    player_laser_data_t *arg2 = (player_laser_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_scanpose_t **)(void *)&jarg1; 
    arg2 = *(player_laser_data_t **)(void *)&jarg2; 
    if (arg1) (arg1)->scan = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1scanpose_1t_1scan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_data_scanpose_t *arg1 = (player_laser_data_scanpose_t *) 0 ;
    player_laser_data_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_scanpose_t **)(void *)&jarg1; 
    result = (player_laser_data_t *)& ((arg1)->scan);
    
    *(player_laser_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1scanpose_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_data_scanpose_t *arg1 = (player_laser_data_scanpose_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_scanpose_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1data_1scanpose_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_data_scanpose_t *arg1 = (player_laser_data_scanpose_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_scanpose_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1laser_1data_1scanpose_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_laser_data_scanpose_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_laser_data_scanpose_t *)new player_laser_data_scanpose_t();
    
    *(player_laser_data_scanpose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1laser_1data_1scanpose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_laser_data_scanpose_t *arg1 = (player_laser_data_scanpose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_data_scanpose_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_geom_t *arg1 = (player_laser_geom_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_geom_t *arg1 = (player_laser_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_laser_geom_t *arg1 = (player_laser_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_laser_geom_t *arg1 = (player_laser_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1laser_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_laser_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_laser_geom_t *)new player_laser_geom_t();
    
    *(player_laser_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1laser_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_laser_geom_t *arg1 = (player_laser_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1min_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->min_angle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1min_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->min_angle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1max_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max_angle = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1max_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max_angle);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1resolution_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->resolution = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1resolution_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->resolution);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1max_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->max_range = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1max_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->max_range);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1range_1res_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->range_res = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1range_1res_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (float) ((arg1)->range_res);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1intensity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->intensity = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1config_1t_1intensity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->intensity);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1laser_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_laser_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_laser_config_t *)new player_laser_config_t();
    
    *(player_laser_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1laser_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_laser_config_t *arg1 = (player_laser_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1power_1config_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_laser_power_config_t *arg1 = (player_laser_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1laser_1power_1config_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_laser_power_config_t *arg1 = (player_laser_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1laser_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_laser_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_laser_power_config_t *)new player_laser_power_config_t();
    
    *(player_laser_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1laser_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_laser_power_config_t *arg1 = (player_laser_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_laser_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STATE_1IDLE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STATE_1BRAKED_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STATE_1MOVING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STATE_1OOR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STATE_1COLL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1HOME_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1STOP_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1SETPOSE_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1SETPOSITION_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1VECMOVE_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1POWER_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1BRAKES_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1GEOM_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LIMB_1SPEED_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->position = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->position);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1approach_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->approach = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1approach_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->approach);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1orientation_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->orientation = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1orientation_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->orientation);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1data_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_data_t *)new player_limb_data_t();
    
    *(player_limb_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_data_t *arg1 = (player_limb_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1home_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_home_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_home_cmd_t *)new player_limb_home_cmd_t();
    
    *(player_limb_home_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1home_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_home_cmd_t *arg1 = (player_limb_home_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_home_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1stop_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_stop_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_stop_cmd_t *)new player_limb_stop_cmd_t();
    
    *(player_limb_stop_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1stop_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_stop_cmd_t *arg1 = (player_limb_stop_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_stop_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->position = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->position);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1approach_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->approach = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1approach_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->approach);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1orientation_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->orientation = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setpose_1cmd_1t_1orientation_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->orientation);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1setpose_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_setpose_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_setpose_cmd_t *)new player_limb_setpose_cmd_t();
    
    *(player_limb_setpose_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1setpose_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_setpose_cmd_t *arg1 = (player_limb_setpose_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setpose_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setposition_1cmd_1t_1position_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_setposition_cmd_t *arg1 = (player_limb_setposition_cmd_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setposition_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->position = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1setposition_1cmd_1t_1position_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_setposition_cmd_t *arg1 = (player_limb_setposition_cmd_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setposition_cmd_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->position);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1setposition_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_setposition_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_setposition_cmd_t *)new player_limb_setposition_cmd_t();
    
    *(player_limb_setposition_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1setposition_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_setposition_cmd_t *arg1 = (player_limb_setposition_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_setposition_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1vecmove_1cmd_1t_1direction_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_vecmove_cmd_t *arg1 = (player_limb_vecmove_cmd_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_vecmove_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->direction = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1vecmove_1cmd_1t_1direction_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_vecmove_cmd_t *arg1 = (player_limb_vecmove_cmd_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_vecmove_cmd_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->direction);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1vecmove_1cmd_1t_1length_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_limb_vecmove_cmd_t *arg1 = (player_limb_vecmove_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_vecmove_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->length = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1vecmove_1cmd_1t_1length_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_limb_vecmove_cmd_t *arg1 = (player_limb_vecmove_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_vecmove_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->length);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1vecmove_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_vecmove_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_vecmove_cmd_t *)new player_limb_vecmove_cmd_t();
    
    *(player_limb_vecmove_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1vecmove_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_vecmove_cmd_t *arg1 = (player_limb_vecmove_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_vecmove_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1power_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_limb_power_req_t *arg1 = (player_limb_power_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_power_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1power_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_limb_power_req_t *arg1 = (player_limb_power_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_power_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1power_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_power_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_power_req_t *)new player_limb_power_req_t();
    
    *(player_limb_power_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1power_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_power_req_t *arg1 = (player_limb_power_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_power_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1brakes_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_limb_brakes_req_t *arg1 = (player_limb_brakes_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_brakes_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1brakes_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_limb_brakes_req_t *arg1 = (player_limb_brakes_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_brakes_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1brakes_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_brakes_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_brakes_req_t *)new player_limb_brakes_req_t();
    
    *(player_limb_brakes_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1brakes_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_brakes_req_t *arg1 = (player_limb_brakes_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_brakes_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1geom_1req_1t_1basePos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_limb_geom_req_t *arg1 = (player_limb_geom_req_t *) 0 ;
    player_point_3d_t *arg2 = (player_point_3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_geom_req_t **)(void *)&jarg1; 
    arg2 = *(player_point_3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->basePos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1geom_1req_1t_1basePos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_limb_geom_req_t *arg1 = (player_limb_geom_req_t *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_geom_req_t **)(void *)&jarg1; 
    result = (player_point_3d_t *)& ((arg1)->basePos);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1geom_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_geom_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_geom_req_t *)new player_limb_geom_req_t();
    
    *(player_limb_geom_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1geom_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_geom_req_t *arg1 = (player_limb_geom_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_geom_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1speed_1req_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_limb_speed_req_t *arg1 = (player_limb_speed_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_speed_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1limb_1speed_1req_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_limb_speed_req_t *arg1 = (player_limb_speed_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_speed_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1limb_1speed_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_limb_speed_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_limb_speed_req_t *)new player_limb_speed_req_t();
    
    *(player_limb_speed_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1limb_1speed_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_limb_speed_req_t *arg1 = (player_limb_speed_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_limb_speed_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1MAX_1HYPOTHS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1PARTICLES_1MAX_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1DATA_1HYPOTHS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1REQ_1SET_1POSE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOCALIZE_1REQ_1GET_1PARTICLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1mean_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->mean = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1mean_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->mean);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1cov_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    double *arg2 ;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        double *b = (double *) arg1->cov;
        for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((double *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jdoubleArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1cov_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdoubleArray jresult = 0 ;
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    double *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    result = (double *)(double *) ((arg1)->cov);
    
    jresult = SWIG_JavaArrayOutDouble(jenv, result, 3); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1alpha_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->alpha = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1hypoth_1t_1alpha_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    result = (double) ((arg1)->alpha);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1localize_1hypoth_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_localize_hypoth_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_localize_hypoth_t *)new player_localize_hypoth_t();
    
    *(player_localize_hypoth_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1localize_1hypoth_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_localize_hypoth_t *arg1 = (player_localize_hypoth_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_hypoth_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1pending_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->pending_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1pending_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->pending_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1pending_1time_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->pending_time = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1pending_1time_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    result = (double) ((arg1)->pending_time);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1hypoths_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->hypoths_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1hypoths_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->hypoths_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1hypoths_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    player_localize_hypoth_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 10) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_localize_hypoth_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_localize_hypoth_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_localize_hypoth_t *b = (player_localize_hypoth_t *) arg1->hypoths;
        for (ii = 0; ii < (size_t)10; ii++) b[ii] = *((player_localize_hypoth_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_localize_hypoth_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1data_1t_1hypoths_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    player_localize_hypoth_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    result = (player_localize_hypoth_t *)(player_localize_hypoth_t *) ((arg1)->hypoths);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(10);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<10; i++) {
            arr[i] = 0;
            *(player_localize_hypoth_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1localize_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_localize_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_localize_data_t *)new player_localize_data_t();
    
    *(player_localize_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1localize_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_localize_data_t *arg1 = (player_localize_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1set_1pose_1t_1mean_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_set_pose_t *arg1 = (player_localize_set_pose_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_set_pose_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->mean = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1set_1pose_1t_1mean_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_set_pose_t *arg1 = (player_localize_set_pose_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_set_pose_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->mean);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1set_1pose_1t_1cov_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
    player_localize_set_pose_t *arg1 = (player_localize_set_pose_t *) 0 ;
    double *arg2 ;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_set_pose_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 3) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        double *b = (double *) arg1->cov;
        for (ii = 0; ii < (size_t)3; ii++) b[ii] = *((double *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jdoubleArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1set_1pose_1t_1cov_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdoubleArray jresult = 0 ;
    player_localize_set_pose_t *arg1 = (player_localize_set_pose_t *) 0 ;
    double *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_set_pose_t **)(void *)&jarg1; 
    result = (double *)(double *) ((arg1)->cov);
    
    jresult = SWIG_JavaArrayOutDouble(jenv, result, 3); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1localize_1set_1pose_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_localize_set_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_localize_set_pose_t *)new player_localize_set_pose_t();
    
    *(player_localize_set_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1localize_1set_1pose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_localize_set_pose_t *arg1 = (player_localize_set_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_set_pose_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1particle_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_particle_t *arg1 = (player_localize_particle_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_particle_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1particle_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_particle_t *arg1 = (player_localize_particle_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_particle_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1particle_1t_1alpha_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_localize_particle_t *arg1 = (player_localize_particle_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_particle_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->alpha = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1particle_1t_1alpha_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_localize_particle_t *arg1 = (player_localize_particle_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_particle_t **)(void *)&jarg1; 
    result = (double) ((arg1)->alpha);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1localize_1particle_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_localize_particle_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_localize_particle_t *)new player_localize_particle_t();
    
    *(player_localize_particle_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1localize_1particle_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_localize_particle_t *arg1 = (player_localize_particle_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_particle_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1mean_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->mean = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1mean_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->mean);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1variance_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->variance = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1variance_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    result = (double) ((arg1)->variance);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1particles_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->particles_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1particles_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->particles_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1particles_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    player_localize_particle_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 100) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_localize_particle_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_localize_particle_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_localize_particle_t *b = (player_localize_particle_t *) arg1->particles;
        for (ii = 0; ii < (size_t)100; ii++) b[ii] = *((player_localize_particle_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_localize_particle_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1localize_1get_1particles_1t_1particles_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    player_localize_particle_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    result = (player_localize_particle_t *)(player_localize_particle_t *) ((arg1)->particles);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(100);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<100; i++) {
            arr[i] = 0;
            *(player_localize_particle_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1localize_1get_1particles_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_localize_get_particles_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_localize_get_particles_t *)new player_localize_get_particles_t();
    
    *(player_localize_get_particles_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1localize_1get_1particles_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_localize_get_particles_t *arg1 = (player_localize_get_particles_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_localize_get_particles_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1TYPE_1READ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1TYPE_1WRITE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1REQ_1SET_1WRITE_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1REQ_1SET_1READ_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1REQ_1GET_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1REQ_1SET_1READ_1REWIND_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1LOG_1REQ_1SET_1FILENAME_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1write_1state_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_log_set_write_state_t *arg1 = (player_log_set_write_state_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_write_state_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1write_1state_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_log_set_write_state_t *arg1 = (player_log_set_write_state_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_write_state_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1log_1set_1write_1state_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_log_set_write_state_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_log_set_write_state_t *)new player_log_set_write_state_t();
    
    *(player_log_set_write_state_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1log_1set_1write_1state_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_log_set_write_state_t *arg1 = (player_log_set_write_state_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_write_state_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1read_1state_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_log_set_read_state_t *arg1 = (player_log_set_read_state_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_read_state_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1read_1state_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_log_set_read_state_t *arg1 = (player_log_set_read_state_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_read_state_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1log_1set_1read_1state_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_log_set_read_state_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_log_set_read_state_t *)new player_log_set_read_state_t();
    
    *(player_log_set_read_state_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1log_1set_1read_1state_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_log_set_read_state_t *arg1 = (player_log_set_read_state_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_read_state_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1log_1set_1read_1rewind_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_log_set_read_rewind_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_log_set_read_rewind_t *)new player_log_set_read_rewind_t();
    
    *(player_log_set_read_rewind_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1log_1set_1read_1rewind_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_log_set_read_rewind_t *arg1 = (player_log_set_read_rewind_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_read_rewind_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1get_1state_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_log_get_state_t *arg1 = (player_log_get_state_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_get_state_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1get_1state_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_log_get_state_t *arg1 = (player_log_get_state_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_get_state_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->type);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1get_1state_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_log_get_state_t *arg1 = (player_log_get_state_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_get_state_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1get_1state_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_log_get_state_t *arg1 = (player_log_get_state_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_get_state_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1log_1get_1state_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_log_get_state_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_log_get_state_t *)new player_log_get_state_t();
    
    *(player_log_get_state_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1log_1get_1state_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_log_get_state_t *arg1 = (player_log_get_state_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_get_state_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1filename_1t_1filename_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_log_set_filename_t *arg1 = (player_log_set_filename_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_filename_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->filename_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1filename_1t_1filename_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_log_set_filename_t *arg1 = (player_log_set_filename_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_filename_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->filename_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1filename_1t_1filename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_log_set_filename_t *arg1 = (player_log_set_filename_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_filename_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->filename,arg2,256);
        else arg1->filename[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1log_1set_1filename_1t_1filename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_log_set_filename_t *arg1 = (player_log_set_filename_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_filename_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->filename);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1log_1set_1filename_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_log_set_filename_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_log_set_filename_t *)new player_log_set_filename_t();
    
    *(player_log_set_filename_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1log_1set_1filename_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_log_set_filename_t *arg1 = (player_log_set_filename_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_log_set_filename_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1MAX_1SEGMENTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 131068;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1DATA_1INFO_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1REQ_1GET_1INFO_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1REQ_1GET_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MAP_1REQ_1GET_1VECTOR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1scale_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->scale = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1scale_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    result = (float) ((arg1)->scale);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->width);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1height_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1height_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->height);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1origin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->origin = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1info_1t_1origin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->origin);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1map_1info_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_map_info_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_map_info_t *)new player_map_info_t();
    
    *(player_map_info_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1map_1info_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_map_info_t *arg1 = (player_map_info_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_info_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1col_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->col = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1col_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->col);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1row_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->row = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1row_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->row);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->width = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->width);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1height_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->height = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1height_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->height);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1data_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->data_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1data_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->data_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    int8_t *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    arg2 = *(int8_t **)(void *)&jarg2; 
    {
        size_t ii;
        int8_t *b = (int8_t *) arg1->data;
        for (ii = 0; ii < (size_t)(((int) (((8388608-sizeof(player_msghdr_t)) -12)/1.001)) -20-1); ii++) b[ii] = *((int8_t *) arg2 + ii);
    }
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    int8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    result = (int8_t *)(int8_t *) ((arg1)->data);
    
    *(int8_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1map_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_map_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_map_data_t *)new player_map_data_t();
    
    *(player_map_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1map_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_map_data_t *arg1 = (player_map_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1minx_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->minx = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1minx_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (float) ((arg1)->minx);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1maxx_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->maxx = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1maxx_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (float) ((arg1)->maxx);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1miny_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->miny = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1miny_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (float) ((arg1)->miny);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1maxy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->maxy = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1maxy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (float) ((arg1)->maxy);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1segments_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->segments_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1segments_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->segments_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1segments_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    player_segment_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 131068) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_segment_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_segment_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_segment_t *b = (player_segment_t *) arg1->segments;
        for (ii = 0; ii < (size_t)131068; ii++) b[ii] = *((player_segment_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_segment_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1map_1data_1vector_1t_1segments_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    player_segment_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    result = (player_segment_t *)(player_segment_t *) ((arg1)->segments);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(131068);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<131068; i++) {
            arr[i] = 0;
            *(player_segment_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1map_1data_1vector_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_map_data_vector_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_map_data_vector_t *)new player_map_data_vector_t();
    
    *(player_map_data_vector_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1map_1data_1vector_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_map_data_vector_t *arg1 = (player_map_data_vector_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_map_data_vector_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MCOM_1DATA_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 128;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MCOM_1N_1BUFS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MCOM_1CHANNEL_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_MCOM_1EMPTY_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "(EMPTY)";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1PUSH_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1POP_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1READ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1CLEAR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1MCOM_1SET_1CAPACITY_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1full_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jchar jarg2) {
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    char arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    arg2 = (char)jarg2; 
    if (arg1) (arg1)->full = arg2;
    
}


JNIEXPORT jchar JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1full_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jchar jresult = 0 ;
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    char result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    result = (char) ((arg1)->full);
    
    jresult = (jchar)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1data_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->data_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1data_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->data_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->data,arg2,128);
        else arg1->data[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1data_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->data);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1mcom_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_mcom_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_mcom_data_t *)new player_mcom_data_t();
    
    *(player_mcom_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1mcom_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_mcom_data_t *arg1 = (player_mcom_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1command_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->command = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1command_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->command);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->type);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1channel_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->channel_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1channel_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->channel_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1channel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->channel,arg2,8);
        else arg1->channel[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1channel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->channel);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    player_mcom_data_t *arg2 = (player_mcom_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    arg2 = *(player_mcom_data_t **)(void *)&jarg2; 
    if (arg1) (arg1)->data = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1config_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    player_mcom_data_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    result = (player_mcom_data_t *)& ((arg1)->data);
    
    *(player_mcom_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1mcom_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_mcom_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_mcom_config_t *)new player_mcom_config_t();
    
    *(player_mcom_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1mcom_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_mcom_config_t *arg1 = (player_mcom_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->type);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1channel_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->channel_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1channel_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->channel_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1channel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->channel,arg2,8);
        else arg1->channel[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1channel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->channel);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    player_mcom_data_t *arg2 = (player_mcom_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    arg2 = *(player_mcom_data_t **)(void *)&jarg2; 
    if (arg1) (arg1)->data = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1mcom_1return_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    player_mcom_data_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    result = (player_mcom_data_t *)& ((arg1)->data);
    
    *(player_mcom_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1mcom_1return_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_mcom_return_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_mcom_return_t *)new player_mcom_return_t();
    
    *(player_mcom_return_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1mcom_1return_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_mcom_return_t *arg1 = (player_mcom_return_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_mcom_return_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1CMD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPAQUE_1MAX_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1048576;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1opaque_1data_1t_1data_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_opaque_data_t *arg1 = (player_opaque_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_opaque_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->data_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1opaque_1data_1t_1data_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_opaque_data_t *arg1 = (player_opaque_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_opaque_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->data_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1opaque_1data_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_opaque_data_t *arg1 = (player_opaque_data_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_opaque_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 1048576) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->data;
        for (ii = 0; ii < (size_t)1048576; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1opaque_1data_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_opaque_data_t *arg1 = (player_opaque_data_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_opaque_data_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->data);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 1048576); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1opaque_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_opaque_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_opaque_data_t *)new player_opaque_data_t();
    
    *(player_opaque_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1opaque_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_opaque_data_t *arg1 = (player_opaque_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_opaque_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1MAX_1WAYPOINTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 128;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1CMD_1GOAL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1REQ_1GET_1WAYPOINTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLANNER_1REQ_1ENABLE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1valid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->valid = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1valid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->valid);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1done_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->done = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1done_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->done);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pos);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1goal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->goal = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1goal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->goal);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->waypoint = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->waypoint);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoint_1idx_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->waypoint_idx = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoint_1idx_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->waypoint_idx);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoints_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->waypoints_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1data_1t_1waypoints_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->waypoints_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1planner_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_planner_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_planner_data_t *)new player_planner_data_t();
    
    *(player_planner_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1planner_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_planner_data_t *arg1 = (player_planner_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1cmd_1t_1goal_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_cmd_t *arg1 = (player_planner_cmd_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_cmd_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->goal = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1cmd_1t_1goal_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_cmd_t *arg1 = (player_planner_cmd_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_cmd_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->goal);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1planner_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_planner_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_planner_cmd_t *)new player_planner_cmd_t();
    
    *(player_planner_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1planner_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_planner_cmd_t *arg1 = (player_planner_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1waypoints_1req_1t_1waypoints_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_planner_waypoints_req_t *arg1 = (player_planner_waypoints_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_waypoints_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->waypoints_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1waypoints_1req_1t_1waypoints_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_planner_waypoints_req_t *arg1 = (player_planner_waypoints_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_waypoints_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->waypoints_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1waypoints_1req_1t_1waypoints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_planner_waypoints_req_t *arg1 = (player_planner_waypoints_req_t *) 0 ;
    player_pose_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_waypoints_req_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 128) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_pose_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_pose_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_pose_t *b = (player_pose_t *) arg1->waypoints;
        for (ii = 0; ii < (size_t)128; ii++) b[ii] = *((player_pose_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_pose_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1waypoints_1req_1t_1waypoints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_planner_waypoints_req_t *arg1 = (player_planner_waypoints_req_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_waypoints_req_t **)(void *)&jarg1; 
    result = (player_pose_t *)(player_pose_t *) ((arg1)->waypoints);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(128);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<128; i++) {
            arr[i] = 0;
            *(player_pose_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1planner_1waypoints_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_planner_waypoints_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_planner_waypoints_req_t *)new player_planner_waypoints_req_t();
    
    *(player_planner_waypoints_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1planner_1waypoints_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_planner_waypoints_req_t *arg1 = (player_planner_waypoints_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_waypoints_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1enable_1req_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_planner_enable_req_t *arg1 = (player_planner_enable_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_enable_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1planner_1enable_1req_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_planner_enable_req_t *arg1 = (player_planner_enable_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_enable_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1planner_1enable_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_planner_enable_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_planner_enable_req_t *)new player_planner_enable_req_t();
    
    *(player_planner_enable_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1planner_1enable_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_planner_enable_req_t *arg1 = (player_planner_enable_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_planner_enable_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1OPEN_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1CLOSE_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1ERROR_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DATAMODE_1PUSH_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1DATAMODE_1PULL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1DEVLIST_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1DRIVERINFO_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1DEV_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1DATAMODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1AUTH_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1NAMESERVICE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1IDENT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PLAYER_1REQ_1ADD_1REPLACE_1RULE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1devlist_1t_1devices_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_devlist_t *arg1 = (player_device_devlist_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_devlist_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->devices_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1devlist_1t_1devices_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_devlist_t *arg1 = (player_device_devlist_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_devlist_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->devices_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1devlist_1t_1devices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_device_devlist_t *arg1 = (player_device_devlist_t *) 0 ;
    player_devaddr_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_devlist_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 256) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_devaddr_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_devaddr_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_devaddr_t *b = (player_devaddr_t *) arg1->devices;
        for (ii = 0; ii < (size_t)256; ii++) b[ii] = *((player_devaddr_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_devaddr_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1devlist_1t_1devices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_device_devlist_t *arg1 = (player_device_devlist_t *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_devlist_t **)(void *)&jarg1; 
    result = (player_devaddr_t *)(player_devaddr_t *) ((arg1)->devices);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(256);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<256; i++) {
            arr[i] = 0;
            *(player_devaddr_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1devlist_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_devlist_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_devlist_t *)new player_device_devlist_t();
    
    *(player_device_devlist_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1devlist_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_devlist_t *arg1 = (player_device_devlist_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_devlist_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (arg1) (arg1)->addr = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    result = (player_devaddr_t *)& ((arg1)->addr);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1driver_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->driver_name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1driver_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->driver_name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1driver_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->driver_name,arg2,64);
        else arg1->driver_name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1driverinfo_1t_1driver_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->driver_name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1driverinfo_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_driverinfo_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_driverinfo_t *)new player_device_driverinfo_t();
    
    *(player_device_driverinfo_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1driverinfo_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_driverinfo_t *arg1 = (player_device_driverinfo_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_driverinfo_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1addr_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    player_devaddr_t *arg2 = (player_devaddr_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    arg2 = *(player_devaddr_t **)(void *)&jarg2; 
    if (arg1) (arg1)->addr = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1addr_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    result = (player_devaddr_t *)& ((arg1)->addr);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1access_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->access = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1access_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->access);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1driver_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->driver_name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1driver_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->driver_name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1driver_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->driver_name,arg2,64);
        else arg1->driver_name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1req_1t_1driver_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->driver_name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_req_t *)new player_device_req_t();
    
    *(player_device_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_req_t *arg1 = (player_device_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1data_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_data_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_data_req_t *)new player_device_data_req_t();
    
    *(player_device_data_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1data_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_data_req_t *arg1 = (player_device_data_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_data_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1datamode_1req_1t_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_device_datamode_req_t *arg1 = (player_device_datamode_req_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_datamode_req_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->mode = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1datamode_1req_1t_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_device_datamode_req_t *arg1 = (player_device_datamode_req_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_datamode_req_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->mode);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1datamode_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_datamode_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_datamode_req_t *)new player_device_datamode_req_t();
    
    *(player_device_datamode_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1datamode_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_datamode_req_t *arg1 = (player_device_datamode_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_datamode_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1auth_1req_1t_1auth_1key_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_auth_req_t *arg1 = (player_device_auth_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_auth_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->auth_key_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1auth_1req_1t_1auth_1key_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_auth_req_t *arg1 = (player_device_auth_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_auth_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->auth_key_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1auth_1req_1t_1auth_1key_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_device_auth_req_t *arg1 = (player_device_auth_req_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_auth_req_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->auth_key;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1auth_1req_1t_1auth_1key_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_device_auth_req_t *arg1 = (player_device_auth_req_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_auth_req_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->auth_key);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1auth_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_auth_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_auth_req_t *)new player_device_auth_req_t();
    
    *(player_device_auth_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1auth_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_auth_req_t *arg1 = (player_device_auth_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_auth_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 64) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->name;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->name);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 64); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1port_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    arg2 = (uint16_t)jarg2; 
    if (arg1) (arg1)->port = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1device_1nameservice_1req_1t_1port_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    uint16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    result = (uint16_t) ((arg1)->port);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1device_1nameservice_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_device_nameservice_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_device_nameservice_req_t *)new player_device_nameservice_req_t();
    
    *(player_device_nameservice_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1device_1nameservice_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_device_nameservice_req_t *arg1 = (player_device_nameservice_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_device_nameservice_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1interf_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->interf = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1interf_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->interf);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->index = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->index);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->type);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1subtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->subtype = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1subtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->subtype);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1replace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->replace = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1add_1replace_1rule_1req_1t_1replace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->replace);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1add_1replace_1rule_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_add_replace_rule_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_add_replace_rule_req_t *)new player_add_replace_rule_req_t();
    
    *(player_add_replace_rule_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1add_1replace_1rule_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_add_replace_rule_req_t *arg1 = (player_add_replace_rule_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_add_replace_rule_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1MOTOR_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1VELOCITY_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1POSITION_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1SET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1RESET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1SPEED_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1POSITION_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1REQ_1SPEED_1PROF_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1DATA_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1CMD_1VEL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1CMD_1POS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1LIMIT_1MIN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1LIMIT_1CEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1LIMIT_1MAX_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1OC_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1TRAJ_1COMPLETE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION1D_1STATUS_1ENABLED_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pos = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pos);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->vel = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->vel);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1stall_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->stall = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1stall_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->stall);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->status = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1data_1t_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->status);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_data_t *)new player_position1d_data_t();
    
    *(player_position1d_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_data_t *arg1 = (player_position1d_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1vel_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_cmd_vel_t *arg1 = (player_position1d_cmd_vel_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->vel = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1vel_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_cmd_vel_t *arg1 = (player_position1d_cmd_vel_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_vel_t **)(void *)&jarg1; 
    result = (float) ((arg1)->vel);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1vel_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position1d_cmd_vel_t *arg1 = (player_position1d_cmd_vel_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1vel_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position1d_cmd_vel_t *arg1 = (player_position1d_cmd_vel_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_vel_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_cmd_vel_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_cmd_vel_t *)new player_position1d_cmd_vel_t();
    
    *(player_position1d_cmd_vel_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_cmd_vel_t *arg1 = (player_position1d_cmd_vel_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_vel_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pos = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pos);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->vel = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    result = (float) ((arg1)->vel);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1cmd_1pos_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_cmd_pos_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_cmd_pos_t *)new player_position1d_cmd_pos_t();
    
    *(player_position1d_cmd_pos_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_cmd_pos_t *arg1 = (player_position1d_cmd_pos_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_cmd_pos_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position1d_geom_t *arg1 = (player_position1d_geom_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position1d_geom_t *arg1 = (player_position1d_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position1d_geom_t *arg1 = (player_position1d_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position1d_geom_t *arg1 = (player_position1d_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_geom_t *)new player_position1d_geom_t();
    
    *(player_position1d_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_geom_t *arg1 = (player_position1d_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1power_1config_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position1d_power_config_t *arg1 = (player_position1d_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1power_1config_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position1d_power_config_t *arg1 = (player_position1d_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_power_config_t *)new player_position1d_power_config_t();
    
    *(player_position1d_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_power_config_t *arg1 = (player_position1d_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1velocity_1mode_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position1d_velocity_mode_config_t *arg1 = (player_position1d_velocity_mode_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_velocity_mode_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1velocity_1mode_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position1d_velocity_mode_config_t *arg1 = (player_position1d_velocity_mode_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_velocity_mode_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_velocity_mode_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_velocity_mode_config_t *)new player_position1d_velocity_mode_config_t();
    
    *(player_position1d_velocity_mode_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_velocity_mode_config_t *arg1 = (player_position1d_velocity_mode_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_velocity_mode_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1reset_1odom_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position1d_reset_odom_config_t *arg1 = (player_position1d_reset_odom_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_reset_odom_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1reset_1odom_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position1d_reset_odom_config_t *arg1 = (player_position1d_reset_odom_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_reset_odom_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_reset_odom_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_reset_odom_config_t *)new player_position1d_reset_odom_config_t();
    
    *(player_position1d_reset_odom_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_reset_odom_config_t *arg1 = (player_position1d_reset_odom_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_reset_odom_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1mode_1req_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position1d_position_mode_req_t *arg1 = (player_position1d_position_mode_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_mode_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1mode_1req_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position1d_position_mode_req_t *arg1 = (player_position1d_position_mode_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_mode_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->state);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_position_mode_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_position_mode_req_t *)new player_position1d_position_mode_req_t();
    
    *(player_position1d_position_mode_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_position_mode_req_t *arg1 = (player_position1d_position_mode_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_mode_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1set_1odom_1req_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_set_odom_req_t *arg1 = (player_position1d_set_odom_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_set_odom_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pos = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1set_1odom_1req_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_set_odom_req_t *arg1 = (player_position1d_set_odom_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_set_odom_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pos);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_set_odom_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_set_odom_req_t *)new player_position1d_set_odom_req_t();
    
    *(player_position1d_set_odom_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_set_odom_req_t *arg1 = (player_position1d_set_odom_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_set_odom_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_speed_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_speed_pid_req_t *)new player_position1d_speed_pid_req_t();
    
    *(player_position1d_speed_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_speed_pid_req_t *arg1 = (player_position1d_speed_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1position_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_position_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_position_pid_req_t *)new player_position1d_position_pid_req_t();
    
    *(player_position1d_position_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_position_pid_req_t *arg1 = (player_position1d_position_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_position_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1prof_1req_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_speed_prof_req_t *arg1 = (player_position1d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1prof_1req_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_speed_prof_req_t *arg1 = (player_position1d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1prof_1req_1t_1acc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position1d_speed_prof_req_t *arg1 = (player_position1d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->acc = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position1d_1speed_1prof_1req_1t_1acc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position1d_speed_prof_req_t *arg1 = (player_position1d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->acc);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position1d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position1d_speed_prof_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position1d_speed_prof_req_t *)new player_position1d_speed_prof_req_t();
    
    *(player_position1d_speed_prof_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position1d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position1d_speed_prof_req_t *arg1 = (player_position1d_speed_prof_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position1d_speed_prof_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1MOTOR_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1VELOCITY_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1POSITION_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1SET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1RESET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1SPEED_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1POSITION_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1REQ_1SPEED_1PROF_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1DATA_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1CMD_1VEL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1CMD_1POS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION2D_1CMD_1CAR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pos);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->vel);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1stall_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->stall = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1data_1t_1stall_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->stall);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_data_t *)new player_position2d_data_t();
    
    *(player_position2d_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_data_t *arg1 = (player_position2d_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1vel_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_cmd_vel_t *arg1 = (player_position2d_cmd_vel_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1vel_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_cmd_vel_t *arg1 = (player_position2d_cmd_vel_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_vel_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->vel);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1vel_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position2d_cmd_vel_t *arg1 = (player_position2d_cmd_vel_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1vel_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position2d_cmd_vel_t *arg1 = (player_position2d_cmd_vel_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_vel_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_cmd_vel_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_cmd_vel_t *)new player_position2d_cmd_vel_t();
    
    *(player_position2d_cmd_vel_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_cmd_vel_t *arg1 = (player_position2d_cmd_vel_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_vel_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pos);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->vel);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1pos_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_cmd_pos_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_cmd_pos_t *)new player_position2d_cmd_pos_t();
    
    *(player_position2d_cmd_pos_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_cmd_pos_t *arg1 = (player_position2d_cmd_pos_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_pos_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1car_1t_1velocity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_position2d_cmd_car_t *arg1 = (player_position2d_cmd_car_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_car_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->velocity = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1car_1t_1velocity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_position2d_cmd_car_t *arg1 = (player_position2d_cmd_car_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_car_t **)(void *)&jarg1; 
    result = (double) ((arg1)->velocity);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1car_1t_1angle_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_position2d_cmd_car_t *arg1 = (player_position2d_cmd_car_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_car_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->angle = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1cmd_1car_1t_1angle_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_position2d_cmd_car_t *arg1 = (player_position2d_cmd_car_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_car_t **)(void *)&jarg1; 
    result = (double) ((arg1)->angle);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1cmd_1car_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_cmd_car_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_cmd_car_t *)new player_position2d_cmd_car_t();
    
    *(player_position2d_cmd_car_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1cmd_1car_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_cmd_car_t *arg1 = (player_position2d_cmd_car_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_cmd_car_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_geom_t *arg1 = (player_position2d_geom_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_geom_t *arg1 = (player_position2d_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_geom_t *arg1 = (player_position2d_geom_t *) 0 ;
    player_bbox_t *arg2 = (player_bbox_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_geom_t *arg1 = (player_position2d_geom_t *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_geom_t **)(void *)&jarg1; 
    result = (player_bbox_t *)& ((arg1)->size);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_geom_t *)new player_position2d_geom_t();
    
    *(player_position2d_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_geom_t *arg1 = (player_position2d_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1power_1config_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position2d_power_config_t *arg1 = (player_position2d_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1power_1config_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position2d_power_config_t *arg1 = (player_position2d_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_power_config_t *)new player_position2d_power_config_t();
    
    *(player_position2d_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_power_config_t *arg1 = (player_position2d_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1velocity_1mode_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_velocity_mode_config_t *arg1 = (player_position2d_velocity_mode_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_velocity_mode_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1velocity_1mode_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_velocity_mode_config_t *arg1 = (player_position2d_velocity_mode_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_velocity_mode_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_velocity_mode_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_velocity_mode_config_t *)new player_position2d_velocity_mode_config_t();
    
    *(player_position2d_velocity_mode_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_velocity_mode_config_t *arg1 = (player_position2d_velocity_mode_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_velocity_mode_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_reset_odom_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_reset_odom_config_t *)new player_position2d_reset_odom_config_t();
    
    *(player_position2d_reset_odom_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_reset_odom_config_t *arg1 = (player_position2d_reset_odom_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_reset_odom_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1mode_1req_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_position_mode_req_t *arg1 = (player_position2d_position_mode_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_mode_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1mode_1req_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_position_mode_req_t *arg1 = (player_position2d_position_mode_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_mode_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->state);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_position_mode_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_position_mode_req_t *)new player_position2d_position_mode_req_t();
    
    *(player_position2d_position_mode_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_position_mode_req_t *arg1 = (player_position2d_position_mode_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_mode_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1set_1odom_1req_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position2d_set_odom_req_t *arg1 = (player_position2d_set_odom_req_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_set_odom_req_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1set_1odom_1req_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position2d_set_odom_req_t *arg1 = (player_position2d_set_odom_req_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_set_odom_req_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_set_odom_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_set_odom_req_t *)new player_position2d_set_odom_req_t();
    
    *(player_position2d_set_odom_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_set_odom_req_t *arg1 = (player_position2d_set_odom_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_set_odom_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_speed_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_speed_pid_req_t *)new player_position2d_speed_pid_req_t();
    
    *(player_position2d_speed_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_speed_pid_req_t *arg1 = (player_position2d_speed_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1position_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_position_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_position_pid_req_t *)new player_position2d_position_pid_req_t();
    
    *(player_position2d_position_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_position_pid_req_t *arg1 = (player_position2d_position_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_position_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1prof_1req_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_speed_prof_req_t *arg1 = (player_position2d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1prof_1req_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_speed_prof_req_t *arg1 = (player_position2d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1prof_1req_1t_1acc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position2d_speed_prof_req_t *arg1 = (player_position2d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->acc = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position2d_1speed_1prof_1req_1t_1acc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position2d_speed_prof_req_t *arg1 = (player_position2d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->acc);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position2d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position2d_speed_prof_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position2d_speed_prof_req_t *)new player_position2d_speed_prof_req_t();
    
    *(player_position2d_speed_prof_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position2d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position2d_speed_prof_req_t *arg1 = (player_position2d_speed_prof_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position2d_speed_prof_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1DATA_1GEOMETRY_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1CMD_1SET_1VEL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1CMD_1SET_1POS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1MOTOR_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1VELOCITY_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1POSITION_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1RESET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1SET_1ODOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1SPEED_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1POSITION_1PID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POSITION3D_1SPEED_1PROF_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pos);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->vel);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1stall_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->stall = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1data_1t_1stall_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->stall);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_data_t *)new player_position3d_data_t();
    
    *(player_position3d_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_data_t *arg1 = (player_position3d_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pos);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->vel);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1pos_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_cmd_pos_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_cmd_pos_t *)new player_position3d_cmd_pos_t();
    
    *(player_position3d_cmd_pos_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1cmd_1pos_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_cmd_pos_t *arg1 = (player_position3d_cmd_pos_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_pos_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1vel_1t_1vel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_cmd_vel_t *arg1 = (player_position3d_cmd_vel_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->vel = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1vel_1t_1vel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_cmd_vel_t *arg1 = (player_position3d_cmd_vel_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_vel_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->vel);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1vel_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position3d_cmd_vel_t *arg1 = (player_position3d_cmd_vel_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_vel_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1cmd_1vel_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position3d_cmd_vel_t *arg1 = (player_position3d_cmd_vel_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_vel_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_cmd_vel_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_cmd_vel_t *)new player_position3d_cmd_vel_t();
    
    *(player_position3d_cmd_vel_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1cmd_1vel_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_cmd_vel_t *arg1 = (player_position3d_cmd_vel_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_cmd_vel_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1geom_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_geom_t *arg1 = (player_position3d_geom_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1geom_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_geom_t *arg1 = (player_position3d_geom_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_geom_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pose);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_geom_t *arg1 = (player_position3d_geom_t *) 0 ;
    player_bbox3d_t *arg2 = (player_bbox3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_geom_t *arg1 = (player_position3d_geom_t *) 0 ;
    player_bbox3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_geom_t **)(void *)&jarg1; 
    result = (player_bbox3d_t *)& ((arg1)->size);
    
    *(player_bbox3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_geom_t *)new player_position3d_geom_t();
    
    *(player_position3d_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_geom_t *arg1 = (player_position3d_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1power_1config_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_position3d_power_config_t *arg1 = (player_position3d_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1power_1config_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_position3d_power_config_t *arg1 = (player_position3d_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_power_config_t *)new player_position3d_power_config_t();
    
    *(player_position3d_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_power_config_t *arg1 = (player_position3d_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1mode_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_position_mode_req_t *arg1 = (player_position3d_position_mode_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_mode_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1mode_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_position_mode_req_t *arg1 = (player_position3d_position_mode_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_mode_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_position_mode_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_position_mode_req_t *)new player_position3d_position_mode_req_t();
    
    *(player_position3d_position_mode_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1position_1mode_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_position_mode_req_t *arg1 = (player_position3d_position_mode_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_mode_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1velocity_1mode_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_velocity_mode_config_t *arg1 = (player_position3d_velocity_mode_config_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_velocity_mode_config_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1velocity_1mode_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_velocity_mode_config_t *arg1 = (player_position3d_velocity_mode_config_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_velocity_mode_config_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_velocity_mode_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_velocity_mode_config_t *)new player_position3d_velocity_mode_config_t();
    
    *(player_position3d_velocity_mode_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1velocity_1mode_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_velocity_mode_config_t *arg1 = (player_position3d_velocity_mode_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_velocity_mode_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1set_1odom_1req_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_position3d_set_odom_req_t *arg1 = (player_position3d_set_odom_req_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_set_odom_req_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1set_1odom_1req_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_position3d_set_odom_req_t *arg1 = (player_position3d_set_odom_req_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_set_odom_req_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pos);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_set_odom_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_set_odom_req_t *)new player_position3d_set_odom_req_t();
    
    *(player_position3d_set_odom_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1set_1odom_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_set_odom_req_t *arg1 = (player_position3d_set_odom_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_set_odom_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_reset_odom_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_reset_odom_config_t *)new player_position3d_reset_odom_config_t();
    
    *(player_position3d_reset_odom_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1reset_1odom_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_reset_odom_config_t *arg1 = (player_position3d_reset_odom_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_reset_odom_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_speed_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_speed_pid_req_t *)new player_position3d_speed_pid_req_t();
    
    *(player_position3d_speed_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1speed_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_speed_pid_req_t *arg1 = (player_position3d_speed_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1kp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kp = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1kp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kp);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1ki_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->ki = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1ki_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->ki);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1kd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->kd = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1position_1pid_1req_1t_1kd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->kd);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_position_pid_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_position_pid_req_t *)new player_position3d_position_pid_req_t();
    
    *(player_position3d_position_pid_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1position_1pid_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_position_pid_req_t *arg1 = (player_position3d_position_pid_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_position_pid_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1prof_1req_1t_1speed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_speed_prof_req_t *arg1 = (player_position3d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->speed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1prof_1req_1t_1speed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_speed_prof_req_t *arg1 = (player_position3d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->speed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1prof_1req_1t_1acc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_position3d_speed_prof_req_t *arg1 = (player_position3d_speed_prof_req_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_prof_req_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->acc = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1position3d_1speed_1prof_1req_1t_1acc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_position3d_speed_prof_req_t *arg1 = (player_position3d_speed_prof_req_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_prof_req_t **)(void *)&jarg1; 
    result = (float) ((arg1)->acc);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1position3d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_position3d_speed_prof_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_position3d_speed_prof_req_t *)new player_position3d_speed_prof_req_t();
    
    *(player_position3d_speed_prof_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1position3d_1speed_1prof_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_position3d_speed_prof_req_t *arg1 = (player_position3d_speed_prof_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_position3d_speed_prof_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1SET_1CHARGING_1POLICY_1REQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1MASK_1VOLTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1MASK_1WATTS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1MASK_1JOULES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1MASK_1PERCENT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1POWER_1MASK_1CHARGING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1valid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->valid = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1valid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->valid);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1volts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->volts = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1volts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->volts);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1percent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->percent = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1percent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->percent);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1joules_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->joules = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1joules_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->joules);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1watts_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->watts = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1watts_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->watts);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1charging_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->charging = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1data_1t_1charging_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->charging);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1power_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_power_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_power_data_t *)new player_power_data_t();
    
    *(player_power_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1power_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_power_data_t *arg1 = (player_power_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1chargepolicy_1config_1t_1enable_1input_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_power_chargepolicy_config_t *arg1 = (player_power_chargepolicy_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_chargepolicy_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable_input = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1chargepolicy_1config_1t_1enable_1input_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_power_chargepolicy_config_t *arg1 = (player_power_chargepolicy_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_chargepolicy_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable_input);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1chargepolicy_1config_1t_1enable_1output_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_power_chargepolicy_config_t *arg1 = (player_power_chargepolicy_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_chargepolicy_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable_output = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1power_1chargepolicy_1config_1t_1enable_1output_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_power_chargepolicy_config_t *arg1 = (player_power_chargepolicy_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_chargepolicy_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable_output);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1power_1chargepolicy_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_power_chargepolicy_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_power_chargepolicy_config_t *)new player_power_chargepolicy_config_t();
    
    *(player_power_chargepolicy_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1power_1chargepolicy_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_power_chargepolicy_config_t *arg1 = (player_power_chargepolicy_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_power_chargepolicy_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1MAX_1CONFIG_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1VELOCITY_1CONTROL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1POSITION_1CONTROL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1REQ_1GENERIC_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1REQ_1CONTROL_1MODE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1REQ_1AUTOSERVO_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1REQ_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1DATA_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1PTZ_1CMD_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1pan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pan = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1pan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pan);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1tilt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->tilt = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1tilt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->tilt);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1zoom_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->zoom = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1zoom_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->zoom);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1panspeed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->panspeed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1panspeed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->panspeed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1tiltspeed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->tiltspeed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1data_1t_1tiltspeed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->tiltspeed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ptz_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ptz_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ptz_data_t *)new player_ptz_data_t();
    
    *(player_ptz_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ptz_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ptz_data_t *arg1 = (player_ptz_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1pan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->pan = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1pan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->pan);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1tilt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->tilt = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1tilt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->tilt);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1zoom_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->zoom = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1zoom_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->zoom);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1panspeed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->panspeed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1panspeed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->panspeed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1tiltspeed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->tiltspeed = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1cmd_1t_1tiltspeed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    result = (float) ((arg1)->tiltspeed);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ptz_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ptz_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ptz_cmd_t *)new player_ptz_cmd_t();
    
    *(player_ptz_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ptz_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ptz_cmd_t *arg1 = (player_ptz_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1geom_1t_1pos_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ptz_geom_t *arg1 = (player_ptz_geom_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_geom_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pos = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1geom_1t_1pos_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ptz_geom_t *arg1 = (player_ptz_geom_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_geom_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pos);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1geom_1t_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ptz_geom_t *arg1 = (player_ptz_geom_t *) 0 ;
    player_bbox3d_t *arg2 = (player_bbox3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_geom_t **)(void *)&jarg1; 
    arg2 = *(player_bbox3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->size = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1geom_1t_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ptz_geom_t *arg1 = (player_ptz_geom_t *) 0 ;
    player_bbox3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_geom_t **)(void *)&jarg1; 
    result = (player_bbox3d_t *)& ((arg1)->size);
    
    *(player_bbox3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ptz_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ptz_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ptz_geom_t *)new player_ptz_geom_t();
    
    *(player_ptz_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ptz_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ptz_geom_t *arg1 = (player_ptz_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1generic_1t_1config_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ptz_req_generic_t *arg1 = (player_ptz_req_generic_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_generic_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->config_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1generic_1t_1config_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ptz_req_generic_t *arg1 = (player_ptz_req_generic_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_generic_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->config_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1generic_1t_1config_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_ptz_req_generic_t *arg1 = (player_ptz_req_generic_t *) 0 ;
    uint32_t *arg2 ;
    jlong *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_generic_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUint(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint32_t *b = (uint32_t *) arg1->config;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint32_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUint(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1generic_1t_1config_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_ptz_req_generic_t *arg1 = (player_ptz_req_generic_t *) 0 ;
    uint32_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_generic_t **)(void *)&jarg1; 
    result = (uint32_t *)(uint32_t *) ((arg1)->config);
    
    jresult = SWIG_JavaArrayOutUint(jenv, result, 32); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ptz_1req_1generic_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ptz_req_generic_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ptz_req_generic_t *)new player_ptz_req_generic_t();
    
    *(player_ptz_req_generic_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ptz_1req_1generic_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ptz_req_generic_t *arg1 = (player_ptz_req_generic_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_generic_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1control_1mode_1t_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_ptz_req_control_mode_t *arg1 = (player_ptz_req_control_mode_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_control_mode_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mode = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1ptz_1req_1control_1mode_1t_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_ptz_req_control_mode_t *arg1 = (player_ptz_req_control_mode_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_control_mode_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mode);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1ptz_1req_1control_1mode_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_ptz_req_control_mode_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_ptz_req_control_mode_t *)new player_ptz_req_control_mode_t();
    
    *(player_ptz_req_control_mode_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1ptz_1req_1control_1mode_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_ptz_req_control_mode_t *arg1 = (player_ptz_req_control_mode_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_ptz_req_control_mode_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1IDENTIFIER_1MAXLEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1SET_1POSE2D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1GET_1POSE2D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1SET_1PROPERTY_1INT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1GET_1PROPERTY_1INT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1SET_1PROPERTY_1FLOAT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1GET_1PROPERTY_1FLOAT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1SET_1PROPERTY_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SIMULATION_1REQ_1GET_1PROPERTY_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1data_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_simulation_data_t *arg1 = (player_simulation_data_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_data_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->data = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1data_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_simulation_data_t *arg1 = (player_simulation_data_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_data_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->data);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_data_t *)new player_simulation_data_t();
    
    *(player_simulation_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_data_t *arg1 = (player_simulation_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1cmd_1t_1cmd_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_simulation_cmd_t *arg1 = (player_simulation_cmd_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_cmd_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->cmd = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1cmd_1t_1cmd_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_simulation_cmd_t *arg1 = (player_simulation_cmd_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_cmd_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->cmd);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_cmd_t *)new player_simulation_cmd_t();
    
    *(player_simulation_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_cmd_t *arg1 = (player_simulation_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->name,arg2,64);
        else arg1->name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    player_pose_t *arg2 = (player_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    arg2 = *(player_pose_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1pose2d_1req_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    result = (player_pose_t *)& ((arg1)->pose);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1pose2d_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_pose2d_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_pose2d_req_t *)new player_simulation_pose2d_req_t();
    
    *(player_simulation_pose2d_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1pose2d_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_pose2d_req_t *arg1 = (player_simulation_pose2d_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_pose2d_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->name,arg2,64);
        else arg1->name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1prop_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->prop_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1prop_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->prop_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1prop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->prop,arg2,64);
        else arg1->prop[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1prop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->prop);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1int_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->value);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1property_1int_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_property_int_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_property_int_req_t *)new player_simulation_property_int_req_t();
    
    *(player_simulation_property_int_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1property_1int_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_property_int_req_t *arg1 = (player_simulation_property_int_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_int_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->name,arg2,64);
        else arg1->name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1prop_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->prop_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1prop_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->prop_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1prop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->prop,arg2,64);
        else arg1->prop[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1prop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->prop);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1float_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    result = (double) ((arg1)->value);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1property_1float_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_property_float_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_property_float_req_t *)new player_simulation_property_float_req_t();
    
    *(player_simulation_property_float_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1property_1float_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_property_float_req_t *arg1 = (player_simulation_property_float_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_float_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1name_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->name_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1name_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->name_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->name,arg2,64);
        else arg1->name[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->name);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1prop_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->prop_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1prop_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->prop_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1prop_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->prop,arg2,64);
        else arg1->prop[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1prop_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->prop);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1value_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->value_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1value_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->value_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->value,arg2,64);
        else arg1->value[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1simulation_1property_1string_1req_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->value);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1simulation_1property_1string_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_simulation_property_string_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_simulation_property_string_req_t *)new player_simulation_property_string_req_t();
    
    *(player_simulation_property_string_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1simulation_1property_1string_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_simulation_property_string_req_t *arg1 = (player_simulation_property_string_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_simulation_property_string_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1MAX_1SAMPLES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1REQ_1GET_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1REQ_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1DATA_1RANGES_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SONAR_1DATA_1GEOM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1data_1t_1ranges_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_sonar_data_t *arg1 = (player_sonar_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->ranges_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1data_1t_1ranges_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_sonar_data_t *arg1 = (player_sonar_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->ranges_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1data_1t_1ranges_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloatArray jarg2) {
    player_sonar_data_t *arg1 = (player_sonar_data_t *) 0 ;
    float *arg2 ;
    jfloat *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 64) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInFloat(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        float *b = (float *) arg1->ranges;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((float *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutFloat(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jfloatArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1data_1t_1ranges_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloatArray jresult = 0 ;
    player_sonar_data_t *arg1 = (player_sonar_data_t *) 0 ;
    float *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_data_t **)(void *)&jarg1; 
    result = (float *)(float *) ((arg1)->ranges);
    
    jresult = SWIG_JavaArrayOutFloat(jenv, result, 64); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1sonar_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_sonar_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_sonar_data_t *)new player_sonar_data_t();
    
    *(player_sonar_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1sonar_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_sonar_data_t *arg1 = (player_sonar_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1geom_1t_1poses_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_sonar_geom_t *arg1 = (player_sonar_geom_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_geom_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->poses_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1geom_1t_1poses_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_sonar_geom_t *arg1 = (player_sonar_geom_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_geom_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->poses_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1geom_1t_1poses_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_sonar_geom_t *arg1 = (player_sonar_geom_t *) 0 ;
    player_pose_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_geom_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 64) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_pose_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_pose_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_pose_t *b = (player_pose_t *) arg1->poses;
        for (ii = 0; ii < (size_t)64; ii++) b[ii] = *((player_pose_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_pose_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1geom_1t_1poses_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_sonar_geom_t *arg1 = (player_sonar_geom_t *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_geom_t **)(void *)&jarg1; 
    result = (player_pose_t *)(player_pose_t *) ((arg1)->poses);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(64);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<64; i++) {
            arr[i] = 0;
            *(player_pose_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1sonar_1geom_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_sonar_geom_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_sonar_geom_t *)new player_sonar_geom_t();
    
    *(player_sonar_geom_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1sonar_1geom_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_sonar_geom_t *arg1 = (player_sonar_geom_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_geom_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1power_1config_1t_1state_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_sonar_power_config_t *arg1 = (player_sonar_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->state = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sonar_1power_1config_1t_1state_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_sonar_power_config_t *arg1 = (player_sonar_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->state);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1sonar_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_sonar_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_sonar_power_config_t *)new player_sonar_power_config_t();
    
    *(player_sonar_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1sonar_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_sonar_power_config_t *arg1 = (player_sonar_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sonar_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SOUND_1CMD_1IDX_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sound_1cmd_1t_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_sound_cmd_t *arg1 = (player_sound_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sound_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->index = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1sound_1cmd_1t_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_sound_cmd_t *arg1 = (player_sound_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sound_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->index);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1sound_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_sound_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_sound_cmd_t *)new player_sound_cmd_t();
    
    *(player_sound_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1sound_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_sound_cmd_t *arg1 = (player_sound_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_sound_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1MAX_1STRING_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1CMD_1SAY_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1cmd_1t_1string_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_speech_cmd_t *arg1 = (player_speech_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->string_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1cmd_1t_1string_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_speech_cmd_t *arg1 = (player_speech_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->string_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1cmd_1t_1string_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_speech_cmd_t *arg1 = (player_speech_cmd_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_cmd_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->string,arg2,256);
        else arg1->string[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1cmd_1t_1string_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_speech_cmd_t *arg1 = (player_speech_cmd_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_cmd_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->string);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1speech_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_speech_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_speech_cmd_t *)new player_speech_cmd_t();
    
    *(player_speech_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1speech_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_speech_cmd_t *arg1 = (player_speech_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1RECOGNITION_1TEXT_1LEN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 256;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1SPEECH_1RECOGNITION_1DATA_1STRING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1recognition_1data_1t_1text_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_speech_recognition_data_t *arg1 = (player_speech_recognition_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_recognition_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->text_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1recognition_1data_1t_1text_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_speech_recognition_data_t *arg1 = (player_speech_recognition_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_recognition_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->text_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1recognition_1data_1t_1text_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_speech_recognition_data_t *arg1 = (player_speech_recognition_data_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_recognition_data_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->text,arg2,256);
        else arg1->text[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1speech_1recognition_1data_1t_1text_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_speech_recognition_data_t *arg1 = (player_speech_recognition_data_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_recognition_data_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->text);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1speech_1recognition_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_speech_recognition_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_speech_recognition_data_t *)new player_speech_recognition_data_t();
    
    *(player_speech_recognition_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1speech_1recognition_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_speech_recognition_data_t *arg1 = (player_speech_recognition_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_speech_recognition_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1DATA_1POSE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x01;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1DATA_1FIDUCIAL_1ID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x02;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1REQ_1SET_1POSE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x03;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1REQ_1SET_1FIDUCIAL_1ID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x04;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1TRUTH_1REQ_1GET_1FIDUCIAL_1ID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x05;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1pose_1t_1pose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_truth_pose_t *arg1 = (player_truth_pose_t *) 0 ;
    player_pose3d_t *arg2 = (player_pose3d_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_pose_t **)(void *)&jarg1; 
    arg2 = *(player_pose3d_t **)(void *)&jarg2; 
    if (arg1) (arg1)->pose = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1pose_1t_1pose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_truth_pose_t *arg1 = (player_truth_pose_t *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_pose_t **)(void *)&jarg1; 
    result = (player_pose3d_t *)& ((arg1)->pose);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1truth_1pose_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_truth_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_truth_pose_t *)new player_truth_pose_t();
    
    *(player_truth_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1truth_1pose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_truth_pose_t *arg1 = (player_truth_pose_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_pose_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1fiducial_1id_1t_1subtype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_truth_fiducial_id_t *arg1 = (player_truth_fiducial_id_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_fiducial_id_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->subtype = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1fiducial_1id_1t_1subtype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_truth_fiducial_id_t *arg1 = (player_truth_fiducial_id_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_fiducial_id_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->subtype);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1fiducial_1id_1t_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_truth_fiducial_id_t *arg1 = (player_truth_fiducial_id_t *) 0 ;
    int16_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_fiducial_id_t **)(void *)&jarg1; 
    arg2 = (int16_t)jarg2; 
    if (arg1) (arg1)->id = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1truth_1fiducial_1id_1t_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_truth_fiducial_id_t *arg1 = (player_truth_fiducial_id_t *) 0 ;
    int16_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_fiducial_id_t **)(void *)&jarg1; 
    result = (int16_t) ((arg1)->id);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1truth_1fiducial_1id_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_truth_fiducial_id_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_truth_fiducial_id_t *)new player_truth_fiducial_id_t();
    
    *(player_truth_fiducial_id_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1truth_1fiducial_1id_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_truth_fiducial_id_t *arg1 = (player_truth_fiducial_id_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_truth_fiducial_id_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WAVEFORM_1DATA_1MAX_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4096;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WAVEFORM_1DATA_1SAMPLE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1rate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->rate = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1rate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->rate);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1depth_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->depth = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1depth_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->depth);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1data_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->data_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1data_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->data_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1data_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 4096) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->data;
        for (ii = 0; ii < (size_t)4096; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1waveform_1data_1t_1data_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->data);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 4096); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1waveform_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_waveform_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_waveform_data_t *)new player_waveform_data_t();
    
    *(player_waveform_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1waveform_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_waveform_data_t *arg1 = (player_waveform_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_waveform_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MAX_1LINKS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 32;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1QUAL_1DBM_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1QUAL_1REL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1QUAL_1UNKNOWN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1UNKNOWN_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1AUTO_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1ADHOC_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1INFRA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1MASTER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1REPEAT_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MODE_1SECOND_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1MAC_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1IWSPY_1ADD_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1IWSPY_1DEL_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1IWSPY_1PING_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WIFI_1DATA_1STATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mac_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mac_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mac_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mac_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mac_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->mac;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mac_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->mac);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1ip_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->ip_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1ip_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->ip_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1ip_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->ip;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1ip_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->ip);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1essid_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->essid_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1essid_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->essid_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1essid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->essid;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1essid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->essid);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mode = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mode);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1freq_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->freq = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1freq_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->freq);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1encrypt_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->encrypt = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1encrypt_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->encrypt);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1qual_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->qual = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1qual_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->qual);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1level_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->level = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1level_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->level);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1noise_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->noise = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1link_1t_1noise_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->noise);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wifi_1link_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wifi_link_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wifi_link_t *)new player_wifi_link_t();
    
    *(player_wifi_link_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wifi_1link_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wifi_link_t *arg1 = (player_wifi_link_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_link_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1links_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->links_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1links_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->links_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1links_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    player_wifi_link_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 32) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_wifi_link_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_wifi_link_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_wifi_link_t *b = (player_wifi_link_t *) arg1->links;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((player_wifi_link_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_wifi_link_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1links_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    player_wifi_link_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (player_wifi_link_t *)(player_wifi_link_t *) ((arg1)->links);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(32);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<32; i++) {
            arr[i] = 0;
            *(player_wifi_link_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1throughput_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->throughput = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1throughput_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->throughput);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1bitrate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->bitrate = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1bitrate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->bitrate);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1mode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mode = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1mode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mode);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1qual_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->qual_type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1qual_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->qual_type);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxqual_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->maxqual = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxqual_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->maxqual);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxlevel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->maxlevel = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxlevel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->maxlevel);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxnoise_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->maxnoise = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1maxnoise_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->maxnoise);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1ap_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->ap,arg2,32);
        else arg1->ap[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1data_1t_1ap_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->ap);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wifi_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wifi_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wifi_data_t *)new player_wifi_data_t();
    
    *(player_wifi_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wifi_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wifi_data_t *arg1 = (player_wifi_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1mac_1req_1t_1mac_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wifi_mac_req_t *arg1 = (player_wifi_mac_req_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_mac_req_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->mac_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1mac_1req_1t_1mac_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wifi_mac_req_t *arg1 = (player_wifi_mac_req_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_mac_req_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->mac_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1mac_1req_1t_1mac_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshortArray jarg2) {
    player_wifi_mac_req_t *arg1 = (player_wifi_mac_req_t *) 0 ;
    uint8_t *arg2 ;
    jshort *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_mac_req_t **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 32) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInUchar(jenv, &jarr2, &arg2, jarg2)) return ; 
    {
        size_t ii;
        uint8_t *b = (uint8_t *) arg1->mac;
        for (ii = 0; ii < (size_t)32; ii++) b[ii] = *((uint8_t *) arg2 + ii);
    }
    SWIG_JavaArrayArgoutUchar(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jshortArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1mac_1req_1t_1mac_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshortArray jresult = 0 ;
    player_wifi_mac_req_t *arg1 = (player_wifi_mac_req_t *) 0 ;
    uint8_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_mac_req_t **)(void *)&jarg1; 
    result = (uint8_t *)(uint8_t *) ((arg1)->mac);
    
    jresult = SWIG_JavaArrayOutUchar(jenv, result, 32); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wifi_1mac_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wifi_mac_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wifi_mac_req_t *)new player_wifi_mac_req_t();
    
    *(player_wifi_mac_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wifi_1mac_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wifi_mac_req_t *arg1 = (player_wifi_mac_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_mac_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1iwspy_1addr_1req_1t_1address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_wifi_iwspy_addr_req_t *arg1 = (player_wifi_iwspy_addr_req_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_iwspy_addr_req_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->address,arg2,32);
        else arg1->address[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wifi_1iwspy_1addr_1req_1t_1address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_wifi_iwspy_addr_req_t *arg1 = (player_wifi_iwspy_addr_req_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_iwspy_addr_req_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->address);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wifi_1iwspy_1addr_1req_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wifi_iwspy_addr_req_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wifi_iwspy_addr_req_t *)new player_wifi_iwspy_addr_req_t();
    
    *(player_wifi_iwspy_addr_req_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wifi_1iwspy_1addr_1req_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wifi_iwspy_addr_req_t *arg1 = (player_wifi_iwspy_addr_req_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wifi_iwspy_addr_req_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1MAX_1TAGS_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 30;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1MAX_1GUID_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1REQ_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1REQ_1READTAG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1REQ_1WRITETAG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1RFID_1REQ_1LOCKTAG_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->type);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1guid_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->guid_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1guid_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->guid_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1guid_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        if (arg2) strncpy(arg1->guid,arg2,8);
        else arg1->guid[0] = 0;
    }
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jstring JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1tag_1t_1guid_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    result = (char *)(char *) ((arg1)->guid);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1rfid_1tag_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_rfid_tag_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_rfid_tag_t *)new player_rfid_tag_t();
    
    *(player_rfid_tag_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1rfid_1tag_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_rfid_tag_t *arg1 = (player_rfid_tag_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_tag_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1data_1t_1tags_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_rfid_data_t *arg1 = (player_rfid_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->tags_count = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1data_1t_1tags_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_rfid_data_t *arg1 = (player_rfid_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->tags_count);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1data_1t_1tags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlongArray jarg2) {
    player_rfid_data_t *arg1 = (player_rfid_data_t *) 0 ;
    player_rfid_tag_t *arg2 ;
    jlong *jarr2 ;
    jsize sz2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_data_t **)(void *)&jarg1; 
    {
        int i;
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
            return ;
        }
        sz2 = jenv->GetArrayLength(jarg2);
        if (sz2 != 30) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
            return ;
        }
        jarr2 = jenv->GetLongArrayElements(jarg2, 0);
        if (!jarr2) {
            return ;
        }
        
        arg2 = new player_rfid_tag_t[sz2];
        
        
        
        if (!arg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
            return ;
        }
        for (i=0; i<sz2; i++) {
            arg2[i] = **(player_rfid_tag_t **)(void *)&jarr2[i];
        }
    }
    {
        size_t ii;
        player_rfid_tag_t *b = (player_rfid_tag_t *) arg1->tags;
        for (ii = 0; ii < (size_t)30; ii++) b[ii] = *((player_rfid_tag_t *) arg2 + ii);
    }
    {
        int i;
        for (i=0; i<sz2; i++) {
            jarr2[i] = 0;
            *(player_rfid_tag_t **)(void *)&jarr2[i] = &arg2[i];
        }
        jenv->ReleaseLongArrayElements(jarg2, jarr2, 0);
    }
    delete [] arg2; 
}


JNIEXPORT jlongArray JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1data_1t_1tags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlongArray jresult = 0 ;
    player_rfid_data_t *arg1 = (player_rfid_data_t *) 0 ;
    player_rfid_tag_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_data_t **)(void *)&jarg1; 
    result = (player_rfid_tag_t *)(player_rfid_tag_t *) ((arg1)->tags);
    
    {
        jlong *arr;
        int i;
        jresult = jenv->NewLongArray(30);
        if (!jresult) {
            return 0;
        }
        arr = jenv->GetLongArrayElements(jresult, 0);
        if (!arr) {
            return 0;
        }
        for (i=0; i<30; i++) {
            arr[i] = 0;
            *(player_rfid_tag_t **)(void *)&arr[i] = &result[i];
        }
        jenv->ReleaseLongArrayElements(jresult, arr, 0);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1rfid_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_rfid_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_rfid_data_t *)new player_rfid_data_t();
    
    *(player_rfid_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1rfid_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_rfid_data_t *arg1 = (player_rfid_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1cmd_1t_1temp_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_rfid_cmd_t *arg1 = (player_rfid_cmd_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_cmd_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->temp = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1rfid_1cmd_1t_1temp_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_rfid_cmd_t *arg1 = (player_rfid_cmd_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_cmd_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->temp);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1rfid_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_rfid_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_rfid_cmd_t *)new player_rfid_cmd_t();
    
    *(player_rfid_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1rfid_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_rfid_cmd_t *arg1 = (player_rfid_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_rfid_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1DATA_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1CMD_1DEVSTATE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1REQ_1POWER_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1REQ_1DATATYPE_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PLAYER_1WSN_1REQ_1DATAFREQ_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1light_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->light = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1light_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->light);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1mic_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->mic = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1mic_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->mic);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->accel_x = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->accel_x);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->accel_y = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->accel_y);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1z_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->accel_z = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1accel_1z_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->accel_z);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1x_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->magn_x = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1x_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->magn_x);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1y_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->magn_y = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1y_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->magn_y);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1z_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->magn_z = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1magn_1z_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->magn_z);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1temperature_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->temperature = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1temperature_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->temperature);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1battery_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    arg2 = (float)jarg2; 
    if (arg1) (arg1)->battery = arg2;
    
}


JNIEXPORT jfloat JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1node_1data_1t_1battery_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jfloat jresult = 0 ;
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    float result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    result = (float) ((arg1)->battery);
    
    jresult = (jfloat)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1node_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_node_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_node_data_t *)new player_wsn_node_data_t();
    
    *(player_wsn_node_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1node_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_node_data_t *arg1 = (player_wsn_node_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_node_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->node_type = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->node_type);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->node_id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->node_id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1parent_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->node_parent_id = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1node_1parent_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->node_parent_id);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1data_1packet_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    player_wsn_node_data_t *arg2 = (player_wsn_node_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    arg2 = *(player_wsn_node_data_t **)(void *)&jarg2; 
    if (arg1) (arg1)->data_packet = *arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1data_1t_1data_1packet_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    player_wsn_node_data_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    result = (player_wsn_node_data_t *)& ((arg1)->data_packet);
    
    *(player_wsn_node_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1data_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_data_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_data_t *)new player_wsn_data_t();
    
    *(player_wsn_data_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1data_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_data_t *arg1 = (player_wsn_data_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_data_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1node_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->node_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1node_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->node_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1group_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->group_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1group_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->group_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1device_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    uint32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    arg2 = (uint32_t)jarg2; 
    if (arg1) (arg1)->device = arg2;
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1device_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    uint32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    result = (uint32_t) ((arg1)->device);
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1enable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->enable = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1cmd_1t_1enable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->enable);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1cmd_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_cmd_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_cmd_t *)new player_wsn_cmd_t();
    
    *(player_wsn_cmd_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1cmd_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_cmd_t *arg1 = (player_wsn_cmd_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_cmd_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1node_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->node_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1node_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->node_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1group_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->group_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1group_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->group_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1power_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1power_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_power_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_power_config_t *)new player_wsn_power_config_t();
    
    *(player_wsn_power_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1power_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_power_config_t *arg1 = (player_wsn_power_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_power_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datatype_1config_1t_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jshort jarg2) {
    player_wsn_datatype_config_t *arg1 = (player_wsn_datatype_config_t *) 0 ;
    uint8_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datatype_config_t **)(void *)&jarg1; 
    arg2 = (uint8_t)jarg2; 
    if (arg1) (arg1)->value = arg2;
    
}


JNIEXPORT jshort JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datatype_1config_1t_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jshort jresult = 0 ;
    player_wsn_datatype_config_t *arg1 = (player_wsn_datatype_config_t *) 0 ;
    uint8_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datatype_config_t **)(void *)&jarg1; 
    result = (uint8_t) ((arg1)->value);
    
    jresult = (jshort)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1datatype_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_datatype_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_datatype_config_t *)new player_wsn_datatype_config_t();
    
    *(player_wsn_datatype_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1datatype_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_datatype_config_t *arg1 = (player_wsn_datatype_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datatype_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1node_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->node_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1node_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->node_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1group_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    int32_t arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    arg2 = (int32_t)jarg2; 
    if (arg1) (arg1)->group_id = arg2;
    
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1group_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    int32_t result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    result = (int32_t) ((arg1)->group_id);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1frequency_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    double arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    if (arg1) (arg1)->frequency = arg2;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1wsn_1datafreq_1config_1t_1frequency_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    result = (double) ((arg1)->frequency);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_new_1player_1wsn_1datafreq_1config_1t(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    player_wsn_datafreq_config_t *result;
    
    (void)jenv;
    (void)jcls;
    result = (player_wsn_datafreq_config_t *)new player_wsn_datafreq_config_t();
    
    *(player_wsn_datafreq_config_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1player_1wsn_1datafreq_1config_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    player_wsn_datafreq_config_t *arg1 = (player_wsn_datafreq_config_t *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_wsn_datafreq_config_t **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT jdouble JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_M_1PI_1get(JNIEnv *jenv, jclass jcls) {
    jdouble jresult = 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    result = (double) 3.14159265358979323846;
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PlayerTime_1GetTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    PlayerTime *arg1 = (PlayerTime *) 0 ;
    timeval *arg2 = (timeval *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTime **)(void *)&jarg1; 
    arg2 = *(timeval **)(void *)&jarg2; 
    result = (int)(arg1)->GetTime(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_PlayerTime_1GetTimeDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    PlayerTime *arg1 = (PlayerTime *) 0 ;
    double *arg2 = (double *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTime **)(void *)&jarg1; 
    arg2 = *(double **)(void *)&jarg2; 
    result = (int)(arg1)->GetTimeDouble(arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_delete_1PlayerTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    PlayerTime *arg1 = (PlayerTime *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(PlayerTime **)(void *)&jarg1; 
    delete arg1;
    
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_packedaddr_1to_1dottedip(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
    char *arg1 = (char *) 0 ;
    size_t arg2 ;
    uint32_t arg3 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return ;
        }
    }
    arg2 = (size_t)jarg2; 
    arg3 = (uint32_t)jarg3; 
    packedaddr_to_dottedip(arg1,arg2,arg3);
    
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
}


JNIEXPORT void JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1register_1drivers(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    player_register_drivers();
    
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_devaddr_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1devaddr_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_devaddr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_devaddr_t *)buf_to_player_devaddr_t(arg1);
    
    *(player_devaddr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1devaddr_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_devaddr_t *arg1 = (player_devaddr_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_devaddr_t **)(void *)&jarg1; 
    result = (void *)player_devaddr_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_msghdr_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1msghdr_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_msghdr_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_msghdr_t *)buf_to_player_msghdr_t(arg1);
    
    *(player_msghdr_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1msghdr_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_msghdr_t *arg1 = (player_msghdr_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_msghdr_t **)(void *)&jarg1; 
    result = (void *)player_msghdr_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_point_2d_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1point_12d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_point_2d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_point_2d_t *)buf_to_player_point_2d_t(arg1);
    
    *(player_point_2d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_12d_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_point_2d_t *arg1 = (player_point_2d_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_2d_t **)(void *)&jarg1; 
    result = (void *)player_point_2d_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_point_3d_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1point_13d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_point_3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_point_3d_t *)buf_to_player_point_3d_t(arg1);
    
    *(player_point_3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1point_13d_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_point_3d_t *arg1 = (player_point_3d_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_point_3d_t **)(void *)&jarg1; 
    result = (void *)player_point_3d_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_pose_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1pose_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_pose_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_pose_t *)buf_to_player_pose_t(arg1);
    
    *(player_pose_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_pose_t *arg1 = (player_pose_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose_t **)(void *)&jarg1; 
    result = (void *)player_pose_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_pose3d_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1pose3d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_pose3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_pose3d_t *)buf_to_player_pose3d_t(arg1);
    
    *(player_pose3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1pose3d_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_pose3d_t *arg1 = (player_pose3d_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_pose3d_t **)(void *)&jarg1; 
    result = (void *)player_pose3d_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_bbox_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1bbox_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_bbox_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_bbox_t *)buf_to_player_bbox_t(arg1);
    
    *(player_bbox_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bbox_t *arg1 = (player_bbox_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox_t **)(void *)&jarg1; 
    result = (void *)player_bbox_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_bbox3d_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1bbox3d_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_bbox3d_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_bbox3d_t *)buf_to_player_bbox3d_t(arg1);
    
    *(player_bbox3d_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bbox3d_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bbox3d_t *arg1 = (player_bbox3d_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bbox3d_t **)(void *)&jarg1; 
    result = (void *)player_bbox3d_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_segment_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1segment_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_segment_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_segment_t *)buf_to_player_segment_t(arg1);
    
    *(player_segment_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1segment_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_segment_t *arg1 = (player_segment_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_segment_t **)(void *)&jarg1; 
    result = (void *)player_segment_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_color_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1color_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_color_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_color_t *)buf_to_player_color_t(arg1);
    
    *(player_color_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1color_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_color_t *arg1 = (player_color_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_color_t **)(void *)&jarg1; 
    result = (void *)player_color_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bool_1t_1sizeof(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    size_t result;
    
    (void)jenv;
    (void)jcls;
    result = player_bool_t_sizeof();
    
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_buf_1to_1player_1bool_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    void *arg1 = (void *) 0 ;
    player_bool_t *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(void **)(void *)&jarg1; 
    result = (player_bool_t *)buf_to_player_bool_t(arg1);
    
    *(player_bool_t **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_net_sourceforge_playerstage_Jplayercore_playercore_1javaJNI_player_1bool_1t_1to_1buf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    player_bool_t *arg1 = (player_bool_t *) 0 ;
    void *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(player_bool_t **)(void *)&jarg1; 
    result = (void *)player_bool_t_to_buf(arg1);
    
    *(void **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNI