/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file sdl_music.hpp
 * \brief A class representing a music. This class uses the SDL_mixer library.
 * \author Julien Jorge
 */
#ifndef __AUDIO_SDL_MUSIC_HPP__
#define __AUDIO_SDL_MUSIC_HPP__

#include "audio/music.hpp"

#include <SDL/SDL_mixer.h>
#include <iostream>

#include "audio/class_export.hpp"

namespace bear
{
  namespace audio
  {
    /**
     * \brief A class representing a music.
     */
    class AUDIO_EXPORT sdl_music : public music
    {
    public:
      sdl_music( std::istream& file );
      ~sdl_music();

      void play();
      void stop();

    private:
      /** \brief The music allocated by SDL_mixer. */
      Mix_Music* m_music;

      /** \brief RW structure used by SDL_mixer. */
      SDL_RWops* m_sdl_rw;

      /** \brief The content of the file that we play. */
      char* m_data;

    }; // class sdl_music
  } // namespace audio
} // namespace bear

#endif // __AUDIO_SDL_MUSIC_HPP__
