/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_kill_player.hpp
 * \brief A collision event who kills the player.
 * \author Julien Jorge
 */
#ifndef __ENGINE_COLLISION_EVENT_KILL_PLAYER_HPP__
#define __ENGINE_COLLISION_EVENT_KILL_PLAYER_HPP__

#include "universe/collision_event/collision_event.hpp"
#include "engine/collision_event/uniform_generator.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A collision event who kills the player.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT collision_event_kill_player :
      public universe::collision_event
    {
    private:
      typedef universe::collision_event super;

    public:
      virtual void execute
      ( const universe::collision_info& info,
        universe::physical_item& self, universe::physical_item& that ) const;

    }; // class collision_event_kill_player

    /**
     * \brief Event generator for collision_event_kill_player.
     * \author Julien Jorge
     */
    typedef
    uniform_generator<collision_event_kill_player> kill_player_generator;

  } // namespace engine
} // namespace bear

#endif // __ENGINE_COLLISION_EVENT_KILL_PLAYER_HPP__
