/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file font_factory.hpp
 * \brief This class provides a function to create a text::font from a file.
 * \author Julien Jorge
 */
#ifndef __ENGINE_FONT_FACTORY_HPP__
#define __ENGINE_FONT_FACTORY_HPP__

#include "engine/class_export.hpp"
#include "text/font.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief This class provides a function to create a text::font from a file.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT font_factory
    {
    public:
      typedef text::font* font_type;

    public:
      static font_type create( const std::string& font_name );

    }; // class font_factory
  } // namespace engine
} // namespace bear

#endif // __ENGINE_FONT_FACTORY_HPP__
