/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_network_reader.cpp
 * \brief Implementation of the bear::engine::input_network_reader class.
 * \author Julien Jorge
 */
#include "engine/input_reader/input_network_reader.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param player_index The index of the player to control.
 * \param address The address of the distant computer.
 * \param port The port to connect to.
 */
bear::engine::input_network_reader::input_network_reader
( unsigned int player_index, const std::string& address, int port )
  : input_reader( player_index ), m_input(address.c_str(), port)
{
  // nothing to do
} // input_network_reader::input_network_reader()

/*----------------------------------------------------------------------------*/
/**
 * \brief Read inputs and apply them to the player.
 */
void bear::engine::input_network_reader::read_and_apply()
{
  // get the action
  // send the action to the player
} // input_network_reader::read_and_apply()
