/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file item_handle.hpp
 * \brief Safe way to point an item that could die between two use.
 * \author Julien Jorge
 */
#ifndef __ENGINE_ITEM_HANDLE_HPP__
#define __ENGINE_ITEM_HANDLE_HPP__

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    class base_item;

    /**
     * \brief Safe way to point an item that could die between two use.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT item_handle
    {
    public:
      item_handle();
      item_handle( base_item* item );
      item_handle( const item_handle& that );
      ~item_handle();

      bool is_valid();
      base_item* get();
      const base_item* get() const;

      operator bool();
      operator base_item*();
      operator const base_item*() const;

      base_item* operator->();
      item_handle& operator=( base_item* item );
      item_handle& operator=( const item_handle& that );

    private:
      /** \brief The critical item. */
      base_item* m_item;

    }; // class item_handle
  } // namespace engine
} // namespace bear

#endif // __ENGINE_ITEM_HANDLE_HPP__
