/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file level_border.hpp
 * \brief A block that stops only the players, to be set around the level.
 * \author Julien Jorge
 */
#ifndef __ENGINE_LEVEL_BORDER_HPP__
#define __ENGINE_LEVEL_BORDER_HPP__

#include "engine/base_item.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A block that stops only the players, to be set around the level.
     * \author Julien Jorge
     */
    template<typename Event>
    class level_border : public base_item
    {
    private:
      /** \brief The type of the parent class. */
      typedef base_item super;

    public:
      level_border();

      bool is_valid() const;
      bool set_u_integer_field( const std::string& name, unsigned int value );

    }; // class level_border
  } // namespace engine
} // namespace bear

#include "engine/code/level_border.tpp"

#endif // __ENGINE_LEVEL_BORDER_HPP__
