/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file string_base.hpp
 * \brief A singleton class to manage (load, get) string resources.
 * \author Julien Jorge
 */
#ifndef __ENGINE_STRING_BASE_HPP__
#define __ENGINE_STRING_BASE_HPP__

#include <claw/basic_singleton.hpp>
#include <iostream>
#include <map>
#include <string>

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief The string_base contains all strings appearing in the game.
     *
     * The base can be built from a file containing lines formated as this :
     *
     * <tt> name_of_the_string : content_of_the_string </tt>
     *
     * Lines begining with '#' are skipped. Substrings "\t", "\n" are converted
     * to the equivalent C escape character.
     *
     * \author Julien Jorge
     */
    class ENGINE_EXPORT string_base:
      public claw::concept::basic_singleton<string_base>
    {
    private:
      /** \brief The type of the parent class. */
      typedef claw::concept::basic_singleton<string_base> super;

      typedef std::map<std::string, std::string> string_map;

    public:
      // Must be redefined to work correctly with dynamic libraries.
      // At least under Windows with MinGW.
      static string_base& get_instance();

      void load( std::istream& is );

      void get_string( std::string& name ) const;

    private:
      void escape( std::string& str ) const;

    private:
      /** \brief The string returned for a request on a not existing string. */
      static const std::string s_missing;

      /** \brief String resources. */
      string_map m_strings;

    }; // class string_base
  } // namespace engine
} // namespace bear

#endif // __ENGINE_STRING_BASE_HPP__
