/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file window.cpp
 * \brief Implementation of the bear::gui::window class.
 * \author Julien Jorge
 */
#include "gui/window.hpp"

#include <claw/assert.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owner The owner of the window.
 * \param canvas The frame in the window.
 *
 * \remark
 * - The frame will be deleted in the destructor,
 *
 * \pre canvas != NULL
 */
bear::gui::window::window( visual_component* owner, frame* canvas )
  : visual_component(owner), m_canvas(*canvas)
{
  CLAW_PRECOND( canvas != NULL );
  add_component(&m_canvas);
} // window::window()

/*----------------------------------------------------------------------------*/
/**
 * \brief Call this method when you close the window.
 * \return True if the window has been closed.
 */
bool bear::gui::window::close()
{
  return on_close();
} // window::close()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called before closing the window.
 * \return True if the window can be closed.
 */
bool bear::gui::window::on_close()
{
  return true;
} // window::on_close()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called after the component has been resized.
 */
void bear::gui::window::on_resized()
{
  m_canvas.set_size( get_size() );

  if ( m_canvas.get_size() != get_size() )
    set_size( m_canvas.get_size() );
} // window::on_resized()

