/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file menu.hpp
 * \brief A menu is a list of static_text in which only one item is selected.
 * \author Julien Jorge
 */
#ifndef __GUI_MENU_HPP__
#define __GUI_MENU_HPP__

#include "gui/picture.hpp"
#include "gui/static_text.hpp"
#include "text/font.hpp"
#include "visual/sprite.hpp"

#include "gui/class_export.hpp"

namespace bear
{
  namespace gui
  {
    /**
     * \brief A menu is a list of static_text in which only one item is
     *        selected.
     * \author Julien Jorge
     */
    class GUI_EXPORT menu : public visual_component
    {
    public:
      /** \brief The type of the font used to display the text. */
      typedef static_text::font_type font_type;

    public:
      menu( visual_component* owner, visual::sprite* cursor,
            font_type font, unsigned int horizontal_margins = 0,
            unsigned int vertical_margins = 0,
            unsigned int line_space = 0);

      static_text& add();

      static_text& selected();
      unsigned int cursor_position() const;

      static_text& item( unsigned int i );

      void auto_size();

    private:
      void set_items_position();

      void move_up();
      void move_down();
      void align_cursor();

      bool on_key_press( input::keyboard::key_code key );
      bool on_button_press( input::joystick::joy_code button,
                            unsigned int joy_index );
      bool on_mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

    private:
      /** \brief The items in the menu. */
      std::vector<static_text*> m_items;

      /** \brief Index of the selected item. */
      unsigned int m_selected;

      /** \brief The sprite that show the selected item. */
      picture* m_cursor;

      /** \brief The font to use for items. */
      font_type m_font;

      /** \brief The size of the margins. */
      const claw::math::coordinate_2d<unsigned int> m_margins;

      /** \brief The size of the line_space. */
      const unsigned int m_line_space;

    }; // class menu
  } // namespace gui
} // namespace bear

#endif // __GUI_MENU_HPP__
