/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file window.hpp
 * \brief A window is a visual component containing a frame.
 * \author Julien Jorge
 */
#ifndef __GUI_WINDOW_HPP__
#define __GUI_WINDOW_HPP__

#include "gui/frame.hpp"
#include "visual/sprite.hpp"

#include "gui/class_export.hpp"

namespace bear
{
  namespace gui
  {
    /**
     * \brief A window is, actually, just a frame. But it can be changed later.
     * \author Julien Jorge
     */
    class GUI_EXPORT window : public visual_component
    {
    public:
      window( visual_component* owner, frame* canvas );

      bool close();

    protected:
      virtual bool on_close();

    private:
      void on_resized();

    private:
      /** \brief The frame containing the. */
      frame& m_canvas;

    }; // class window
  } // namespace gui
} // namespace bear

#endif // __GUI_WINDOW_HPP__
