/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_status.cpp
 * \brief Implementation of the bear::input::input_status class.
 * \author Julien Jorge
 */
#include "input/input_status.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Read the status of the keys.
 */
void bear::input::input_status::read()
{
  m_keyboard.read();
  m_joystick.read();
  m_mouse.read();
} // input_status::read()

/*----------------------------------------------------------------------------*/
/**
 * \brief Send the status of the keys to an input_listener.
 * \param listener The listener to pass informations to.
 */
void bear::input::input_status::scan_inputs( input_listener& listener ) const
{
  m_keyboard.scan_inputs( listener );
  m_joystick.scan_inputs( listener );
  m_mouse.scan_inputs( listener );
} // input_status::scan_inputs()

/*----------------------------------------------------------------------------*/
/**
 * \brief Send the status of the keys to an input_listener and assure that a
 *        maintained key won't be processed two times before it is released.
 * \param listener The listener to pass informations to.
 */
void bear::input::input_status::process_once( input_listener& listener )
{
  m_keyboard.process_once( listener );
  m_joystick.process_once( listener );
  m_mouse.process_once( listener );
} // input_status::process_once()
