/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file keyboard.hpp
 * \brief A class representing a keyboard.
 * \author Julien Jorge
 */
#ifndef __INPUT_KEYBOARD_HPP__
#define __INPUT_KEYBOARD_HPP__

#include <string>
#include <vector>
#include <list>

#include "input/class_export.hpp"

namespace bear
{
  namespace input
  {
    /**
     * \brief A class representing a keyboard.
     */
    class INPUT_EXPORT keyboard
    {
    public:
      /** \brief Code representing a key on the keyboard. */
      typedef unsigned int key_code;

      /** \brief Iterator on the pressed keys. */
      typedef std::list<key_code>::const_iterator const_iterator;

    public:
      keyboard();

      static bool is_symbol( key_code k );
      static char code_to_char( key_code k );

      static const std::string& get_name_of( key_code k );
      static void set_name_of( key_code k, const std::string& s );

      const_iterator begin() const;
      const_iterator end() const;
      bool empty() const;

      // only for input::system
      void refresh();

    private:
      key_code sdl_key_to_local( unsigned int sdl_val, bool shift,
                                 bool alt ) const;

      void default_key_strings();

    public:
#include "input/key_codes.hpp"

    private:
      /** \brief Human-readable names for each key_code. */
      static std::vector<std::string> s_key_strings;

      /** \brief Pressed keys. */
      std::list<key_code> m_pressed_keys;

    }; // class keyboard
  } // namespace input
} // namespace bear

#endif // __INPUT_KEYBOARD_HPP__
