/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_entity.hpp
 * \brief The base class from which all user's items (player, monsters,
 *        bonii, ...) must inherit.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_BASE_ENTITY_HPP__
#define __UNIVERSE_BASE_ENTITY_HPP__

#include "universe/physical_item.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief The base class from which all user's items (player, monsters,
     *        bonii, ...) must inherit.
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT base_entity:
      public physical_item
    {
    public:
      base_entity();
      base_entity( const base_entity& that );
    
      virtual void progress( time_type elapsed_time );

      virtual void left_active_region();
    
      bool is_global() const;
      void set_global( bool global );

    private:
      /** \brief Indicates if the item is global. */
      bool m_is_global;

    }; // class base_entity

  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_BASE_ENTITY_HPP__
